/*
 * Decompiled with CFR 0.152.
 */
package com.belgie.mounts_of_mayhem_plus.common.entity.babyRavager;

import com.belgie.mounts_of_mayhem_plus.common.entity.babyRavager.BabyRavagerRenderState;
import java.util.Set;
import net.minecraft.client.model.BabyModelTransform;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.MeshTransformer;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.util.Mth;

public class BabyRavagerModel
extends EntityModel<BabyRavagerRenderState> {
    public static final MeshTransformer BABY_TRANSFORMER = new BabyModelTransform(true, 24.0f, 0.0f, 1.9f, 2.0f, 24.0f, Set.of("neck"));
    private final ModelPart body;
    private final ModelPart bone;
    private final ModelPart leg1;
    private final ModelPart leg2;
    private final ModelPart leg3;
    private final ModelPart leg4;
    private final ModelPart neck;
    private final ModelPart head;
    private final ModelPart horns;
    private final ModelPart left_horn;

    public BabyRavagerModel(ModelPart root) {
        super(root);
        this.body = root.getChild("body");
        this.bone = this.body.getChild("bone");
        this.leg1 = root.getChild("leg1");
        this.leg2 = root.getChild("leg2");
        this.leg3 = root.getChild("leg3");
        this.leg4 = root.getChild("leg4");
        this.neck = root.getChild("neck");
        this.head = root.getChild("head");
        this.horns = this.head.getChild("horns");
        this.left_horn = this.horns.getChild("left_horn");
    }

    public static LayerDefinition createBodyLayer(float def, boolean isBaby) {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        PartDefinition body = partdefinition.addOrReplaceChild("body", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)11.0f, (float)3.5f));
        PartDefinition bone = body.addOrReplaceChild("bone", CubeListBuilder.create().texOffs(4, 95).addBox(-6.0f, -16.0f, 0.5f, 12.0f, 10.0f, 14.0f, new CubeDeformation(def)).texOffs(4, 59).addBox(-7.0f, -29.0f, -0.5f, 14.0f, 14.0f, 16.0f, new CubeDeformation(def)), PartPose.offsetAndRotation((float)0.0f, (float)4.0f, (float)19.5f, (float)1.5708f, (float)0.0f, (float)0.0f));
        PartDefinition leg1 = partdefinition.addOrReplaceChild("leg1", CubeListBuilder.create().texOffs(96, 0).addBox(-4.0f, 0.0f, -4.0f, 8.0f, 27.0f, 8.0f, new CubeDeformation(def)), PartPose.offset((float)-8.0f, (float)-3.0f, (float)19.0f));
        PartDefinition leg2 = partdefinition.addOrReplaceChild("leg2", CubeListBuilder.create().texOffs(96, 0).mirror().addBox(-4.0f, 0.0f, -4.0f, 8.0f, 27.0f, 8.0f, new CubeDeformation(def)).mirror(false), PartPose.offset((float)8.0f, (float)-3.0f, (float)19.0f));
        PartDefinition leg3 = partdefinition.addOrReplaceChild("leg3", CubeListBuilder.create().texOffs(64, 0).addBox(-4.0f, 0.0f, -3.9f, 8.0f, 27.0f, 8.0f, new CubeDeformation(def)), PartPose.offset((float)-8.0f, (float)-3.0f, (float)-2.5f));
        PartDefinition leg4 = partdefinition.addOrReplaceChild("leg4", CubeListBuilder.create().texOffs(64, 0).mirror().addBox(-4.0f, 0.0f, -3.9f, 8.0f, 27.0f, 8.0f, new CubeDeformation(def)).mirror(false), PartPose.offset((float)8.0f, (float)-3.0f, (float)-2.5f));
        PartDefinition neck = partdefinition.addOrReplaceChild("neck", CubeListBuilder.create().texOffs(68, 73).addBox(-5.0f, -1.0f, -18.0f, 10.0f, 10.0f, 18.0f, new CubeDeformation(def)), PartPose.offset((float)0.0f, (float)4.0f, (float)8.0f));
        PartDefinition head = partdefinition.addOrReplaceChild("head", CubeListBuilder.create().texOffs(3, 5).addBox(-8.0f, -7.0f, -12.0f, 16.0f, 16.0f, 13.0f, new CubeDeformation(0.0f)).texOffs(2, 0).addBox(-2.0f, 5.0f, -14.0f, 4.0f, 6.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)5.0f, (float)-7.0f));
        PartDefinition horns = head.addOrReplaceChild("horns", CubeListBuilder.create().texOffs(74, 54).addBox(-5.0f, -9.0858f, -0.0777f, 5.0f, 14.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-5.0f, (float)-3.0f, (float)-11.0f, (float)0.7418f, (float)0.0f, (float)0.0f));
        PartDefinition left_horn = horns.addOrReplaceChild("left_horn", CubeListBuilder.create().texOffs(74, 54).mirror().addBox(5.0f, -36.0858f, -19.0777f, 5.0f, 14.0f, 5.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offset((float)5.0f, (float)27.0f, (float)19.0f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)128, (int)128).apply(isBaby ? BABY_TRANSFORMER : MeshTransformer.IDENTITY);
    }

    public static LayerDefinition createSaddle(boolean isBaby) {
        return BabyRavagerModel.createBodyLayer(0.5f, isBaby);
    }

    public void setupAnim(BabyRavagerRenderState p_362767_) {
        float f9;
        float f7;
        super.setupAnim((Object)p_362767_);
        this.neck.visible = !p_362767_.isBaby;
        float f = p_362767_.stunnedTicksRemaining;
        float f1 = p_362767_.attackTicksRemaining;
        if (f1 > 0.0f) {
            f7 = Mth.triangleWave((float)f1, (float)10.0f);
            f9 = (1.0f + f7) * 0.5f;
            float f4 = f9 * f9 * f9 * 12.0f;
            float f10 = f4 * Mth.sin((double)this.neck.xRot);
            this.neck.z = -6.5f + f4;
            this.neck.y = -7.0f - f10;
        } else {
            f7 = -1.0f;
            f9 = -1.0f * Mth.sin((double)this.neck.xRot);
            this.neck.x = 0.0f;
            this.neck.y = p_362767_.isBaby ? 12.0f : 2.0f - f9;
            this.neck.z = 5.5f;
            boolean flag = f > 0.0f;
            float f2 = this.neck.xRot = flag ? 0.21991149f : 0.0f;
            if (flag) {
                double d0 = (double)f / 40.0;
                this.neck.x = (float)Math.sin(d0 * 10.0) * 3.0f;
            } else if ((double)p_362767_.roarAnimation > 0.0) {
                float f3 = Mth.sin((double)(p_362767_.roarAnimation * (float)Math.PI * 0.25f));
            }
        }
        this.head.xRot = p_362767_.xRot * ((float)Math.PI / 180);
        this.head.yRot = p_362767_.yRot * ((float)Math.PI / 180);
        f7 = p_362767_.walkAnimationPos;
        f9 = 0.4f * p_362767_.walkAnimationSpeed;
        this.leg2.xRot = Mth.cos((double)(f7 * 0.6662f)) * f9;
        this.leg1.xRot = Mth.cos((double)(f7 * 0.6662f + (float)Math.PI)) * f9;
        this.leg4.xRot = Mth.cos((double)(f7 * 0.6662f + (float)Math.PI)) * f9;
        this.leg3.xRot = Mth.cos((double)(f7 * 0.6662f)) * f9;
    }
}

