/*
 * Decompiled with CFR 0.152.
 */
package com.belgie.mounts_of_mayhem_plus.common.entity.babyRavager;

import com.belgie.mounts_of_mayhem_plus.common.entity.babyRavager.BabyRavagerEntity;
import com.belgie.mounts_of_mayhem_plus.common.entity.babyRavager.BabyRavagerModel;
import com.belgie.mounts_of_mayhem_plus.common.entity.babyRavager.BabyRavagerRenderState;
import com.belgie.mounts_of_mayhem_plus.core.ClientEntityRegistry;
import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.Model;
import net.minecraft.client.model.geom.EntityModelSet;
import net.minecraft.client.renderer.SubmitNodeCollector;
import net.minecraft.client.renderer.entity.AgeableMobRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.renderer.entity.layers.SimpleEquipmentLayer;
import net.minecraft.client.renderer.entity.state.LivingEntityRenderState;
import net.minecraft.client.resources.model.EquipmentClientInfo;
import net.minecraft.resources.Identifier;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;

public class BabyRavagerRenderer
extends AgeableMobRenderer<BabyRavagerEntity, BabyRavagerRenderState, BabyRavagerModel> {
    private static final Identifier CAMEL_LOCATION = Identifier.fromNamespaceAndPath((String)"mounts_of_mayhem_plus", (String)"textures/entity/brutusk.png");

    public BabyRavagerRenderer(EntityRendererProvider.Context p_251790_) {
        super(p_251790_, (EntityModel)new BabyRavagerModel(p_251790_.bakeLayer(ClientEntityRegistry.RAVAGER_BABY)), (EntityModel)new BabyRavagerModel(p_251790_.bakeLayer(ClientEntityRegistry.RAVAGER_BABY_BABY)), 0.7f);
        this.addLayer(new SaddleLayer((RenderLayerParent<BabyRavagerRenderState, BabyRavagerModel>)this, p_251790_.getModelSet()));
        this.addLayer((RenderLayer)new SimpleEquipmentLayer((RenderLayerParent)this, p_251790_.getEquipmentRenderer(), EquipmentClientInfo.LayerType.WOLF_BODY, p_397943_ -> p_397943_.bodyArmorItem, (EntityModel)new BabyRavagerModel(p_251790_.bakeLayer(ClientEntityRegistry.RAVAGER_BABY_ARMOR)), (EntityModel)new BabyRavagerModel(p_251790_.bakeLayer(ClientEntityRegistry.RAVAGER_BABY_ARMOR_BABY)), 2));
    }

    public Identifier getTextureLocation(BabyRavagerRenderState p_364241_) {
        return CAMEL_LOCATION;
    }

    public BabyRavagerRenderState createRenderState() {
        return new BabyRavagerRenderState();
    }

    public void extractRenderState(BabyRavagerEntity p_362547_, BabyRavagerRenderState p_362381_, float p_360896_) {
        super.extractRenderState((LivingEntity)p_362547_, (LivingEntityRenderState)p_362381_, p_360896_);
        p_362381_.saddle = p_362547_.getItemBySlot(EquipmentSlot.SADDLE).copy();
        p_362381_.bodyArmorItem = p_362547_.getItemBySlot(EquipmentSlot.BODY).copy();
        p_362381_.isRidden = p_362547_.isVehicle();
        p_362381_.jumpCooldown = Math.max((float)p_362547_.getJumpCooldown() - p_360896_, 0.0f);
    }

    private static class SaddleLayer
    extends RenderLayer<BabyRavagerRenderState, BabyRavagerModel> {
        private static final Identifier CAT_COLLAR_LOCATION = Identifier.fromNamespaceAndPath((String)"mounts_of_mayhem_plus", (String)"textures/entity/equipment/brutusk_saddle/saddle.png");
        private final BabyRavagerModel adultModel;
        private final BabyRavagerModel babyModel;

        public SaddleLayer(RenderLayerParent<BabyRavagerRenderState, BabyRavagerModel> renderer, EntityModelSet modelSet) {
            super(renderer);
            this.adultModel = new BabyRavagerModel(modelSet.bakeLayer(ClientEntityRegistry.RAVAGER_BABY_SADDLE));
            this.babyModel = new BabyRavagerModel(modelSet.bakeLayer(ClientEntityRegistry.RAVAGER_BABY_SADDLE_BABY));
        }

        public void submit(PoseStack p_434729_, SubmitNodeCollector p_435679_, int p_435603_, BabyRavagerRenderState p_435848_, float p_435437_, float p_432910_) {
            ItemStack stack = p_435848_.saddle;
            if (!stack.isEmpty()) {
                BabyRavagerModel catmodel = p_435848_.isBaby ? this.babyModel : this.adultModel;
                SaddleLayer.coloredCutoutModelCopyLayerRender((Model)catmodel, (Identifier)CAT_COLLAR_LOCATION, (PoseStack)p_434729_, (SubmitNodeCollector)p_435679_, (int)p_435603_, (LivingEntityRenderState)p_435848_, (int)-1, (int)1);
            }
        }
    }
}

