/*
 * Decompiled with CFR 0.152.
 */
package com.belgie.mounts_of_mayhem_plus.common.entity.boggedHorse;

import com.belgie.mounts_of_mayhem_plus.common.variants.BoggedHorseVariant;
import com.belgie.mounts_of_mayhem_plus.core.EntityRegistry;
import com.belgie.mounts_of_mayhem_plus.core.SoundRegistry;
import com.belgie.mounts_of_mayhem_plus.core.VariantsRegistry;
import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.component.DataComponentGetter;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.Identifier;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.EntityAttachment;
import net.minecraft.world.entity.EntityAttachments;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.equine.SkeletonHorse;
import net.minecraft.world.entity.animal.equine.SkeletonTrapGoal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.variant.SpawnContext;
import net.minecraft.world.entity.variant.VariantUtils;
import net.minecraft.world.item.EitherHolder;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;

public class BoggedHorseEntity
extends SkeletonHorse {
    private static final EntityDimensions BABY_DIMENSIONS;
    private final SkeletonTrapGoal skeletonTrapGoal = new SkeletonTrapGoal((SkeletonHorse)this);
    private static final int TRAP_MAX_LIFE = 18000;
    private static final boolean DEFAULT_IS_TRAP = false;
    private static final int DEFAULT_TRAP_TIME = 0;
    private boolean isTrap = false;
    private int trapTime = 0;
    private static final EntityDataAccessor<Holder<BoggedHorseVariant>> DATA_VARIANT_ID;

    public Holder<BoggedHorseVariant> getVariant() {
        return (Holder)this.entityData.get(DATA_VARIANT_ID);
    }

    private void setVariant(Holder<BoggedHorseVariant> variant) {
        this.entityData.set(DATA_VARIANT_ID, variant);
    }

    @Nullable
    public <T> T get(DataComponentType<? extends T> component) {
        return (T)(component == VariantsRegistry.BOGGED_HORSE_VARIANT_COM.get() ? BoggedHorseEntity.castComponentValue(component, (Object)new EitherHolder(this.getVariant())) : super.get(component));
    }

    protected void applyImplicitComponents(DataComponentGetter componentGetter) {
        this.applyImplicitComponentIfPresent(componentGetter, VariantsRegistry.BOGGED_HORSE_VARIANT_COM.get());
        super.applyImplicitComponents(componentGetter);
    }

    protected <T> boolean applyImplicitComponent(DataComponentType<T> component, T value) {
        if (component == VariantsRegistry.BOGGED_HORSE_VARIANT_COM.get()) {
            this.setVariant((Holder<BoggedHorseVariant>)((Holder)BoggedHorseEntity.castComponentValue(VariantsRegistry.BOGGED_HORSE_VARIANT_COM.get(), value)));
            return true;
        }
        return super.applyImplicitComponent(component, value);
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(DATA_VARIANT_ID, (Object)VariantUtils.getDefaultOrAny((RegistryAccess)this.registryAccess(), (ResourceKey)ResourceKey.create(VariantsRegistry.BOGGED_HORSE_VARIANT_REGISTRY_KEY, (Identifier)Identifier.fromNamespaceAndPath((String)"mounts_of_mayhem_plus", (String)"default"))));
    }

    protected void addAdditionalSaveData(ValueOutput output) {
        super.addAdditionalSaveData(output);
        VariantUtils.writeVariant((ValueOutput)output, this.getVariant());
        output.putBoolean("SkeletonTrap", this.isTrap());
        output.putInt("SkeletonTrapTime", this.trapTime);
    }

    protected void readAdditionalSaveData(ValueInput input) {
        super.readAdditionalSaveData(input);
        VariantUtils.readVariant((ValueInput)input, VariantsRegistry.BOGGED_HORSE_VARIANT_REGISTRY_KEY).ifPresent(this::setVariant);
        this.setTrap(input.getBooleanOr("SkeletonTrap", false));
        this.trapTime = input.getIntOr("SkeletonTrapTime", 0);
    }

    @Nullable
    public SpawnGroupData finalizeSpawn(ServerLevelAccessor level, DifficultyInstance difficulty, EntitySpawnReason spawnReason, @Nullable SpawnGroupData spawnGroupData) {
        spawnGroupData = super.finalizeSpawn(level, difficulty, spawnReason, spawnGroupData);
        VariantUtils.selectVariantToSpawn((SpawnContext)SpawnContext.create((ServerLevelAccessor)level, (BlockPos)this.blockPosition()), VariantsRegistry.BOGGED_HORSE_VARIANT_REGISTRY_KEY).ifPresent(this::setVariant);
        return spawnGroupData;
    }

    public BoggedHorseEntity(EntityType<? extends BoggedHorseEntity> p_30894_, Level p_30895_) {
        super(p_30894_, p_30895_);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return BoggedHorseEntity.createBaseHorseAttributes().add(Attributes.MAX_HEALTH, 15.0).add(Attributes.MOVEMENT_SPEED, (double)0.2f);
    }

    public static boolean checkSkeletonHorseSpawnRules(EntityType<? extends Animal> p_478637_, LevelAccessor p_479853_, EntitySpawnReason p_478707_, BlockPos p_480429_, RandomSource p_479425_) {
        return !EntitySpawnReason.isSpawner((EntitySpawnReason)p_478707_) ? Animal.checkAnimalSpawnRules(p_478637_, (LevelAccessor)p_479853_, (EntitySpawnReason)p_478707_, (BlockPos)p_480429_, (RandomSource)p_479425_) : EntitySpawnReason.ignoresLightRequirements((EntitySpawnReason)p_478707_) || BoggedHorseEntity.isBrightEnoughToSpawn((BlockAndTintGetter)p_479853_, (BlockPos)p_480429_);
    }

    protected void randomizeAttributes(RandomSource p_218821_) {
        AttributeInstance var10000 = this.getAttribute(Attributes.JUMP_STRENGTH);
        Objects.requireNonNull(p_218821_);
        var10000.setBaseValue(BoggedHorseEntity.generateJumpStrength(() -> ((RandomSource)p_218821_).nextDouble()));
    }

    protected void addBehaviourGoals() {
    }

    protected SoundEvent getAmbientSound() {
        return this.isEyeInFluid(FluidTags.WATER) ? SoundRegistry.BOGGED_HORSE_AMBIENT_WATER.get() : SoundRegistry.BOGGED_HORSE_AMBIENT.get();
    }

    protected SoundEvent getDeathSound() {
        return SoundRegistry.BOGGED_HORSE_DEATH.get();
    }

    protected SoundEvent getHurtSound(DamageSource damageSource) {
        return SoundRegistry.BOGGED_HORSE_HURT.get();
    }

    protected SoundEvent getSwimSound() {
        if (this.onGround()) {
            if (!this.isVehicle()) {
                return SoundRegistry.BOGGED_HORSE_STEP_WATER.get();
            }
            ++this.gallopSoundCounter;
            if (this.gallopSoundCounter > 5 && this.gallopSoundCounter % 3 == 0) {
                return SoundRegistry.BOGGED_HORSE_GALLOP_WATER.get();
            }
            if (this.gallopSoundCounter <= 5) {
                return SoundRegistry.BOGGED_HORSE_STEP_WATER.get();
            }
        }
        return SoundRegistry.BOGGED_HORSE_SWIM.get();
    }

    public float getVoicePitch() {
        return -2.0f;
    }

    protected void playSwimSound(float volume) {
        if (this.onGround()) {
            super.playSwimSound(0.3f);
        } else {
            super.playSwimSound(Math.min(0.1f, volume * 25.0f));
        }
    }

    protected void playJumpSound() {
        if (this.isInWater()) {
            this.playSound(SoundRegistry.BOGGED_HORSE_JUMP_WATER.get(), 0.4f, 1.0f);
        } else {
            super.playJumpSound();
        }
    }

    public void aiStep() {
        super.aiStep();
        if (this.isTrap() && this.trapTime++ >= 18000) {
            this.discard();
        }
    }

    public EntityDimensions getDefaultDimensions(Pose p_316222_) {
        return this.isBaby() ? BABY_DIMENSIONS : super.getDefaultDimensions(p_316222_);
    }

    protected float getWaterSlowDown() {
        return 0.9f;
    }

    protected float getRiddenSpeed(Player p_278241_) {
        float f = this.level().getBlockState(this.blockPosition().below()).is(Blocks.MUD) ? 0.15f : 0.0f;
        return (float)this.getAttributeValue(Attributes.MOVEMENT_SPEED) + f;
    }

    @Nullable
    public AgeableMob getBreedOffspring(ServerLevel p_149553_, AgeableMob p_149554_) {
        return (AgeableMob)EntityRegistry.BOGGED_SKELETON_HORSE.get().create((Level)p_149553_, EntitySpawnReason.BREEDING);
    }

    public boolean isTrap() {
        return this.isTrap;
    }

    public void setTrap(boolean p_479748_) {
        if (p_479748_ != this.isTrap) {
            this.isTrap = p_479748_;
            if (p_479748_) {
                this.goalSelector.addGoal(1, (Goal)this.skeletonTrapGoal);
            } else {
                this.goalSelector.removeGoal((Goal)this.skeletonTrapGoal);
            }
        }
    }

    public InteractionResult mobInteract(Player p_479528_, InteractionHand p_479285_) {
        return !this.isTamed() ? InteractionResult.PASS : super.mobInteract(p_479528_, p_479285_);
    }

    public boolean canUseSlot(EquipmentSlot p_480066_) {
        return true;
    }

    static {
        DATA_VARIANT_ID = SynchedEntityData.defineId(BoggedHorseEntity.class, VariantsRegistry.BOGGED_HORSE_VARIANT.get());
        BABY_DIMENSIONS = EntityRegistry.BOGGED_SKELETON_HORSE.get().getDimensions().withAttachments(EntityAttachments.builder().attach(EntityAttachment.PASSENGER, 0.0f, EntityRegistry.BOGGED_SKELETON_HORSE.get().getHeight() - 0.03125f, 0.0f)).scale(0.5f);
    }
}

