/*
 * Decompiled with CFR 0.152.
 */
package com.belgie.mounts_of_mayhem_plus.common.entity.chilled;

import com.belgie.mounts_of_mayhem_plus.common.entity.chillifiedPolarBear.ChillifiedPolarBearEntity;
import com.belgie.mounts_of_mayhem_plus.common.variants.ChilledVariant;
import com.belgie.mounts_of_mayhem_plus.core.EntityRegistry;
import com.belgie.mounts_of_mayhem_plus.core.SoundRegistry;
import com.belgie.mounts_of_mayhem_plus.core.VariantsRegistry;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.component.DataComponentGetter;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.Identifier;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.tags.ItemTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.monster.zombie.Zombie;
import net.minecraft.world.entity.variant.SpawnContext;
import net.minecraft.world.entity.variant.VariantUtils;
import net.minecraft.world.item.EitherHolder;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;

public class ChilledEntity
extends Zombie {
    private static final EntityDataAccessor<Holder<ChilledVariant>> DATA_VARIANT_ID = SynchedEntityData.defineId(ChilledEntity.class, VariantsRegistry.CHILLED_VARIANT.get());

    public Holder<ChilledVariant> getVariant() {
        return (Holder)this.entityData.get(DATA_VARIANT_ID);
    }

    private void setVariant(Holder<ChilledVariant> variant) {
        this.entityData.set(DATA_VARIANT_ID, variant);
    }

    @Nullable
    public <T> T get(DataComponentType<? extends T> component) {
        return (T)(component == VariantsRegistry.CHILLED_VARIANT_COM.get() ? ChilledEntity.castComponentValue(component, (Object)new EitherHolder(this.getVariant())) : super.get(component));
    }

    protected void applyImplicitComponents(DataComponentGetter componentGetter) {
        this.applyImplicitComponentIfPresent(componentGetter, VariantsRegistry.CHILLED_VARIANT_COM.get());
        super.applyImplicitComponents(componentGetter);
    }

    protected <T> boolean applyImplicitComponent(DataComponentType<T> component, T value) {
        if (component == VariantsRegistry.CHILLED_VARIANT_COM.get()) {
            this.setVariant((Holder<ChilledVariant>)((Holder)ChilledEntity.castComponentValue(VariantsRegistry.CHILLED_VARIANT_COM.get(), value)));
            return true;
        }
        return super.applyImplicitComponent(component, value);
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(DATA_VARIANT_ID, (Object)VariantUtils.getDefaultOrAny((RegistryAccess)this.registryAccess(), (ResourceKey)ResourceKey.create(VariantsRegistry.CHILLED_VARIANT_REGISTRY_KEY, (Identifier)Identifier.fromNamespaceAndPath((String)"mounts_of_mayhem_plus", (String)"default"))));
    }

    protected void addAdditionalSaveData(ValueOutput output) {
        super.addAdditionalSaveData(output);
        VariantUtils.writeVariant((ValueOutput)output, this.getVariant());
    }

    protected void readAdditionalSaveData(ValueInput input) {
        super.readAdditionalSaveData(input);
        VariantUtils.readVariant((ValueInput)input, VariantsRegistry.CHILLED_VARIANT_REGISTRY_KEY).ifPresent(this::setVariant);
    }

    @Nullable
    public SpawnGroupData finalizeSpawn(ServerLevelAccessor level, DifficultyInstance difficulty, EntitySpawnReason spawnReason, @Nullable SpawnGroupData spawnGroupData) {
        spawnGroupData = super.finalizeSpawn(level, difficulty, spawnReason, spawnGroupData);
        VariantUtils.selectVariantToSpawn((SpawnContext)SpawnContext.create((ServerLevelAccessor)level, (BlockPos)this.blockPosition()), VariantsRegistry.CHILLED_VARIANT_REGISTRY_KEY).ifPresent(this::setVariant);
        RandomSource randomsource = level.getRandom();
        float f = difficulty.getSpecialMultiplier();
        if (spawnReason != EntitySpawnReason.CONVERSION) {
            this.setCanPickUpLoot(randomsource.nextFloat() < 0.55f * f);
        }
        if (spawnGroupData != null) {
            spawnGroupData = new HuskGroupData((Zombie.ZombieGroupData)spawnGroupData);
            boolean bl = ((HuskGroupData)((Object)spawnGroupData)).triedToSpawnCamelHusk = spawnReason != EntitySpawnReason.NATURAL;
        }
        if (spawnGroupData instanceof HuskGroupData) {
            HuskGroupData husk$huskgroupdata = (HuskGroupData)((Object)spawnGroupData);
            if (!husk$huskgroupdata.triedToSpawnCamelHusk) {
                BlockPos blockpos = this.blockPosition();
                if (level.noCollision(EntityRegistry.CHILLIFIED_POLAR_BEAR.get().getSpawnAABB((double)blockpos.getX() + 0.5, (double)blockpos.getY(), (double)blockpos.getZ() + 0.5))) {
                    husk$huskgroupdata.triedToSpawnCamelHusk = true;
                    if (randomsource.nextFloat() < 0.1f) {
                        this.setItemSlot(EquipmentSlot.MAINHAND, new ItemStack((ItemLike)Items.IRON_SPEAR));
                        ChillifiedPolarBearEntity camelhusk = (ChillifiedPolarBearEntity)EntityRegistry.CHILLIFIED_POLAR_BEAR.get().create(this.level(), EntitySpawnReason.NATURAL);
                        if (camelhusk != null) {
                            camelhusk.setPos(this.getX(), this.getY(), this.getZ());
                            camelhusk.finalizeSpawn(level, difficulty, spawnReason, null);
                            this.startRiding((Entity)camelhusk, true, true);
                            level.addFreshEntity((Entity)camelhusk);
                        }
                    }
                }
            }
        }
        return spawnGroupData;
    }

    public ChilledEntity(EntityType<? extends ChilledEntity> p_32889_, Level p_32890_) {
        super(p_32889_, p_32890_);
    }

    public static boolean checkChilledSpawnRules(EntityType<ChilledEntity> entityType, ServerLevelAccessor level, EntitySpawnReason spawnReason, BlockPos pos, RandomSource random) {
        BlockPos blockpos = pos;
        while (level.getBlockState(blockpos = blockpos.above()).is(Blocks.POWDER_SNOW)) {
        }
        return ChilledEntity.checkMonsterSpawnRules(entityType, (ServerLevelAccessor)level, (EntitySpawnReason)spawnReason, (BlockPos)pos, (RandomSource)random) && (EntitySpawnReason.isSpawner((EntitySpawnReason)spawnReason) || level.canSeeSky(blockpos.below()));
    }

    protected boolean isSunSensitive() {
        return false;
    }

    protected SoundEvent getAmbientSound() {
        return SoundRegistry.CHILLED_AMBIENT.get();
    }

    protected SoundEvent getHurtSound(DamageSource damageSource) {
        return SoundRegistry.CHILLED_HURT.get();
    }

    protected SoundEvent getDeathSound() {
        return SoundRegistry.CHILLED_DEATH.get();
    }

    protected SoundEvent getStepSound() {
        return SoundRegistry.CHILLED_STEP.get();
    }

    public float getVoicePitch() {
        return 2.0f;
    }

    public boolean doHurtTarget(ServerLevel p_376715_, Entity p_32892_) {
        boolean flag = super.doHurtTarget(p_376715_, p_32892_);
        if (flag && this.getMainHandItem().isEmpty() && !ChilledEntity.canEntityWalkOnPowderSnow(p_32892_)) {
            float f = p_376715_.getCurrentDifficultyAt(this.blockPosition()).getEffectiveDifficulty();
            ((LivingEntity)p_32892_).setTicksFrozen(600 * (int)f);
            ((LivingEntity)p_32892_).extinguishFire();
        }
        return flag;
    }

    public static boolean canEntityWalkOnPowderSnow(Entity entity) {
        boolean isLeather = ((LivingEntity)entity).getItemBySlot(EquipmentSlot.FEET).is(ItemTags.FREEZE_IMMUNE_WEARABLES) || ((LivingEntity)entity).getItemBySlot(EquipmentSlot.LEGS).is(ItemTags.FREEZE_IMMUNE_WEARABLES) || ((LivingEntity)entity).getItemBySlot(EquipmentSlot.CHEST).is(ItemTags.FREEZE_IMMUNE_WEARABLES) || ((LivingEntity)entity).getItemBySlot(EquipmentSlot.HEAD).is(ItemTags.FREEZE_IMMUNE_WEARABLES);
        return entity instanceof LivingEntity ? isLeather : false;
    }

    protected boolean convertsInWater() {
        return false;
    }

    public static class HuskGroupData
    extends Zombie.ZombieGroupData {
        public boolean triedToSpawnCamelHusk = false;

        public HuskGroupData(Zombie.ZombieGroupData p_482181_) {
            super(p_482181_.isBaby, p_482181_.canSpawnJockey);
        }
    }
}

