/*
 * Decompiled with CFR 0.152.
 */
package com.belgie.mounts_of_mayhem_plus.common.entity.chillifiedPolarBear;

import com.belgie.mounts_of_mayhem_plus.common.variants.ChillifiedPolarBearVariant;
import com.belgie.mounts_of_mayhem_plus.core.EntityRegistry;
import com.belgie.mounts_of_mayhem_plus.core.SoundRegistry;
import com.belgie.mounts_of_mayhem_plus.core.VariantsRegistry;
import javax.annotation.Nullable;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.component.DataComponentGetter;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.Identifier;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.tags.ItemTags;
import net.minecraft.util.Mth;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.EntityAttachment;
import net.minecraft.world.entity.EntityAttachments;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.animal.equine.AbstractHorse;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.variant.SpawnContext;
import net.minecraft.world.entity.variant.VariantUtils;
import net.minecraft.world.item.EitherHolder;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.pathfinder.PathType;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import net.minecraft.world.phys.Vec3;

public class ChillifiedPolarBearEntity
extends AbstractHorse {
    private int dashCooldown = 0;
    private static final EntityDataAccessor<Float> STAMINA = SynchedEntityData.defineId(ChillifiedPolarBearEntity.class, (EntityDataSerializer)EntityDataSerializers.FLOAT);
    private final float MAX_STAMINA = ((ChillifiedPolarBearVariant)this.getVariant().value()).maxStamina();
    private static final EntityDimensions BABY_DIMENSIONS;
    private static final EntityDataAccessor<Holder<ChillifiedPolarBearVariant>> DATA_VARIANT_ID;

    public Holder<ChillifiedPolarBearVariant> getVariant() {
        return (Holder)this.entityData.get(DATA_VARIANT_ID);
    }

    private void setVariant(Holder<ChillifiedPolarBearVariant> variant) {
        this.entityData.set(DATA_VARIANT_ID, variant);
    }

    @Nullable
    public <T> T get(DataComponentType<? extends T> component) {
        return (T)(component == VariantsRegistry.CHILLIFIED_POLAR_BEAR_VARIANT_COM.get() ? ChillifiedPolarBearEntity.castComponentValue(component, (Object)new EitherHolder(this.getVariant())) : super.get(component));
    }

    protected void applyImplicitComponents(DataComponentGetter componentGetter) {
        this.applyImplicitComponentIfPresent(componentGetter, VariantsRegistry.CHILLIFIED_POLAR_BEAR_VARIANT_COM.get());
        super.applyImplicitComponents(componentGetter);
    }

    protected <T> boolean applyImplicitComponent(DataComponentType<T> component, T value) {
        if (component == VariantsRegistry.CHILLIFIED_POLAR_BEAR_VARIANT_COM.get()) {
            this.setVariant((Holder<ChillifiedPolarBearVariant>)((Holder)ChillifiedPolarBearEntity.castComponentValue(VariantsRegistry.CHILLIFIED_POLAR_BEAR_VARIANT_COM.get(), value)));
            return true;
        }
        return super.applyImplicitComponent(component, value);
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(DATA_VARIANT_ID, (Object)VariantUtils.getDefaultOrAny((RegistryAccess)this.registryAccess(), (ResourceKey)ResourceKey.create(VariantsRegistry.CHILLIFIED_POLAR_BEAR_VARIANT_REGISTRY_KEY, (Identifier)Identifier.fromNamespaceAndPath((String)"mounts_of_mayhem_plus", (String)"default"))));
        builder.define(STAMINA, (Object)Float.valueOf(this.MAX_STAMINA));
    }

    protected void addAdditionalSaveData(ValueOutput output) {
        super.addAdditionalSaveData(output);
        VariantUtils.writeVariant((ValueOutput)output, this.getVariant());
    }

    protected void readAdditionalSaveData(ValueInput input) {
        super.readAdditionalSaveData(input);
        VariantUtils.readVariant((ValueInput)input, VariantsRegistry.CHILLIFIED_POLAR_BEAR_VARIANT_REGISTRY_KEY).ifPresent(this::setVariant);
    }

    @Nullable
    public SpawnGroupData finalizeSpawn(ServerLevelAccessor level, DifficultyInstance difficulty, EntitySpawnReason spawnReason, @Nullable SpawnGroupData spawnGroupData) {
        spawnGroupData = super.finalizeSpawn(level, difficulty, spawnReason, spawnGroupData);
        VariantUtils.selectVariantToSpawn((SpawnContext)SpawnContext.create((ServerLevelAccessor)level, (BlockPos)this.blockPosition()), VariantsRegistry.CHILLIFIED_POLAR_BEAR_VARIANT_REGISTRY_KEY).ifPresent(this::setVariant);
        return spawnGroupData;
    }

    public ChillifiedPolarBearEntity(EntityType<? extends ChillifiedPolarBearEntity> p_30894_, Level p_30895_) {
        super(p_30894_, p_30895_);
        this.setPathfindingMalus(PathType.DANGER_OTHER, -1.0f);
        this.setPathfindingMalus(PathType.DAMAGE_OTHER, -1.0f);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return ChillifiedPolarBearEntity.createBaseHorseAttributes().add(Attributes.MAX_HEALTH, 20.0);
    }

    public InteractionResult interact(Player p_478395_, InteractionHand p_479428_) {
        this.setPersistenceRequired();
        return super.interact(p_478395_, p_479428_);
    }

    public boolean removeWhenFarAway(double p_479978_) {
        return true;
    }

    public boolean isMobControlled() {
        return this.getFirstPassenger() instanceof Mob;
    }

    public boolean canFallInLove() {
        return false;
    }

    protected void addBehaviourGoals() {
        this.goalSelector.addGoal(0, (Goal)new FloatGoal((Mob)this));
    }

    public InteractionResult mobInteract(Player p_478329_, InteractionHand p_479271_) {
        boolean flag;
        boolean bl = flag = !this.isBaby() && this.isTamed() && p_478329_.isSecondaryUseActive();
        if (!this.isVehicle() && !flag) {
            ItemStack itemstack = p_478329_.getItemInHand(p_479271_);
            if (!itemstack.isEmpty()) {
                if (this.isFood(itemstack)) {
                    return this.fedFood(p_478329_, itemstack);
                }
                if (!this.isTamed()) {
                    this.makeMad();
                    return InteractionResult.SUCCESS;
                }
            }
            return super.mobInteract(p_478329_, p_479271_);
        }
        return super.mobInteract(p_478329_, p_479271_);
    }

    public boolean canUseSlot(EquipmentSlot p_481976_) {
        return true;
    }

    public boolean isFood(ItemStack p_480617_) {
        return p_480617_.is(ItemTags.FISHES);
    }

    public EntityDimensions getDefaultDimensions(Pose p_479251_) {
        return this.isBaby() ? BABY_DIMENSIONS : super.getDefaultDimensions(p_479251_);
    }

    public float chargeSpeedModifier() {
        return 1.4f;
    }

    public float getStamina() {
        return ((Float)this.entityData.get(STAMINA)).floatValue();
    }

    public void setStamina(float value) {
        this.entityData.set(STAMINA, (Object)Float.valueOf(Mth.clamp((float)value, (float)0.0f, (float)this.MAX_STAMINA)));
    }

    public boolean canSprint() {
        return true;
    }

    public void aiStep() {
        super.aiStep();
        if (this.level().isClientSide()) {
            this.updateStaminaJumpBarClient();
        }
    }

    private void updateStaminaJumpBarClient() {
        if (!this.isVehicle()) {
            return;
        }
        LivingEntity rider = this.getControllingPassenger();
        if (!(rider instanceof LocalPlayer)) {
            return;
        }
        LocalPlayer player = (LocalPlayer)rider;
        player.jumpRidingScale = this.getStamina() / this.MAX_STAMINA;
    }

    public void handleStartJump(int power) {
    }

    public boolean canJump() {
        return true;
    }

    protected boolean canPerformRearing() {
        return false;
    }

    public void tick() {
        LivingEntity rider;
        super.tick();
        if (!this.level().isClientSide() && this.isVehicle() && (rider = this.getControllingPassenger()) instanceof Player) {
            Player player = (Player)rider;
            float stamina = this.getStamina();
            if (player.isSprinting() && stamina > 0.0f) {
                this.setStamina(stamina - ((ChillifiedPolarBearVariant)this.getVariant().value()).gainStaminaRate());
            } else {
                this.setStamina(stamina + ((ChillifiedPolarBearVariant)this.getVariant().value()).reduceStaminaRate());
            }
            if (stamina <= 0.0f) {
                player.setSprinting(false);
            }
        }
    }

    protected void hurtArmor(DamageSource p_379528_, float p_379933_) {
        this.doHurtEquipment(p_379528_, p_379933_, new EquipmentSlot[]{EquipmentSlot.BODY});
    }

    protected SoundEvent getAmbientSound() {
        return SoundRegistry.CHILLIFED_POLAR_BEAR_AMBIENT.get();
    }

    protected SoundEvent getDeathSound() {
        return SoundRegistry.CHILLIFED_POLAR_BEAR_DEATH.get();
    }

    protected SoundEvent getHurtSound(DamageSource damageSource) {
        return SoundRegistry.CHILLIFED_POLAR_BEAR_HURT.get();
    }

    protected void playGallopSound(SoundType p_480127_) {
        this.playSound(SoundRegistry.CHILLIFED_POLAR_BEAR_STEP.get(), p_480127_.getVolume() * 0.15f, p_480127_.getPitch());
    }

    protected float getRiddenSpeed(Player p_278241_) {
        float f = p_278241_.isSprinting() ? 0.15f : 0.0f;
        return (float)this.getAttributeValue(Attributes.MOVEMENT_SPEED) + f;
    }

    public float getVoicePitch() {
        return -1.0f;
    }

    protected float getWaterSlowDown() {
        return 0.0f;
    }

    public void onPlayerJump(int p_249138_) {
        if (this.isSaddled() && this.dashCooldown <= 0 && this.onGround()) {
            super.onPlayerJump(p_249138_);
        }
    }

    protected void executeRidersJump(float p_251967_, Vec3 p_275627_) {
    }

    public void handleStopJump() {
    }

    public int getJumpCooldown() {
        return this.dashCooldown;
    }

    @Nullable
    public AgeableMob getBreedOffspring(ServerLevel p_149553_, AgeableMob p_149554_) {
        return (AgeableMob)EntityRegistry.CHILLIFIED_POLAR_BEAR.get().create((Level)p_149553_, EntitySpawnReason.BREEDING);
    }

    static {
        DATA_VARIANT_ID = SynchedEntityData.defineId(ChillifiedPolarBearEntity.class, VariantsRegistry.CHILLIFIED_POLAR_BEAR_VARIANT.get());
        BABY_DIMENSIONS = EntityRegistry.CHILLIFIED_POLAR_BEAR.get().getDimensions().withAttachments(EntityAttachments.builder().attach(EntityAttachment.PASSENGER, 0.0f, EntityRegistry.CHILLIFIED_POLAR_BEAR.get().getHeight() - 0.03125f, 0.0f)).scale(0.5f);
    }
}

