/*
 * Decompiled with CFR 0.152.
 */
package com.belgie.mounts_of_mayhem_plus.common.entity.horseArmorStand;

import com.belgie.mounts_of_mayhem_plus.core.EntityRegistry;
import com.belgie.mounts_of_mayhem_plus.core.ItemRegistry;
import com.belgie.mounts_of_mayhem_plus.core.TagRegistry;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.Vec3i;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.LightningBolt;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.vehicle.minecart.AbstractMinecart;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.gamerules.GameRules;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class HorseArmorStandEntity
extends LivingEntity {
    private static final EntityDimensions MARKER_DIMENSIONS = EntityDimensions.fixed((float)0.0f, (float)0.0f);
    private static final EntityDimensions WARBOAR_BABY_DIMENSIONS = EntityRegistry.WARBOAR.get().getDimensions().scale(0.5f);
    private static final EntityDimensions HORSE_BABY_DIMENSIONS = EntityType.HORSE.getDimensions().scale(0.5f);
    private static final EntityDimensions WOLF_BABY_DIMENSIONS;
    private static final EntityDimensions NAUTILUS_BABY_DIMENSIONS;
    public static final int DISABLE_TAKING_OFFSET = 8;
    public static final int DISABLE_PUTTING_OFFSET = 16;
    public static final int CLIENT_FLAG_SMALL = 1;
    public static final int CLIENT_FLAG_SHOW_ARMS = 4;
    public static final int CLIENT_FLAG_NO_BASEPLATE = 8;
    public static final int CLIENT_FLAG_MARKER = 16;
    public static final EntityDataAccessor<Byte> DATA_CLIENT_FLAGS;
    private static final Predicate<Entity> RIDABLE_MINECARTS;
    private static final boolean DEFAULT_INVISIBLE = false;
    private static final int DEFAULT_DISABLED_SLOTS = 0;
    private static final boolean DEFAULT_SHOW_ARMS = false;
    private static final boolean DEFAULT_NO_BASE_PLATE = false;
    private static final boolean DEFAULT_MARKER = false;
    private boolean invisible = false;
    public long lastHit;

    public HorseArmorStandEntity(EntityType<? extends HorseArmorStandEntity> p_31553_, Level p_31554_) {
        super(p_31553_, p_31554_);
    }

    public HorseArmorStandEntity(EntityType<? extends HorseArmorStandEntity> p_31553_, Level level, double x, double y, double z) {
        this(p_31553_, level);
        this.setPos(x, y, z);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return HorseArmorStandEntity.createLivingAttributes().add(Attributes.STEP_HEIGHT, 0.0);
    }

    public void refreshDimensions() {
        double d0 = this.getX();
        double d1 = this.getY();
        double d2 = this.getZ();
        super.refreshDimensions();
        this.setPos(d0, d1, d2);
    }

    public ItemStack getBodyArmorItem() {
        return this.getItemBySlot(EquipmentSlot.BODY);
    }

    private boolean hasPhysics() {
        return !this.isMarker() && !this.isNoGravity();
    }

    public boolean isEffectiveAi() {
        return super.isEffectiveAi() && this.hasPhysics();
    }

    protected void defineSynchedData(SynchedEntityData.Builder p_326283_) {
        super.defineSynchedData(p_326283_);
        p_326283_.define(DATA_CLIENT_FLAGS, (Object)0);
    }

    protected void addAdditionalSaveData(ValueOutput p_422671_) {
        super.addAdditionalSaveData(p_422671_);
        p_422671_.putBoolean("Invisible", this.isInvisible());
        p_422671_.putBoolean("NoBasePlate", !this.showBasePlate());
        if (this.isMarker()) {
            p_422671_.putBoolean("Marker", this.isMarker());
        }
    }

    protected void readAdditionalSaveData(ValueInput p_421830_) {
        super.readAdditionalSaveData(p_421830_);
        this.setInvisible(p_421830_.getBooleanOr("Invisible", false));
        this.setNoBasePlate(p_421830_.getBooleanOr("NoBasePlate", false));
        this.setMarker(p_421830_.getBooleanOr("Marker", false));
        this.noPhysics = !this.hasPhysics();
    }

    public boolean isPushable() {
        return false;
    }

    protected void doPush(Entity entity) {
    }

    protected void pushEntities() {
        for (Entity entity : this.level().getEntities((Entity)this, this.getBoundingBox(), RIDABLE_MINECARTS)) {
            if (!(this.distanceToSqr(entity) <= 0.2)) continue;
            entity.push((Entity)this);
        }
    }

    public InteractionResult interactAt(Player player, Vec3 vec, InteractionHand hand) {
        if (this.getType() == EntityRegistry.HORSE_ARMOR_STAND.get()) {
            if (this.getBodyArmorItem().isEmpty() && player.getItemInHand(hand).is(TagRegistry.HORSE_ARMORS)) {
                ItemStack itemstack = player.getItemInHand(hand);
                this.setItemSlot(EquipmentSlot.BODY, itemstack.copyWithCount(1));
                itemstack.consume(1, (LivingEntity)player);
                return InteractionResult.SUCCESS;
            }
            ItemStack itemstack = this.getBodyArmorItem();
            this.setItemSlot(EquipmentSlot.BODY, ItemStack.EMPTY);
            player.addItem(itemstack);
            return InteractionResult.SUCCESS;
        }
        if (this.getType() == EntityRegistry.NAUTILUS_ARMOR_STAND.get()) {
            if (this.getBodyArmorItem().isEmpty() && player.getItemInHand(hand).is(TagRegistry.NAUTILUS_ARMORS)) {
                ItemStack itemstack = player.getItemInHand(hand);
                this.setItemSlot(EquipmentSlot.BODY, itemstack.copyWithCount(1));
                itemstack.consume(1, (LivingEntity)player);
                return InteractionResult.SUCCESS;
            }
            ItemStack itemstack = this.getBodyArmorItem();
            this.setItemSlot(EquipmentSlot.BODY, ItemStack.EMPTY);
            player.addItem(itemstack);
            return InteractionResult.SUCCESS;
        }
        if (this.getType() == EntityRegistry.WOLF_ARMOR_STAND.get()) {
            if (this.getBodyArmorItem().isEmpty() && player.getItemInHand(hand).is(Items.WOLF_ARMOR)) {
                ItemStack itemstack = player.getItemInHand(hand);
                this.setItemSlot(EquipmentSlot.BODY, itemstack.copyWithCount(1));
                itemstack.consume(1, (LivingEntity)player);
                return InteractionResult.SUCCESS;
            }
            ItemStack itemstack = this.getBodyArmorItem();
            this.setItemSlot(EquipmentSlot.BODY, ItemStack.EMPTY);
            player.addItem(itemstack);
            return InteractionResult.SUCCESS;
        }
        if (this.getType() == EntityRegistry.WARBOAR_ARMOR_STAND.get()) {
            if (this.getBodyArmorItem().isEmpty() && player.getItemInHand(hand).is((Item)ItemRegistry.WARBOAR_ARMOR.get())) {
                ItemStack itemstack = player.getItemInHand(hand);
                this.setItemSlot(EquipmentSlot.BODY, itemstack.copyWithCount(1));
                itemstack.consume(1, (LivingEntity)player);
                return InteractionResult.SUCCESS;
            }
            ItemStack itemstack = this.getBodyArmorItem();
            this.setItemSlot(EquipmentSlot.BODY, ItemStack.EMPTY);
            player.addItem(itemstack);
            return InteractionResult.SUCCESS;
        }
        return super.interactAt(player, vec, hand);
    }

    public boolean hurtServer(ServerLevel p_376183_, DamageSource p_31579_, float p_31580_) {
        if (this.isRemoved()) {
            return false;
        }
        if (!((Boolean)p_376183_.getGameRules().get(GameRules.MOB_GRIEFING)).booleanValue() && p_31579_.getEntity() instanceof Mob) {
            return false;
        }
        if (p_31579_.is(DamageTypeTags.BYPASSES_INVULNERABILITY)) {
            this.kill(p_376183_);
            return false;
        }
        if (!(this.isInvulnerableTo(p_376183_, p_31579_) || this.invisible || this.isMarker())) {
            if (p_31579_.is(DamageTypeTags.IS_EXPLOSION)) {
                this.brokenByAnything(p_376183_, p_31579_);
                this.kill(p_376183_);
                return false;
            }
            if (p_31579_.is(DamageTypeTags.IGNITES_ARMOR_STANDS)) {
                if (this.isOnFire()) {
                    this.causeDamage(p_376183_, p_31579_, 0.15f);
                } else {
                    this.igniteForSeconds(5.0f);
                }
                return false;
            }
            if (p_31579_.is(DamageTypeTags.BURNS_ARMOR_STANDS) && this.getHealth() > 0.5f) {
                this.causeDamage(p_376183_, p_31579_, 4.0f);
                return false;
            }
            boolean flag = p_31579_.is(DamageTypeTags.CAN_BREAK_ARMOR_STAND);
            boolean flag1 = p_31579_.is(DamageTypeTags.ALWAYS_KILLS_ARMOR_STANDS);
            if (!flag && !flag1) {
                return false;
            }
            Entity var7 = p_31579_.getEntity();
            if (var7 instanceof Player) {
                Player player = (Player)var7;
                if (!player.getAbilities().mayBuild) {
                    return false;
                }
            }
            if (p_31579_.isCreativePlayer()) {
                this.playBrokenSound();
                this.showBreakingParticles();
                this.kill(p_376183_);
                return true;
            }
            long i = p_376183_.getGameTime();
            if (i - this.lastHit > 5L && !flag1) {
                p_376183_.broadcastEntityEvent((Entity)this, (byte)32);
                this.gameEvent((Holder)GameEvent.ENTITY_DAMAGE, p_31579_.getEntity());
                this.lastHit = i;
            } else {
                this.brokenByPlayer(p_376183_, p_31579_);
                this.showBreakingParticles();
                this.kill(p_376183_);
            }
            return true;
        }
        return false;
    }

    public void handleEntityEvent(byte p_31568_) {
        if (p_31568_ == 32) {
            if (this.level().isClientSide()) {
                this.level().playLocalSound(this.getX(), this.getY(), this.getZ(), SoundEvents.ARMOR_STAND_HIT, this.getSoundSource(), 0.3f, 1.0f, false);
                this.lastHit = this.level().getGameTime();
            }
        } else {
            super.handleEntityEvent(p_31568_);
        }
    }

    public boolean shouldRenderAtSqrDistance(double distance) {
        double d0 = this.getBoundingBox().getSize() * 4.0;
        if (Double.isNaN(d0) || d0 == 0.0) {
            d0 = 4.0;
        }
        return distance < (d0 *= 64.0) * d0;
    }

    private void showBreakingParticles() {
        if (this.level() instanceof ServerLevel) {
            ((ServerLevel)this.level()).sendParticles((ParticleOptions)new BlockParticleOption(ParticleTypes.BLOCK, Blocks.OAK_PLANKS.defaultBlockState()), this.getX(), this.getY(0.6666666666666666), this.getZ(), 10, (double)(this.getBbWidth() / 4.0f), (double)(this.getBbHeight() / 4.0f), (double)(this.getBbWidth() / 4.0f), 0.05);
        }
    }

    private void causeDamage(ServerLevel level, DamageSource damageSource, float damageAmount) {
        float f = this.getHealth();
        if ((f -= damageAmount) <= 0.5f) {
            this.brokenByAnything(level, damageSource);
            this.kill(level);
        } else {
            this.setHealth(f);
            this.gameEvent((Holder)GameEvent.ENTITY_DAMAGE, damageSource.getEntity());
        }
    }

    private void brokenByPlayer(ServerLevel level, DamageSource damageSource) {
        ItemStack itemstack = new ItemStack((ItemLike)ItemRegistry.HORSE_ARMOR_STAND.get());
        ItemStack itemstack1 = new ItemStack((ItemLike)ItemRegistry.NAUTILUS_ARMOR_STAND.get());
        ItemStack itemstack2 = new ItemStack((ItemLike)ItemRegistry.WOLF_ARMOR_STAND.get());
        ItemStack itemstack3 = new ItemStack((ItemLike)ItemRegistry.WARBOAR_ARMOR_STAND.get());
        if (this.getType() == EntityRegistry.HORSE_ARMOR_STAND.get()) {
            itemstack.set(DataComponents.CUSTOM_NAME, (Object)this.getCustomName());
            Block.popResource((Level)this.level(), (BlockPos)this.blockPosition(), (ItemStack)itemstack);
            this.brokenByAnything(level, damageSource);
        } else if (this.getType() == EntityRegistry.NAUTILUS_ARMOR_STAND.get()) {
            itemstack1.set(DataComponents.CUSTOM_NAME, (Object)this.getCustomName());
            Block.popResource((Level)this.level(), (BlockPos)this.blockPosition(), (ItemStack)itemstack1);
            this.brokenByAnything(level, damageSource);
        } else if (this.getType() == EntityRegistry.WARBOAR_ARMOR_STAND.get()) {
            itemstack3.set(DataComponents.CUSTOM_NAME, (Object)this.getCustomName());
            Block.popResource((Level)this.level(), (BlockPos)this.blockPosition(), (ItemStack)itemstack3);
            this.brokenByAnything(level, damageSource);
        } else if (this.getType() == EntityRegistry.WOLF_ARMOR_STAND.get()) {
            itemstack2.set(DataComponents.CUSTOM_NAME, (Object)this.getCustomName());
            Block.popResource((Level)this.level(), (BlockPos)this.blockPosition(), (ItemStack)itemstack2);
            this.brokenByAnything(level, damageSource);
        }
    }

    private void brokenByAnything(ServerLevel level, DamageSource damageSource) {
        this.playBrokenSound();
        this.dropAllDeathLoot(level, damageSource);
        for (EquipmentSlot equipmentslot : EquipmentSlot.VALUES) {
            ItemStack itemstack = this.equipment.set(equipmentslot, ItemStack.EMPTY);
            if (itemstack.isEmpty()) continue;
            Block.popResource((Level)this.level(), (BlockPos)this.blockPosition().above(), (ItemStack)itemstack);
        }
    }

    private void playBrokenSound() {
        this.level().playSound((Entity)null, this.getX(), this.getY(), this.getZ(), SoundEvents.ARMOR_STAND_BREAK, this.getSoundSource(), 1.0f, 1.0f);
    }

    protected void tickHeadTurn(float p_31644_) {
        this.yBodyRotO = this.yRotO;
        this.yBodyRot = this.getYRot();
        this.yHeadRotO = this.yRotO;
        this.yHeadRot = this.getYRot();
    }

    public void travel(Vec3 travelVector) {
        if (this.hasPhysics()) {
            super.travel(travelVector);
        }
    }

    public void setYBodyRot(float offset) {
        this.yBodyRotO = this.yRotO = offset;
        this.yHeadRotO = this.yHeadRot = offset;
    }

    public HumanoidArm getMainArm() {
        return null;
    }

    public void setYHeadRot(float rotation) {
        this.yBodyRotO = this.yRotO = rotation;
        this.yHeadRotO = this.yHeadRot = rotation;
    }

    protected void updateInvisibilityStatus() {
        this.setInvisible(this.invisible);
    }

    public void setInvisible(boolean invisible) {
        this.invisible = invisible;
        super.setInvisible(invisible);
    }

    public void kill(ServerLevel p_376582_) {
        this.remove(Entity.RemovalReason.KILLED);
        this.gameEvent((Holder)GameEvent.ENTITY_DIE);
    }

    public boolean ignoreExplosion(Explosion p_312813_) {
        return p_312813_.shouldAffectBlocklikeEntities() ? this.isInvisible() : true;
    }

    public PushReaction getPistonPushReaction() {
        return this.isMarker() ? PushReaction.IGNORE : super.getPistonPushReaction();
    }

    public boolean isIgnoringBlockTriggers() {
        return this.isMarker();
    }

    public void setNoBasePlate(boolean noBasePlate) {
        this.entityData.set(DATA_CLIENT_FLAGS, (Object)this.setBit((Byte)this.entityData.get(DATA_CLIENT_FLAGS), 8, noBasePlate));
    }

    public boolean showBasePlate() {
        return ((Byte)this.entityData.get(DATA_CLIENT_FLAGS) & 8) == 0;
    }

    private void setMarker(boolean marker) {
        this.entityData.set(DATA_CLIENT_FLAGS, (Object)this.setBit((Byte)this.entityData.get(DATA_CLIENT_FLAGS), 16, marker));
    }

    public boolean isMarker() {
        return ((Byte)this.entityData.get(DATA_CLIENT_FLAGS) & 0x10) != 0;
    }

    private byte setBit(byte oldBit, int offset, boolean value) {
        oldBit = value ? (byte)(oldBit | offset) : (byte)(oldBit & ~offset);
        return oldBit;
    }

    public boolean isPickable() {
        return super.isPickable() && !this.isMarker();
    }

    public boolean skipAttackInteraction(Entity entity) {
        if (entity instanceof Player) {
            Player player = (Player)entity;
            if (!this.level().mayInteract((Entity)player, this.blockPosition())) {
                boolean var10000 = true;
                return var10000;
            }
        }
        boolean var10000 = false;
        return var10000;
    }

    public LivingEntity.Fallsounds getFallSounds() {
        return new LivingEntity.Fallsounds(SoundEvents.ARMOR_STAND_FALL, SoundEvents.ARMOR_STAND_FALL);
    }

    @Nullable
    protected SoundEvent getHurtSound(DamageSource damageSource) {
        return SoundEvents.ARMOR_STAND_HIT;
    }

    @Nullable
    protected SoundEvent getDeathSound() {
        return SoundEvents.ARMOR_STAND_BREAK;
    }

    public void thunderHit(ServerLevel level, LightningBolt lightning) {
    }

    public boolean isAffectedByPotions() {
        return false;
    }

    public void onSyncedDataUpdated(EntityDataAccessor<?> key) {
        if (DATA_CLIENT_FLAGS.equals(key)) {
            this.refreshDimensions();
            this.blocksBuilding = !this.isMarker();
        }
        super.onSyncedDataUpdated(key);
    }

    public boolean attackable() {
        return false;
    }

    public EntityDimensions getDefaultDimensions(Pose p_31587_) {
        return this.getDimensionsMarker(this.isMarker());
    }

    private EntityDimensions getDimensionsMarker(boolean isMarker) {
        if (isMarker) {
            return MARKER_DIMENSIONS;
        }
        return this.setBabyTypes();
    }

    public EntityDimensions setBabyTypes() {
        if (this.getType() == EntityRegistry.WARBOAR_ARMOR_STAND.get()) {
            return this.isBaby() ? WARBOAR_BABY_DIMENSIONS : this.getType().getDimensions();
        }
        if (this.getType() == EntityRegistry.HORSE_ARMOR_STAND.get()) {
            return this.isBaby() ? HORSE_BABY_DIMENSIONS : this.getType().getDimensions();
        }
        if (this.getType() == EntityRegistry.WOLF_ARMOR_STAND.get()) {
            return this.isBaby() ? WOLF_BABY_DIMENSIONS : this.getType().getDimensions();
        }
        if (this.getType() == EntityRegistry.NAUTILUS_ARMOR_STAND.get()) {
            return this.isBaby() ? NAUTILUS_BABY_DIMENSIONS : this.getType().getDimensions();
        }
        return this.getType().getDimensions();
    }

    public Vec3 getLightProbePosition(float partialTicks) {
        if (this.isMarker()) {
            AABB aabb = this.getDimensionsMarker(false).makeBoundingBox(this.position());
            BlockPos blockpos = this.blockPosition();
            int i = Integer.MIN_VALUE;
            for (BlockPos blockpos1 : BlockPos.betweenClosed((BlockPos)BlockPos.containing((double)aabb.minX, (double)aabb.minY, (double)aabb.minZ), (BlockPos)BlockPos.containing((double)aabb.maxX, (double)aabb.maxY, (double)aabb.maxZ))) {
                int j = Math.max(this.level().getBrightness(LightLayer.BLOCK, blockpos1), this.level().getBrightness(LightLayer.SKY, blockpos1));
                if (j == 15) {
                    return Vec3.atCenterOf((Vec3i)blockpos1);
                }
                if (j <= i) continue;
                i = j;
                blockpos = blockpos1.immutable();
            }
            return Vec3.atCenterOf((Vec3i)blockpos);
        }
        return super.getLightProbePosition(partialTicks);
    }

    public ItemStack getPickResult() {
        return this.getItem();
    }

    public ItemStack getItem() {
        ItemStack stack;
        if (this.getType().equals(EntityRegistry.HORSE_ARMOR_STAND.get())) {
            stack = new ItemStack((ItemLike)ItemRegistry.HORSE_ARMOR_STAND.get());
        } else if (this.getType().equals(EntityRegistry.NAUTILUS_ARMOR_STAND.get())) {
            stack = new ItemStack((ItemLike)ItemRegistry.NAUTILUS_ARMOR_STAND.get());
        } else if (this.getType().equals(EntityRegistry.WARBOAR_ARMOR_STAND.get())) {
            stack = new ItemStack((ItemLike)ItemRegistry.WARBOAR_ARMOR_STAND.get());
        } else if (this.getType().equals(EntityRegistry.WOLF_ARMOR_STAND.get())) {
            stack = new ItemStack((ItemLike)ItemRegistry.WOLF_ARMOR_STAND.get());
        } else {
            throw new IllegalStateException("Unexpected value: " + String.valueOf(this.getType()));
        }
        return stack;
    }

    public boolean canBeSeenByAnyone() {
        return !this.isInvisible() && !this.isMarker();
    }

    public boolean canUseSlot(EquipmentSlot p_348583_) {
        return true;
    }

    static {
        NAUTILUS_BABY_DIMENSIONS = EntityType.NAUTILUS.getDimensions().scale(0.5f);
        WOLF_BABY_DIMENSIONS = EntityType.WOLF.getDimensions().scale(0.5f);
        DATA_CLIENT_FLAGS = SynchedEntityData.defineId(HorseArmorStandEntity.class, (EntityDataSerializer)EntityDataSerializers.BYTE);
        RIDABLE_MINECARTS = p_373856_ -> {
            AbstractMinecart abstractminecart;
            if (p_373856_ instanceof AbstractMinecart && (abstractminecart = (AbstractMinecart)p_373856_).isRideable()) {
                boolean var10000 = true;
                return var10000;
            }
            boolean var10000 = false;
            return var10000;
        };
    }
}

