/*
 * Decompiled with CFR 0.152.
 */
package com.belgie.mounts_of_mayhem_plus.common.entity.ostrich;

import com.belgie.mounts_of_mayhem_plus.common.entity.spider.SpiderMountEntity;
import com.belgie.mounts_of_mayhem_plus.common.variants.SquawkVariant;
import com.belgie.mounts_of_mayhem_plus.core.EntityRegistry;
import com.belgie.mounts_of_mayhem_plus.core.SoundRegistry;
import com.belgie.mounts_of_mayhem_plus.core.VariantsRegistry;
import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.component.DataComponentGetter;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.Identifier;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.BiomeTags;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.animal.equine.AbstractHorse;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.variant.SpawnContext;
import net.minecraft.world.entity.variant.VariantUtils;
import net.minecraft.world.item.EitherHolder;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.pathfinder.PathType;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import net.minecraft.world.phys.Vec2;
import net.minecraft.world.phys.Vec3;

public class OstrichEntity
extends AbstractHorse {
    public float flap;
    public float flapSpeed;
    public float oFlapSpeed;
    public float oFlap;
    public float flapping = 1.0f;
    private float nextFlap = 1.0f;
    private static final EntityDataAccessor<Holder<SquawkVariant>> DATA_VARIANT_ID = SynchedEntityData.defineId(OstrichEntity.class, VariantsRegistry.SQUAWK_VARIANT.get());

    public Holder<SquawkVariant> getVariant() {
        return (Holder)this.entityData.get(DATA_VARIANT_ID);
    }

    private void setVariant(Holder<SquawkVariant> variant) {
        this.entityData.set(DATA_VARIANT_ID, variant);
    }

    @Nullable
    public <T> T get(DataComponentType<? extends T> component) {
        return (T)(component == VariantsRegistry.SQUAWK_VARIANT_COM.get() ? OstrichEntity.castComponentValue(component, (Object)new EitherHolder(this.getVariant())) : super.get(component));
    }

    protected void applyImplicitComponents(DataComponentGetter componentGetter) {
        this.applyImplicitComponentIfPresent(componentGetter, VariantsRegistry.SQUAWK_VARIANT_COM.get());
        super.applyImplicitComponents(componentGetter);
    }

    protected <T> boolean applyImplicitComponent(DataComponentType<T> component, T value) {
        if (component == VariantsRegistry.SQUAWK_VARIANT_COM.get()) {
            this.setVariant((Holder<SquawkVariant>)((Holder)OstrichEntity.castComponentValue(VariantsRegistry.SQUAWK_VARIANT_COM.get(), value)));
            return true;
        }
        return super.applyImplicitComponent(component, value);
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(DATA_VARIANT_ID, (Object)VariantUtils.getDefaultOrAny((RegistryAccess)this.registryAccess(), (ResourceKey)ResourceKey.create(VariantsRegistry.SQUAWK_VARIANT_REGISTRY_KEY, (Identifier)Identifier.fromNamespaceAndPath((String)"mounts_of_mayhem_plus", (String)"default"))));
    }

    protected void addAdditionalSaveData(ValueOutput output) {
        super.addAdditionalSaveData(output);
        VariantUtils.writeVariant((ValueOutput)output, this.getVariant());
    }

    protected void readAdditionalSaveData(ValueInput input) {
        super.readAdditionalSaveData(input);
        VariantUtils.readVariant((ValueInput)input, VariantsRegistry.SQUAWK_VARIANT_REGISTRY_KEY).ifPresent(this::setVariant);
    }

    @Nullable
    public SpawnGroupData finalizeSpawn(ServerLevelAccessor level, DifficultyInstance difficulty, EntitySpawnReason spawnReason, @Nullable SpawnGroupData spawnGroupData) {
        spawnGroupData = super.finalizeSpawn(level, difficulty, spawnReason, spawnGroupData);
        VariantUtils.selectVariantToSpawn((SpawnContext)SpawnContext.create((ServerLevelAccessor)level, (BlockPos)this.blockPosition()), VariantsRegistry.SQUAWK_VARIANT_REGISTRY_KEY).ifPresent(this::setVariant);
        return spawnGroupData;
    }

    public OstrichEntity(EntityType<? extends OstrichEntity> p_30894_, Level p_30895_) {
        super(p_30894_, p_30895_);
        this.setPathfindingMalus(PathType.WATER, 0.0f);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return OstrichEntity.createBaseHorseAttributes().add(Attributes.MAX_HEALTH, 20.0).add(Attributes.MOVEMENT_SPEED, 0.167);
    }

    public void aiStep() {
        super.aiStep();
        this.oFlap = this.flap;
        this.oFlapSpeed = this.flapSpeed;
        this.flapSpeed += (this.onGround() ? -1.0f : 4.0f) * 0.3f;
        this.flapSpeed = Mth.clamp((float)this.flapSpeed, (float)0.0f, (float)1.0f);
        if (!this.onGround() && this.flapping < 1.0f) {
            this.flapping = 1.0f;
        }
        this.flapping *= 0.9f;
        Vec3 vec3 = this.getDeltaMovement();
        if (!this.onGround() && vec3.y < 0.0) {
            this.setDeltaMovement(vec3.multiply(1.0, 0.6, 1.0));
        }
        this.flap += this.flapping * 2.0f;
    }

    protected void positionRider(Entity p_480146_, Entity.MoveFunction p_480620_) {
        super.positionRider(p_480146_, p_480620_);
        if (p_480146_ instanceof LivingEntity) {
            ((LivingEntity)p_480146_).yBodyRot = this.yBodyRot;
        }
    }

    protected boolean isFlapping() {
        return this.flyDist > this.nextFlap;
    }

    protected void onFlap() {
        this.nextFlap = this.flyDist + this.flapSpeed / 2.0f;
    }

    public static boolean checkPolarBearSpawnRules(EntityType<SpiderMountEntity> entityType, ServerLevelAccessor level, EntitySpawnReason spawnReason, BlockPos pos, RandomSource random) {
        Holder holder = level.getBiome(pos);
        return !holder.is(BiomeTags.POLAR_BEARS_SPAWN_ON_ALTERNATE_BLOCKS) ? OstrichEntity.checkMobSpawnRules(entityType, (LevelAccessor)level, (EntitySpawnReason)spawnReason, (BlockPos)pos, (RandomSource)random) : Monster.isDarkEnoughToSpawn((ServerLevelAccessor)level, (BlockPos)pos, (RandomSource)random) && level.getBlockState(pos.below()).is(BlockTags.POLAR_BEARS_SPAWNABLE_ON_ALTERNATE);
    }

    public boolean canUseSlot(EquipmentSlot p_348583_) {
        return !this.isBaby();
    }

    protected void hurtArmor(DamageSource p_379528_, float p_379933_) {
        this.doHurtEquipment(p_379528_, p_379933_, new EquipmentSlot[]{EquipmentSlot.BODY});
    }

    @Nullable
    public LivingEntity getControllingPassenger() {
        Entity var2;
        if (this.isSaddled() && !this.isImmobile() && (var2 = this.getFirstPassenger()) instanceof Player) {
            Player player = (Player)var2;
            return player;
        }
        return null;
    }

    protected void randomizeAttributes(RandomSource p_218821_) {
        AttributeInstance var10000 = this.getAttribute(Attributes.JUMP_STRENGTH);
        Objects.requireNonNull(p_218821_);
        var10000.setBaseValue(OstrichEntity.generateJumpStrength(() -> ((RandomSource)p_218821_).nextDouble()));
    }

    public boolean supportQuadLeash() {
        return false;
    }

    protected boolean canPerformRearing() {
        return false;
    }

    protected void addBehaviourGoals() {
    }

    protected SoundEvent getAmbientSound() {
        return SoundRegistry.SQUAWK_AMBIENT.get();
    }

    protected void playGallopSound(SoundType p_480127_) {
        this.playSound(SoundRegistry.SQUAWK_STEP.get(), p_480127_.getVolume() * 0.15f, p_480127_.getPitch());
        super.playGallopSound(p_480127_);
    }

    protected SoundEvent getDeathSound() {
        return SoundRegistry.SQUAWK_DEATH.get();
    }

    protected SoundEvent getHurtSound(DamageSource damageSource) {
        return SoundRegistry.SQUAWK_HURT.get();
    }

    protected SoundEvent getSwimSound() {
        return SoundEvents.GENERIC_SWIM;
    }

    protected Vec2 getRiddenRotation(LivingEntity entity) {
        return new Vec2(entity.getXRot() * 0.5f, entity.getYRot());
    }

    public float getVoicePitch() {
        return 5.0f;
    }

    protected void playSwimSound(float volume) {
        if (this.onGround()) {
            super.playSwimSound(0.3f);
        } else {
            super.playSwimSound(Math.min(0.1f, volume * 25.0f));
        }
    }

    protected float getWaterSlowDown() {
        return 0.0f;
    }

    public boolean canJump() {
        return true;
    }

    public void handleStopJump() {
    }

    protected void playJumpSound() {
        super.playJumpSound();
    }

    public InteractionResult mobInteract(Player player, InteractionHand hand) {
        boolean flag;
        boolean bl = flag = !this.isBaby() && this.isTamed() && player.isSecondaryUseActive();
        if (!this.isVehicle() && !flag) {
            ItemStack itemstack = player.getItemInHand(hand);
            if (!itemstack.isEmpty()) {
                if (this.isFood(itemstack)) {
                    return this.fedFood(player, itemstack);
                }
                if (!this.isTamed()) {
                    return InteractionResult.PASS;
                }
            }
            return super.mobInteract(player, hand);
        }
        return super.mobInteract(player, hand);
    }

    @Nullable
    public AgeableMob getBreedOffspring(ServerLevel p_149553_, AgeableMob p_149554_) {
        return (AgeableMob)EntityRegistry.SQUAWK.get().create((Level)p_149553_, EntitySpawnReason.BREEDING);
    }
}

