/*
 * Decompiled with CFR 0.152.
 */
package com.belgie.mounts_of_mayhem_plus.common.entity.ostrich;

import com.belgie.mounts_of_mayhem_plus.common.entity.ostrich.OstrichEntity;
import com.belgie.mounts_of_mayhem_plus.common.entity.ostrich.SquawkModel;
import com.belgie.mounts_of_mayhem_plus.common.entity.ostrich.SquawkRenderState;
import com.belgie.mounts_of_mayhem_plus.core.ClientEntityRegistry;
import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.Model;
import net.minecraft.client.model.geom.EntityModelSet;
import net.minecraft.client.renderer.SubmitNodeCollector;
import net.minecraft.client.renderer.entity.AgeableMobRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.renderer.entity.state.LivingEntityRenderState;
import net.minecraft.resources.Identifier;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;

public class OstrichRenderer
extends AgeableMobRenderer<OstrichEntity, SquawkRenderState, SquawkModel> {
    private static final Identifier GRAY = Identifier.fromNamespaceAndPath((String)"mounts_of_mayhem_plus", (String)"textures/entity/squawk.png");

    public OstrichRenderer(EntityRendererProvider.Context context) {
        super(context, (EntityModel)new SquawkModel(context.bakeLayer(ClientEntityRegistry.SQUAWK)), (EntityModel)new SquawkModel(context.bakeLayer(ClientEntityRegistry.SQUAWK_BABY)), 0.7f);
        this.addLayer(new SaddleLayer((RenderLayerParent<SquawkRenderState, SquawkModel>)this, context.getModelSet()));
    }

    public Identifier getTextureLocation(SquawkRenderState p_469910_) {
        return GRAY;
    }

    public SquawkRenderState createRenderState() {
        return new SquawkRenderState();
    }

    public void extractRenderState(OstrichEntity p_480995_, SquawkRenderState p_363082_, float p_361575_) {
        super.extractRenderState((LivingEntity)p_480995_, (LivingEntityRenderState)p_363082_, p_361575_);
        p_363082_.flap = Mth.lerp((float)p_361575_, (float)p_480995_.oFlap, (float)p_480995_.flap);
        p_363082_.flapSpeed = Mth.lerp((float)p_361575_, (float)p_480995_.oFlapSpeed, (float)p_480995_.flapSpeed);
        p_363082_.saddleItem = p_480995_.getItemBySlot(EquipmentSlot.SADDLE);
    }

    private static class SaddleLayer
    extends RenderLayer<SquawkRenderState, SquawkModel> {
        private static final Identifier CAT_COLLAR_LOCATION = Identifier.fromNamespaceAndPath((String)"mounts_of_mayhem_plus", (String)"textures/entity/equipment/squawk_saddle/saddle.png");
        private final SquawkModel adultModel;
        private final SquawkModel babyModel;

        public SaddleLayer(RenderLayerParent<SquawkRenderState, SquawkModel> renderer, EntityModelSet modelSet) {
            super(renderer);
            this.adultModel = new SquawkModel(modelSet.bakeLayer(ClientEntityRegistry.SQUAWK_SADDLE));
            this.babyModel = new SquawkModel(modelSet.bakeLayer(ClientEntityRegistry.SQUAWK_BABY_SADDLE));
        }

        public void submit(PoseStack p_434729_, SubmitNodeCollector p_435679_, int p_435603_, SquawkRenderState p_435848_, float p_435437_, float p_432910_) {
            ItemStack stack = p_435848_.saddleItem;
            if (!stack.isEmpty()) {
                SquawkModel catmodel = p_435848_.isBaby ? this.babyModel : this.adultModel;
                SaddleLayer.coloredCutoutModelCopyLayerRender((Model)catmodel, (Identifier)CAT_COLLAR_LOCATION, (PoseStack)p_434729_, (SubmitNodeCollector)p_435679_, (int)p_435603_, (LivingEntityRenderState)p_435848_, (int)-1, (int)1);
            }
        }
    }
}

