/*
 * Decompiled with CFR 0.152.
 */
package com.belgie.mounts_of_mayhem_plus.common.entity.ostrich;

import com.belgie.mounts_of_mayhem_plus.common.entity.ostrich.SquawkRenderState;
import java.util.Set;
import net.minecraft.client.model.BabyModelTransform;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.MeshTransformer;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.util.Mth;

public class SquawkModel
extends EntityModel<SquawkRenderState> {
    public static final MeshTransformer BABY_TRANSFORMER = new BabyModelTransform(true, 14.0f, 2.0f, 2.3f, 2.0f, 24.0f, Set.of("head"));
    private final ModelPart left_leg;
    private final ModelPart right_leg;
    private final ModelPart body;
    private final ModelPart head;
    private final ModelPart tail;
    private final ModelPart left_wing;
    private final ModelPart right_wing;

    public SquawkModel(ModelPart root) {
        super(root);
        this.left_leg = root.getChild("left_leg");
        this.right_leg = root.getChild("right_leg");
        this.body = root.getChild("body");
        this.head = root.getChild("head");
        this.tail = root.getChild("tail");
        this.left_wing = root.getChild("left_wing");
        this.right_wing = root.getChild("right_wing");
    }

    public static LayerDefinition createBodyLayer(boolean isBaby, float def) {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        PartDefinition left_leg = partdefinition.addOrReplaceChild("left_leg", CubeListBuilder.create().texOffs(60, 0).addBox(-2.5f, 8.0f, -4.5f, 5.0f, 0.0f, 7.0f, new CubeDeformation(def)).texOffs(60, 7).addBox(-1.5f, 0.0f, -1.5f, 3.0f, 8.0f, 3.0f, new CubeDeformation(def)), PartPose.offset((float)-2.5f, (float)16.0f, (float)0.5f));
        PartDefinition right_leg = partdefinition.addOrReplaceChild("right_leg", CubeListBuilder.create().texOffs(60, 0).addBox(-2.5f, 8.0f, -4.5f, 5.0f, 0.0f, 7.0f, new CubeDeformation(def)).texOffs(60, 7).mirror().addBox(-1.5f, 0.0f, -1.5f, 3.0f, 8.0f, 3.0f, new CubeDeformation(def)).mirror(false), PartPose.offset((float)2.5f, (float)16.0f, (float)0.5f));
        PartDefinition body = partdefinition.addOrReplaceChild("body", CubeListBuilder.create().texOffs(0, 0).addBox(-5.0f, -18.0f, -9.0f, 10.0f, 10.0f, 20.0f, new CubeDeformation(def)), PartPose.offset((float)0.0f, (float)24.0f, (float)0.0f));
        PartDefinition head = partdefinition.addOrReplaceChild("head", CubeListBuilder.create().texOffs(0, 30).addBox(-3.0f, -17.0f, -15.0f, 6.0f, 8.0f, 15.0f, new CubeDeformation(def)).texOffs(0, 53).addBox(-4.0f, -16.0f, -5.0f, 8.0f, 19.0f, 9.0f, new CubeDeformation(def)), PartPose.offset((float)0.0f, (float)9.0f, (float)-8.0f));
        PartDefinition tail = partdefinition.addOrReplaceChild("tail", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)7.0f, (float)11.0f));
        PartDefinition cube_r1 = tail.addOrReplaceChild("cube_r1", CubeListBuilder.create().texOffs(42, 46).addBox(-7.0f, -8.0f, 7.0f, 8.0f, 0.0f, 16.0f, new CubeDeformation(def)), PartPose.offsetAndRotation((float)3.0f, (float)11.0f, (float)-1.0f, (float)0.6981f, (float)0.0f, (float)0.0f));
        PartDefinition left_wing = partdefinition.addOrReplaceChild("left_wing", CubeListBuilder.create(), PartPose.offset((float)-5.0f, (float)6.0f, (float)1.0f));
        PartDefinition cube_r2 = left_wing.addOrReplaceChild("cube_r2", CubeListBuilder.create().texOffs(42, 30).mirror().addBox(-9.0f, -1.0f, -7.0f, 9.0f, 1.0f, 15.0f, new CubeDeformation(def)).mirror(false), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)-1.5708f));
        PartDefinition right_wing = partdefinition.addOrReplaceChild("right_wing", CubeListBuilder.create(), PartPose.offset((float)5.0f, (float)6.0f, (float)1.0f));
        PartDefinition cube_r3 = right_wing.addOrReplaceChild("cube_r3", CubeListBuilder.create().texOffs(42, 30).addBox(0.0f, -1.0f, -7.0f, 9.0f, 1.0f, 15.0f, new CubeDeformation(def)), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)1.5708f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)128, (int)128).apply(isBaby ? BABY_TRANSFORMER : MeshTransformer.IDENTITY);
    }

    public void setupAnim(SquawkRenderState p_482134_) {
        super.setupAnim((Object)p_482134_);
        float f = (Mth.sin((double)p_482134_.flap) + 1.0f) * p_482134_.flapSpeed;
        this.head.xRot = p_482134_.xRot * ((float)Math.PI / 180);
        this.head.yRot = p_482134_.yRot * ((float)Math.PI / 180);
        float f1 = p_482134_.walkAnimationSpeed;
        float f2 = p_482134_.walkAnimationPos;
        this.tail.xRot = -0.6981317f - f1 * Mth.sin((double)f2);
        this.right_leg.xRot = Mth.cos((double)(f2 * 0.6662f)) * 1.4f * f1;
        this.left_leg.xRot = Mth.cos((double)(f2 * 0.6662f + (float)Math.PI)) * 1.4f * f1;
        this.right_wing.zRot = -f;
        this.left_wing.zRot = f;
    }
}

