/*
 * Decompiled with CFR 0.152.
 */
package com.belgie.mounts_of_mayhem_plus.common.entity.sodden;

import com.belgie.mounts_of_mayhem_plus.common.variants.SoddenVariant;
import com.belgie.mounts_of_mayhem_plus.core.SoundRegistry;
import com.belgie.mounts_of_mayhem_plus.core.VariantsRegistry;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.component.DataComponentGetter;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.Identifier;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.monster.zombie.Zombie;
import net.minecraft.world.entity.variant.SpawnContext;
import net.minecraft.world.entity.variant.VariantUtils;
import net.minecraft.world.item.EitherHolder;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import net.neoforged.neoforge.event.EventHooks;

public class SoddenEntity
extends Zombie {
    private static final EntityDataAccessor<Holder<SoddenVariant>> DATA_VARIANT_ID = SynchedEntityData.defineId(SoddenEntity.class, VariantsRegistry.SODDEN_VARIANT.get());

    public Holder<SoddenVariant> getVariant() {
        return (Holder)this.entityData.get(DATA_VARIANT_ID);
    }

    private void setVariant(Holder<SoddenVariant> variant) {
        this.entityData.set(DATA_VARIANT_ID, variant);
    }

    @Nullable
    public <T> T get(DataComponentType<? extends T> component) {
        return (T)(component == VariantsRegistry.SODDEN_VARIANT_COM.get() ? SoddenEntity.castComponentValue(component, (Object)new EitherHolder(this.getVariant())) : super.get(component));
    }

    protected void applyImplicitComponents(DataComponentGetter componentGetter) {
        this.applyImplicitComponentIfPresent(componentGetter, VariantsRegistry.SODDEN_VARIANT_COM.get());
        super.applyImplicitComponents(componentGetter);
    }

    protected <T> boolean applyImplicitComponent(DataComponentType<T> component, T value) {
        if (component == VariantsRegistry.SODDEN_VARIANT_COM.get()) {
            this.setVariant((Holder<SoddenVariant>)((Holder)SoddenEntity.castComponentValue(VariantsRegistry.SODDEN_VARIANT_COM.get(), value)));
            return true;
        }
        return super.applyImplicitComponent(component, value);
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(DATA_VARIANT_ID, (Object)VariantUtils.getDefaultOrAny((RegistryAccess)this.registryAccess(), (ResourceKey)ResourceKey.create(VariantsRegistry.SODDEN_VARIANT_REGISTRY_KEY, (Identifier)Identifier.fromNamespaceAndPath((String)"mounts_of_mayhem_plus", (String)"default"))));
    }

    protected void addAdditionalSaveData(ValueOutput output) {
        super.addAdditionalSaveData(output);
        VariantUtils.writeVariant((ValueOutput)output, this.getVariant());
    }

    protected void readAdditionalSaveData(ValueInput input) {
        super.readAdditionalSaveData(input);
        VariantUtils.readVariant((ValueInput)input, VariantsRegistry.SODDEN_VARIANT_REGISTRY_KEY).ifPresent(this::setVariant);
    }

    @Nullable
    public SpawnGroupData finalizeSpawn(ServerLevelAccessor level, DifficultyInstance difficulty, EntitySpawnReason spawnReason, @Nullable SpawnGroupData spawnGroupData) {
        spawnGroupData = super.finalizeSpawn(level, difficulty, spawnReason, spawnGroupData);
        VariantUtils.selectVariantToSpawn((SpawnContext)SpawnContext.create((ServerLevelAccessor)level, (BlockPos)this.blockPosition()), VariantsRegistry.SODDEN_VARIANT_REGISTRY_KEY).ifPresent(this::setVariant);
        float f = difficulty.getSpecialMultiplier();
        if (spawnReason != EntitySpawnReason.CONVERSION) {
            this.setCanPickUpLoot(level.getRandom().nextFloat() < 0.55f * f);
        }
        return spawnGroupData;
    }

    public SoddenEntity(EntityType<? extends SoddenEntity> p_32889_, Level p_32890_) {
        super(p_32889_, p_32890_);
    }

    protected SoundEvent getAmbientSound() {
        return SoundRegistry.SODDEN_AMBIENT.get();
    }

    protected SoundEvent getHurtSound(DamageSource damageSource) {
        return SoundRegistry.SODDEN_HURT.get();
    }

    protected SoundEvent getDeathSound() {
        return SoundRegistry.SODDEN_DEATH.get();
    }

    protected SoundEvent getStepSound() {
        return SoundRegistry.SODDEN_STEP.get();
    }

    public float getVoicePitch() {
        return -1.0f;
    }

    public boolean doHurtTarget(ServerLevel p_376715_, Entity p_32892_) {
        boolean flag = super.doHurtTarget(p_376715_, p_32892_);
        if (flag && this.getMainHandItem().isEmpty() && p_32892_ instanceof LivingEntity) {
            float f = p_376715_.getCurrentDifficultyAt(this.blockPosition()).getEffectiveDifficulty();
            ((LivingEntity)p_32892_).addEffect(new MobEffectInstance(MobEffects.BLINDNESS, 140 * (int)f), (Entity)this);
        }
        return flag;
    }

    protected boolean convertsInWater() {
        return true;
    }

    protected void doUnderWaterConversion(ServerLevel p_478247_) {
        if (EventHooks.canLivingConvert((LivingEntity)this, (EntityType)EntityType.ZOMBIE, timer -> {
            this.conversionTime = timer;
        })) {
            this.convertToZombieType(p_478247_, EntityType.ZOMBIE);
            if (!this.isSilent()) {
                p_478247_.levelEvent((Entity)null, 1041, this.blockPosition(), 0);
            }
        }
    }
}

