/*
 * Decompiled with CFR 0.152.
 */
package com.belgie.mounts_of_mayhem_plus.common.entity.spider;

import com.belgie.mounts_of_mayhem_plus.common.entity.spider.SpiderRenderState;
import java.util.Set;
import net.minecraft.client.model.BabyModelTransform;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.MeshTransformer;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.util.Mth;

public class SpiderModel
extends EntityModel<SpiderRenderState> {
    private static final MeshTransformer BABY_TRANSFORMER = new BabyModelTransform(true, 16.0f, 4.0f, 2.25f, 2.0f, 24.0f, Set.of("head"));
    private final ModelPart root;
    private final ModelPart body;
    private final ModelPart abdomen;
    private final ModelPart leg0;
    private final ModelPart leg1;
    private final ModelPart leg2;
    private final ModelPart leg3;
    private final ModelPart leg4;
    private final ModelPart leg5;
    private final ModelPart leg6;
    private final ModelPart leg7;
    private final ModelPart fangs;

    public SpiderModel(ModelPart root) {
        super(root);
        this.root = root.getChild("root");
        this.body = this.root.getChild("body");
        this.abdomen = this.body.getChild("abdomen");
        this.leg0 = this.root.getChild("leg0");
        this.leg1 = this.root.getChild("leg1");
        this.leg2 = this.root.getChild("leg2");
        this.leg3 = this.root.getChild("leg3");
        this.leg4 = this.root.getChild("leg4");
        this.leg5 = this.root.getChild("leg5");
        this.leg6 = this.root.getChild("leg6");
        this.leg7 = this.root.getChild("leg7");
        this.fangs = this.root.getChild("fangs");
    }

    public static LayerDefinition createBodyLayer(boolean isBaby, float def) {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        PartDefinition root = partdefinition.addOrReplaceChild("root", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)24.0f, (float)0.0f));
        PartDefinition body = root.addOrReplaceChild("body", CubeListBuilder.create().texOffs(0, 26).addBox(-4.0f, -4.0f, -7.0f, 8.0f, 8.0f, 14.0f, new CubeDeformation(def)), PartPose.offset((float)0.0f, (float)-8.0f, (float)0.0f));
        PartDefinition abdomen = body.addOrReplaceChild("abdomen", CubeListBuilder.create().texOffs(0, 0).addBox(-6.0f, -5.0f, 0.0f, 12.0f, 10.0f, 16.0f, new CubeDeformation(def)), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)7.0f, (float)0.5236f, (float)0.0f, (float)0.0f));
        PartDefinition leg0 = root.addOrReplaceChild("leg0", CubeListBuilder.create().texOffs(44, 26).mirror().addBox(-17.0f, -1.5f, -2.5f, 16.0f, 3.0f, 3.0f, new CubeDeformation(def)).mirror(false), PartPose.offsetAndRotation((float)-4.0f, (float)-8.0f, (float)-3.5f, (float)0.0f, (float)-0.7854f, (float)-0.5236f));
        PartDefinition leg1 = root.addOrReplaceChild("leg1", CubeListBuilder.create().texOffs(44, 26).mirror().addBox(-16.0f, -1.5f, -1.5f, 16.0f, 3.0f, 3.0f, new CubeDeformation(def)).mirror(false), PartPose.offsetAndRotation((float)-4.0f, (float)-8.0f, (float)-1.5f, (float)0.0f, (float)-0.3927f, (float)-0.5236f));
        PartDefinition leg2 = root.addOrReplaceChild("leg2", CubeListBuilder.create().texOffs(44, 26).mirror().addBox(-16.0f, -1.5f, -1.5f, 16.0f, 3.0f, 3.0f, new CubeDeformation(def)).mirror(false), PartPose.offsetAndRotation((float)-4.0f, (float)-8.0f, (float)1.5f, (float)0.0f, (float)0.3927f, (float)-0.5236f));
        PartDefinition leg3 = root.addOrReplaceChild("leg3", CubeListBuilder.create().texOffs(44, 26).mirror().addBox(-16.0f, -1.5f, -1.5f, 16.0f, 3.0f, 3.0f, new CubeDeformation(def)).mirror(false), PartPose.offsetAndRotation((float)-4.0f, (float)-8.0f, (float)3.5f, (float)0.0f, (float)0.7854f, (float)-0.5236f));
        PartDefinition leg4 = root.addOrReplaceChild("leg4", CubeListBuilder.create().texOffs(44, 26).addBox(1.0f, -1.5f, -1.5f, 16.0f, 3.0f, 3.0f, new CubeDeformation(def)), PartPose.offsetAndRotation((float)4.0f, (float)-8.0f, (float)-3.5f, (float)0.0f, (float)0.7854f, (float)0.5236f));
        PartDefinition leg5 = root.addOrReplaceChild("leg5", CubeListBuilder.create().texOffs(44, 26).addBox(0.0f, -1.5f, -1.5f, 16.0f, 3.0f, 3.0f, new CubeDeformation(def)), PartPose.offsetAndRotation((float)4.0f, (float)-8.0f, (float)-1.5f, (float)0.0f, (float)0.3927f, (float)0.5236f));
        PartDefinition leg6 = root.addOrReplaceChild("leg6", CubeListBuilder.create().texOffs(44, 26).addBox(0.0f, -1.5f, -1.5f, 16.0f, 3.0f, 3.0f, new CubeDeformation(def)), PartPose.offsetAndRotation((float)4.0f, (float)-8.0f, (float)1.5f, (float)0.0f, (float)-0.3927f, (float)0.5236f));
        PartDefinition leg7 = root.addOrReplaceChild("leg7", CubeListBuilder.create().texOffs(44, 26).addBox(0.0f, -1.5f, -1.5f, 16.0f, 3.0f, 3.0f, new CubeDeformation(def)), PartPose.offsetAndRotation((float)4.0f, (float)-8.0f, (float)3.5f, (float)0.0f, (float)-0.7854f, (float)0.5236f));
        PartDefinition fangs = root.addOrReplaceChild("fangs", CubeListBuilder.create().texOffs(0, 0).mirror().addBox(1.0f, -3.0f, -1.0f, 0.0f, 3.0f, 2.0f, new CubeDeformation(def)).mirror(false).texOffs(0, 0).addBox(-5.0f, -3.0f, -1.0f, 0.0f, 3.0f, 2.0f, new CubeDeformation(def)), PartPose.offset((float)2.0f, (float)-5.0f, (float)-8.0f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)128, (int)128).apply(isBaby ? BABY_TRANSFORMER : MeshTransformer.IDENTITY);
    }

    public void setupAnim(SpiderRenderState p_480578_) {
        super.setupAnim((Object)p_480578_);
        float f = p_480578_.walkAnimationPos * 0.6662f;
        float f1 = p_480578_.walkAnimationSpeed;
        boolean hasPassenger = p_480578_.passenger;
        float amount = hasPassenger ? 0.2f : 0.9f;
        float f2 = -(Mth.cos((double)(f * 2.0f + 0.0f)) * amount) * f1;
        float f3 = -(Mth.cos((double)(f * 2.0f + (float)Math.PI)) * amount) * f1;
        float f4 = -(Mth.cos((double)(f * 2.0f + 1.5707964f)) * amount) * f1;
        float f5 = -(Mth.cos((double)(f * 2.0f + 4.712389f)) * amount) * f1;
        float f6 = Math.abs(Mth.sin((double)(f + 0.0f)) * amount) * f1;
        float f7 = Math.abs(Mth.sin((double)(f + (float)Math.PI)) * amount) * f1;
        float f8 = Math.abs(Mth.sin((double)(f + 1.5707964f)) * amount) * f1;
        float f9 = Math.abs(Mth.sin((double)(f + 4.712389f)) * amount) * f1;
        this.leg0.y += 0.1f;
        this.leg4.y -= 0.1f;
        this.leg3.y += 0.1f;
        this.leg7.y -= 0.1f;
        ModelPart var10000 = this.leg7;
        var10000.yRot += f2;
        var10000 = this.leg3;
        var10000.yRot -= f2;
        var10000 = this.leg6;
        var10000.yRot += f3;
        var10000 = this.leg2;
        var10000.yRot -= f3;
        var10000 = this.leg5;
        var10000.yRot += f4;
        var10000 = this.leg1;
        var10000.yRot -= f4;
        var10000 = this.leg4;
        var10000.yRot += f5;
        var10000 = this.leg0;
        var10000.yRot -= f5;
        var10000 = this.leg7;
        var10000.zRot += f6;
        var10000 = this.leg3;
        var10000.zRot -= f6;
        var10000 = this.leg6;
        var10000.zRot += f7;
        var10000 = this.leg2;
        var10000.zRot -= f7;
        var10000 = this.leg5;
        var10000.zRot += f8;
        var10000 = this.leg1;
        var10000.zRot -= f8;
        var10000 = this.leg4;
        var10000.zRot += f9;
        var10000 = this.leg0;
        var10000.zRot -= f9;
    }
}

