/*
 * Decompiled with CFR 0.152.
 */
package com.belgie.mounts_of_mayhem_plus.common.entity.spider;

import com.belgie.mounts_of_mayhem_plus.common.variants.SilkfangVariant;
import com.belgie.mounts_of_mayhem_plus.core.EntityRegistry;
import com.belgie.mounts_of_mayhem_plus.core.SoundRegistry;
import com.belgie.mounts_of_mayhem_plus.core.VariantsRegistry;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.component.DataComponentGetter;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.Identifier;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.ai.navigation.WallClimberNavigation;
import net.minecraft.world.entity.animal.equine.AbstractHorse;
import net.minecraft.world.entity.monster.skeleton.Skeleton;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.variant.SpawnContext;
import net.minecraft.world.entity.variant.VariantUtils;
import net.minecraft.world.item.EitherHolder;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import net.minecraft.world.phys.Vec3;

public class SpiderMountEntity
extends AbstractHorse {
    private static final EntityDataAccessor<Byte> DATA_FLAGS_ID = SynchedEntityData.defineId(SpiderMountEntity.class, (EntityDataSerializer)EntityDataSerializers.BYTE);
    private static final EntityDataAccessor<Holder<SilkfangVariant>> DATA_VARIANT_ID = SynchedEntityData.defineId(SpiderMountEntity.class, VariantsRegistry.SILKFANG_VARIANT.get());

    public Holder<SilkfangVariant> getVariant() {
        return (Holder)this.entityData.get(DATA_VARIANT_ID);
    }

    private void setVariant(Holder<SilkfangVariant> variant) {
        this.entityData.set(DATA_VARIANT_ID, variant);
    }

    @Nullable
    public <T> T get(DataComponentType<? extends T> component) {
        return (T)(component == VariantsRegistry.SILKFANG_VARIANT_COM.get() ? SpiderMountEntity.castComponentValue(component, (Object)new EitherHolder(this.getVariant())) : super.get(component));
    }

    protected void applyImplicitComponents(DataComponentGetter componentGetter) {
        this.applyImplicitComponentIfPresent(componentGetter, VariantsRegistry.SILKFANG_VARIANT_COM.get());
        super.applyImplicitComponents(componentGetter);
    }

    protected <T> boolean applyImplicitComponent(DataComponentType<T> component, T value) {
        if (component == VariantsRegistry.SILKFANG_VARIANT_COM.get()) {
            this.setVariant((Holder<SilkfangVariant>)((Holder)SpiderMountEntity.castComponentValue(VariantsRegistry.SILKFANG_VARIANT_COM.get(), value)));
            return true;
        }
        return super.applyImplicitComponent(component, value);
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(DATA_VARIANT_ID, (Object)VariantUtils.getDefaultOrAny((RegistryAccess)this.registryAccess(), (ResourceKey)ResourceKey.create(VariantsRegistry.SILKFANG_VARIANT_REGISTRY_KEY, (Identifier)Identifier.fromNamespaceAndPath((String)"mounts_of_mayhem_plus", (String)"default"))));
        builder.define(DATA_FLAGS_ID, (Object)0);
    }

    protected void addAdditionalSaveData(ValueOutput output) {
        super.addAdditionalSaveData(output);
        VariantUtils.writeVariant((ValueOutput)output, this.getVariant());
    }

    protected void readAdditionalSaveData(ValueInput input) {
        super.readAdditionalSaveData(input);
        VariantUtils.readVariant((ValueInput)input, VariantsRegistry.SILKFANG_VARIANT_REGISTRY_KEY).ifPresent(this::setVariant);
    }

    @Nullable
    public SpawnGroupData finalizeSpawn(ServerLevelAccessor level, DifficultyInstance difficulty, EntitySpawnReason spawnReason, @Nullable SpawnGroupData spawnGroupData) {
        Skeleton mob;
        spawnGroupData = super.finalizeSpawn(level, difficulty, spawnReason, spawnGroupData);
        VariantUtils.selectVariantToSpawn((SpawnContext)SpawnContext.create((ServerLevelAccessor)level, (BlockPos)this.blockPosition()), VariantsRegistry.SILKFANG_VARIANT_REGISTRY_KEY).ifPresent(this::setVariant);
        if (spawnReason == EntitySpawnReason.NATURAL && (mob = (Skeleton)EntityType.SKELETON.create(this.level(), EntitySpawnReason.JOCKEY)) != null) {
            mob.snapTo(this.getX(), this.getY(), this.getZ(), this.getYRot(), 0.0f);
            mob.finalizeSpawn(level, difficulty, spawnReason, (SpawnGroupData)null);
            mob.setBaby(false);
            mob.setItemSlot(EquipmentSlot.MAINHAND, new ItemStack((ItemLike)Items.BOW));
            mob.startRiding((Entity)this, false, false);
        }
        return spawnGroupData;
    }

    public SpiderMountEntity(EntityType<? extends SpiderMountEntity> p_30894_, Level p_30895_) {
        super(p_30894_, p_30895_);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return SpiderMountEntity.createBaseHorseAttributes().add(Attributes.MAX_HEALTH, 16.0).add(Attributes.MOVEMENT_SPEED, 0.21);
    }

    public void tick() {
        super.tick();
        if (!this.level().isClientSide()) {
            this.setClimbing(this.horizontalCollision);
        }
    }

    protected void playGallopSound(SoundType p_480127_) {
        this.playSound(SoundRegistry.SILKFANG_STEP.get(), p_480127_.getVolume() * 0.15f, p_480127_.getPitch());
    }

    public boolean isClimbing() {
        return ((Byte)this.entityData.get(DATA_FLAGS_ID) & 1) != 0;
    }

    public void setClimbing(boolean p_479138_) {
        byte b0 = (Byte)this.entityData.get(DATA_FLAGS_ID);
        b0 = p_479138_ ? (byte)(b0 | 1) : (byte)(b0 & 0xFFFFFFFE);
        this.entityData.set(DATA_FLAGS_ID, (Object)b0);
    }

    public void makeStuckInBlock(BlockState p_478894_, Vec3 p_481381_) {
        if (!p_478894_.is(Blocks.COBWEB)) {
            super.makeStuckInBlock(p_478894_, p_481381_);
        }
    }

    public void travel(Vec3 movementInput) {
        if (this.isVehicle() && this.getFirstPassenger() instanceof Player) {
            super.travel(movementInput);
            if (this.horizontalCollision) {
                this.setDeltaMovement(this.getDeltaMovement().x, 0.2, this.getDeltaMovement().z);
            }
        } else {
            super.travel(movementInput);
        }
    }

    public boolean onClimbable() {
        return this.isClimbing();
    }

    protected PathNavigation createNavigation(Level p_478204_) {
        return new WallClimberNavigation((Mob)this, p_478204_);
    }

    public boolean canUseSlot(EquipmentSlot p_348583_) {
        return !this.isBaby();
    }

    protected void addBehaviourGoals() {
    }

    protected SoundEvent getAmbientSound() {
        return SoundRegistry.SILKFANG_AMBIENT.get();
    }

    protected SoundEvent getDeathSound() {
        return SoundRegistry.SILKFANG_DEATH.get();
    }

    protected SoundEvent getHurtSound(DamageSource damageSource) {
        return SoundRegistry.SILKFANG_HURT.get();
    }

    public Vec3 getLeashOffset() {
        return new Vec3(0.0, 0.75 * (double)this.getEyeHeight(), (double)this.getBbWidth() * 0.1);
    }

    protected boolean canPerformRearing() {
        return false;
    }

    public boolean supportQuadLeash() {
        return false;
    }

    protected SoundEvent getSwimSound() {
        return SoundEvents.GENERIC_SWIM;
    }

    public float getVoicePitch() {
        return -1.0f;
    }

    protected void playSwimSound(float volume) {
        if (this.onGround()) {
            super.playSwimSound(0.3f);
        } else {
            super.playSwimSound(Math.min(0.1f, volume * 25.0f));
        }
    }

    public boolean canJump() {
        return false;
    }

    public InteractionResult mobInteract(Player player, InteractionHand hand) {
        boolean flag;
        boolean bl = flag = !this.isBaby() && this.isTamed() && player.isSecondaryUseActive();
        if (!this.isVehicle() && !flag) {
            ItemStack itemstack = player.getItemInHand(hand);
            if (!itemstack.isEmpty()) {
                if (this.isFood(itemstack)) {
                    return this.fedFood(player, itemstack);
                }
                if (!this.isTamed()) {
                    return InteractionResult.PASS;
                }
            }
            return super.mobInteract(player, hand);
        }
        return super.mobInteract(player, hand);
    }

    @Nullable
    public AgeableMob getBreedOffspring(ServerLevel p_149553_, AgeableMob p_149554_) {
        return (AgeableMob)EntityRegistry.SILKFANG.get().create((Level)p_149553_, EntitySpawnReason.BREEDING);
    }
}

