/*
 * Decompiled with CFR 0.152.
 */
package com.belgie.mounts_of_mayhem_plus.common.entity.spider;

import com.belgie.mounts_of_mayhem_plus.common.entity.spider.SpiderModel;
import com.belgie.mounts_of_mayhem_plus.common.entity.spider.SpiderMountEntity;
import com.belgie.mounts_of_mayhem_plus.common.entity.spider.SpiderRenderState;
import com.belgie.mounts_of_mayhem_plus.core.ClientEntityRegistry;
import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.Model;
import net.minecraft.client.model.geom.EntityModelSet;
import net.minecraft.client.renderer.SubmitNodeCollector;
import net.minecraft.client.renderer.entity.AgeableMobRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.renderer.entity.state.LivingEntityRenderState;
import net.minecraft.resources.Identifier;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;

public class SpiderMountRenderer
extends AgeableMobRenderer<SpiderMountEntity, SpiderRenderState, SpiderModel> {
    private static final Identifier HOGLIN_LOCATION = Identifier.fromNamespaceAndPath((String)"mounts_of_mayhem_plus", (String)"textures/entity/silkfang.png");

    public SpiderMountRenderer(EntityRendererProvider.Context p_174165_) {
        super(p_174165_, (EntityModel)new SpiderModel(p_174165_.bakeLayer(ClientEntityRegistry.SPIDER)), (EntityModel)new SpiderModel(p_174165_.bakeLayer(ClientEntityRegistry.SPIDER_BABY)), 0.7f);
        this.addLayer(new SaddleLayer((RenderLayerParent<SpiderRenderState, SpiderModel>)this, p_174165_.getModelSet()));
    }

    public void extractRenderState(SpiderMountEntity p_361728_, SpiderRenderState p_360522_, float p_363399_) {
        super.extractRenderState((LivingEntity)p_361728_, (LivingEntityRenderState)p_360522_, p_363399_);
        p_360522_.saddle = p_361728_.getItemBySlot(EquipmentSlot.SADDLE).copy();
        p_360522_.passenger = !p_361728_.getPassengers().isEmpty();
    }

    public SpiderRenderState createRenderState() {
        return new SpiderRenderState();
    }

    public Identifier getTextureLocation(SpiderRenderState p_364914_) {
        return HOGLIN_LOCATION;
    }

    private static class SaddleLayer
    extends RenderLayer<SpiderRenderState, SpiderModel> {
        private static final Identifier CAT_COLLAR_LOCATION = Identifier.fromNamespaceAndPath((String)"mounts_of_mayhem_plus", (String)"textures/entity/equipment/silkfang_saddle/saddle.png");
        private final SpiderModel adultModel;
        private final SpiderModel babyModel;

        public SaddleLayer(RenderLayerParent<SpiderRenderState, SpiderModel> renderer, EntityModelSet modelSet) {
            super(renderer);
            this.adultModel = new SpiderModel(modelSet.bakeLayer(ClientEntityRegistry.SPIDER_SADDLE));
            this.babyModel = new SpiderModel(modelSet.bakeLayer(ClientEntityRegistry.SPIDER_SADDLE_BABY));
        }

        public void submit(PoseStack p_434729_, SubmitNodeCollector p_435679_, int p_435603_, SpiderRenderState p_435848_, float p_435437_, float p_432910_) {
            ItemStack stack = p_435848_.saddle;
            if (!stack.isEmpty()) {
                SpiderModel catmodel = p_435848_.isBaby ? this.babyModel : this.adultModel;
                SaddleLayer.coloredCutoutModelCopyLayerRender((Model)catmodel, (Identifier)CAT_COLLAR_LOCATION, (PoseStack)p_434729_, (SubmitNodeCollector)p_435679_, (int)p_435603_, (LivingEntityRenderState)p_435848_, (int)-1, (int)1);
            }
        }
    }
}

