/*
 * Decompiled with CFR 0.152.
 */
package com.belgie.mounts_of_mayhem_plus.common.entity.warboar;

import com.belgie.mounts_of_mayhem_plus.common.entity.warboar.WarBoarRenderState;
import java.util.Set;
import net.minecraft.client.model.BabyModelTransform;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.MeshTransformer;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.util.Mth;

public class WarBoarModel
extends EntityModel<WarBoarRenderState> {
    private final ModelPart body;
    private final ModelPart mane;
    private final ModelPart front_left_leg;
    private final ModelPart front_right_leg;
    private final ModelPart back_left_leg;
    private final ModelPart back_right_leg;
    private final ModelPart head;
    private final ModelPart left_ear;
    private final ModelPart right_ear;
    public static final MeshTransformer BABY_TRANSFORMER = new BabyModelTransform(true, 8.0f, 6.0f, 1.9f, 2.0f, 24.0f, Set.of("head"));

    public WarBoarModel(ModelPart root) {
        super(root);
        this.body = root.getChild("body");
        this.mane = this.body.getChild("mane");
        this.front_left_leg = root.getChild("front_left_leg");
        this.front_right_leg = root.getChild("front_right_leg");
        this.back_left_leg = root.getChild("back_left_leg");
        this.back_right_leg = root.getChild("back_right_leg");
        this.head = root.getChild("head");
        this.left_ear = this.head.getChild("left_ear");
        this.right_ear = this.head.getChild("right_ear");
    }

    public static LayerDefinition createBodyLayer(float deformation, boolean isBaby) {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        PartDefinition body = partdefinition.addOrReplaceChild("body", CubeListBuilder.create().texOffs(1, 1).addBox(-8.0f, -7.0f, -13.0f, 16.0f, 14.0f, 26.0f, new CubeDeformation(deformation)), PartPose.offset((float)0.0f, (float)10.0f, (float)0.0f));
        PartDefinition mane = body.addOrReplaceChild("mane", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)-14.0f, (float)-7.0f));
        PartDefinition mane_r1 = mane.addOrReplaceChild("mane_r1", CubeListBuilder.create().texOffs(100, 43).addBox(0.0f, -8.0f, -5.5f, 0.0f, 10.0f, 9.0f, new CubeDeformation(deformation)), PartPose.offsetAndRotation((float)0.0f, (float)8.0f, (float)-2.5f, (float)-0.1745f, (float)0.0f, (float)0.0f));
        PartDefinition front_left_leg = partdefinition.addOrReplaceChild("front_left_leg", CubeListBuilder.create().texOffs(41, 47).addBox(-3.0f, 0.0f, -2.75f, 6.0f, 9.0f, 6.0f, new CubeDeformation(deformation)), PartPose.offset((float)4.0f, (float)15.0f, (float)-9.25f));
        PartDefinition front_right_leg = partdefinition.addOrReplaceChild("front_right_leg", CubeListBuilder.create().texOffs(66, 47).addBox(-3.0f, 0.0f, -3.0f, 6.0f, 9.0f, 6.0f, new CubeDeformation(deformation)), PartPose.offset((float)-4.0f, (float)15.0f, (float)-9.0f));
        PartDefinition back_left_leg = partdefinition.addOrReplaceChild("back_left_leg", CubeListBuilder.create().texOffs(0, 47).addBox(-2.5f, 0.0f, -2.5f, 5.0f, 9.0f, 5.0f, new CubeDeformation(deformation)), PartPose.offset((float)4.5f, (float)15.0f, (float)9.5f));
        PartDefinition back_right_leg = partdefinition.addOrReplaceChild("back_right_leg", CubeListBuilder.create().texOffs(21, 47).addBox(-2.5f, -2.0f, -2.5f, 5.0f, 9.0f, 5.0f, new CubeDeformation(deformation)), PartPose.offset((float)-4.5f, (float)17.0f, (float)9.5f));
        PartDefinition head = partdefinition.addOrReplaceChild("head", CubeListBuilder.create().texOffs(61, 1).addBox(-7.0f, -3.0f, -19.0f, 14.0f, 6.0f, 19.0f, new CubeDeformation(deformation)).texOffs(1, 13).addBox(6.0f, -9.0f, -13.0f, 2.0f, 11.0f, 2.0f, new CubeDeformation(deformation)).texOffs(10, 13).addBox(-8.0f, -9.0f, -13.0f, 2.0f, 11.0f, 2.0f, new CubeDeformation(deformation)), PartPose.offsetAndRotation((float)0.0f, (float)6.0f, (float)-13.0f, (float)0.8727f, (float)0.0f, (float)0.0f));
        PartDefinition head_rotation_r1 = head.addOrReplaceChild("head_rotation_r1", CubeListBuilder.create().texOffs(1, 13).mirror().addBox(-1.0f, -1.0f, -1.0f, 2.0f, 2.0f, 2.0f, new CubeDeformation(deformation)).mirror(false), PartPose.offsetAndRotation((float)-5.0f, (float)-8.0f, (float)-12.0f, (float)0.0f, (float)0.0f, (float)1.5708f));
        PartDefinition head_rotation_r2 = head.addOrReplaceChild("head_rotation_r2", CubeListBuilder.create().texOffs(1, 13).addBox(-1.0f, -1.0f, -1.0f, 2.0f, 2.0f, 2.0f, new CubeDeformation(deformation)), PartPose.offsetAndRotation((float)5.0f, (float)-8.0f, (float)-12.0f, (float)0.0f, (float)0.0f, (float)-1.5708f));
        head.addOrReplaceChild("right_ear", CubeListBuilder.create().texOffs(1, 1).addBox(-6.0f, -1.0f, -2.0f, 6.0f, 1.0f, 4.0f), PartPose.offsetAndRotation((float)-6.0f, (float)-2.0f, (float)-3.0f, (float)0.0f, (float)0.0f, (float)-0.6981317f));
        head.addOrReplaceChild("left_ear", CubeListBuilder.create().texOffs(1, 6).addBox(0.0f, -1.0f, -2.0f, 6.0f, 1.0f, 4.0f), PartPose.offsetAndRotation((float)6.0f, (float)-2.0f, (float)-3.0f, (float)0.0f, (float)0.0f, (float)0.6981317f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)128, (int)64).apply(isBaby ? BABY_TRANSFORMER : MeshTransformer.IDENTITY);
    }

    public static LayerDefinition createSaddle(boolean isBaby) {
        return WarBoarModel.createBodyLayer(0.5f, isBaby);
    }

    public void setupAnim(WarBoarRenderState p_364969_) {
        super.setupAnim((Object)p_364969_);
        float f = p_364969_.walkAnimationSpeed;
        float f1 = p_364969_.walkAnimationPos;
        this.right_ear.zRot = -0.6981317f - f * Mth.sin((double)f1);
        this.left_ear.zRot = 0.6981317f + f * Mth.sin((double)f1);
        this.head.yRot = p_364969_.yRot * ((float)Math.PI / 180);
        float f2 = 1.0f - (float)Mth.abs((int)(10 - 2 * p_364969_.attackAnimationRemainingTicks)) / 10.0f;
        this.head.xRot = Mth.lerp((float)f2, (float)0.87266463f, (float)-0.34906584f);
        if (p_364969_.isBaby) {
            ModelPart var10000 = this.head;
            var10000.y += f2 * 2.5f;
        }
        float f3 = 1.2f;
        this.front_right_leg.xRot = Mth.cos((double)f1) * f3 * f;
        this.back_right_leg.xRot = this.front_left_leg.xRot = Mth.cos((double)(f1 + (float)Math.PI)) * f3 * f;
        this.back_left_leg.xRot = this.front_right_leg.xRot;
    }
}

