/*
 * Decompiled with CFR 0.152.
 */
package com.belgie.mounts_of_mayhem_plus.common.entity.witherHorse;

import com.belgie.mounts_of_mayhem_plus.common.variants.WitherHorseVariant;
import com.belgie.mounts_of_mayhem_plus.core.EntityRegistry;
import com.belgie.mounts_of_mayhem_plus.core.MobEffectRegistry;
import com.belgie.mounts_of_mayhem_plus.core.SoundRegistry;
import com.belgie.mounts_of_mayhem_plus.core.VariantsRegistry;
import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.component.DataComponentGetter;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.Identifier;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityAttachment;
import net.minecraft.world.entity.EntityAttachments;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.animal.equine.AbstractHorse;
import net.minecraft.world.entity.monster.skeleton.WitherSkeleton;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.variant.SpawnContext;
import net.minecraft.world.entity.variant.VariantUtils;
import net.minecraft.world.item.EitherHolder;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.pathfinder.PathType;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import net.minecraft.world.phys.Vec3;

public class WitherHorseEntity
extends AbstractHorse {
    private static final EntityDimensions BABY_DIMENSIONS;
    private static final EntityDataAccessor<Holder<WitherHorseVariant>> DATA_VARIANT_ID;

    public Holder<WitherHorseVariant> getVariant() {
        return (Holder)this.entityData.get(DATA_VARIANT_ID);
    }

    private void setVariant(Holder<WitherHorseVariant> variant) {
        this.entityData.set(DATA_VARIANT_ID, variant);
    }

    @Nullable
    public <T> T get(DataComponentType<? extends T> component) {
        return (T)(component == VariantsRegistry.WITHER_HORSE_VARIANT_COM.get() ? WitherHorseEntity.castComponentValue(component, (Object)new EitherHolder(this.getVariant())) : super.get(component));
    }

    protected void applyImplicitComponents(DataComponentGetter componentGetter) {
        this.applyImplicitComponentIfPresent(componentGetter, VariantsRegistry.WITHER_HORSE_VARIANT_COM.get());
        super.applyImplicitComponents(componentGetter);
    }

    protected <T> boolean applyImplicitComponent(DataComponentType<T> component, T value) {
        if (component == VariantsRegistry.WITHER_HORSE_VARIANT_COM.get()) {
            this.setVariant((Holder<WitherHorseVariant>)((Holder)WitherHorseEntity.castComponentValue(VariantsRegistry.WITHER_HORSE_VARIANT_COM.get(), value)));
            return true;
        }
        return super.applyImplicitComponent(component, value);
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(DATA_VARIANT_ID, (Object)VariantUtils.getDefaultOrAny((RegistryAccess)this.registryAccess(), (ResourceKey)ResourceKey.create(VariantsRegistry.WITHER_HORSE_VARIANT_REGISTRY_KEY, (Identifier)Identifier.fromNamespaceAndPath((String)"mounts_of_mayhem_plus", (String)"default"))));
    }

    protected void addAdditionalSaveData(ValueOutput output) {
        super.addAdditionalSaveData(output);
        VariantUtils.writeVariant((ValueOutput)output, this.getVariant());
    }

    protected void readAdditionalSaveData(ValueInput input) {
        super.readAdditionalSaveData(input);
        VariantUtils.readVariant((ValueInput)input, VariantsRegistry.WITHER_HORSE_VARIANT_REGISTRY_KEY).ifPresent(this::setVariant);
    }

    @Nullable
    public SpawnGroupData finalizeSpawn(ServerLevelAccessor level, DifficultyInstance difficulty, EntitySpawnReason spawnReason, @Nullable SpawnGroupData spawnGroupData) {
        WitherSkeleton zombieEntity;
        spawnGroupData = super.finalizeSpawn(level, difficulty, spawnReason, spawnGroupData);
        VariantUtils.selectVariantToSpawn((SpawnContext)SpawnContext.create((ServerLevelAccessor)level, (BlockPos)this.blockPosition()), VariantsRegistry.WITHER_HORSE_VARIANT_REGISTRY_KEY).ifPresent(this::setVariant);
        if (spawnReason == EntitySpawnReason.NATURAL && (zombieEntity = (WitherSkeleton)EntityType.WITHER_SKELETON.create(this.level(), EntitySpawnReason.JOCKEY)) != null) {
            zombieEntity.snapTo(this.getX(), this.getY(), this.getZ(), this.getYRot(), 0.0f);
            zombieEntity.finalizeSpawn(level, difficulty, spawnReason, (SpawnGroupData)null);
            zombieEntity.setItemSlot(EquipmentSlot.MAINHAND, this.level().getRandom().nextFloat() < 0.2f ? new ItemStack((ItemLike)Items.BOW) : new ItemStack((ItemLike)Items.STONE_SPEAR));
            zombieEntity.startRiding((Entity)this, false, false);
            this.setTamed(true);
            this.setAge(0);
        }
        return spawnGroupData;
    }

    public WitherHorseEntity(EntityType<? extends WitherHorseEntity> p_30894_, Level p_30895_) {
        super(p_30894_, p_30895_);
        this.setPathfindingMalus(PathType.LAVA, 0.0f);
    }

    public boolean canBeAffected(MobEffectInstance potionEffect) {
        return potionEffect.is(MobEffects.WITHER) ? false : super.canBeAffected(potionEffect);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return WitherHorseEntity.createBaseHorseAttributes().add(Attributes.MAX_HEALTH, 15.0).add(Attributes.MOVEMENT_SPEED, 0.14000000298023224);
    }

    public float chargeSpeedModifier() {
        return 1.4f;
    }

    public boolean isMobControlled() {
        return this.getFirstPassenger() instanceof Mob;
    }

    public boolean removeWhenFarAway(double p_479978_) {
        return true;
    }

    public static boolean checkSpawnRules(EntityType<WitherHorseEntity> entityType, LevelAccessor level, EntitySpawnReason spawnReason, BlockPos pos, RandomSource random) {
        return !level.getBlockState(pos.below()).is(Blocks.NETHER_WART_BLOCK);
    }

    public void travel(Vec3 travelVector) {
        boolean flag = this.getDeltaMovement().y <= 0.0;
        double d0 = this.getY();
        double d1 = this.getEffectiveGravity();
        if (this.isInLava()) {
            this.travelInLava(travelVector, d1, flag, d0);
        }
        super.travel(travelVector);
    }

    private void travelInLava(Vec3 p_460972_, double p_460870_, boolean p_461232_, double p_460989_) {
        this.moveRelative(0.2f, p_460972_);
        this.move(MoverType.SELF, this.getDeltaMovement());
        if (this.getFluidHeight(FluidTags.LAVA) <= this.getFluidJumpThreshold()) {
            this.setDeltaMovement(this.getDeltaMovement().multiply(0.5, (double)0.8f, 0.5));
            Vec3 vec3 = this.getFluidFallingAdjustedMovement(p_460870_, p_461232_, this.getDeltaMovement());
            this.setDeltaMovement(vec3);
        } else {
            this.setDeltaMovement(this.getDeltaMovement().scale(0.5));
        }
        if (p_460870_ != 0.0) {
            this.setDeltaMovement(this.getDeltaMovement().add(0.0, -p_460870_ / 4.0, 0.0));
        }
        this.jumpOutOfFluid(p_460989_);
    }

    private void jumpOutOfFluid(double p_461180_) {
        Vec3 vec3 = this.getDeltaMovement();
        if (this.horizontalCollision && this.isFree(vec3.x, vec3.y + (double)0.6f - this.getY() + p_461180_, vec3.z)) {
            this.setDeltaMovement(vec3.x, 0.3f, vec3.z);
        }
    }

    protected void randomizeAttributes(RandomSource p_218821_) {
        AttributeInstance var10000 = this.getAttribute(Attributes.JUMP_STRENGTH);
        Objects.requireNonNull(p_218821_);
        var10000.setBaseValue(WitherHorseEntity.generateJumpStrength(() -> ((RandomSource)p_218821_).nextDouble()));
    }

    protected void addBehaviourGoals() {
    }

    protected SoundEvent getAmbientSound() {
        return this.isEyeInFluid(FluidTags.WATER) ? SoundRegistry.WITHER_HORSE_AMBIENT_WATER.get() : SoundRegistry.WITHER_HORSE_AMBIENT.get();
    }

    public float getVoicePitch() {
        return 5.0f;
    }

    protected SoundEvent getDeathSound() {
        return SoundRegistry.WITHER_HORSE_DEATH.get();
    }

    protected SoundEvent getHurtSound(DamageSource damageSource) {
        return SoundRegistry.WITHER_HORSE_HURT.get();
    }

    protected SoundEvent getSwimSound() {
        if (this.onGround()) {
            if (!this.isVehicle()) {
                return SoundRegistry.WITHER_HORSE_STEP_WATER.get();
            }
            ++this.gallopSoundCounter;
            if (this.gallopSoundCounter > 5 && this.gallopSoundCounter % 3 == 0) {
                return SoundRegistry.WITHER_HORSE_GALLOP_WATER.get();
            }
            if (this.gallopSoundCounter <= 5) {
                return SoundRegistry.WITHER_HORSE_STEP_WATER.get();
            }
        }
        return SoundRegistry.WITHER_HORSE_SWIM.get();
    }

    public void tick() {
        super.tick();
        if (!this.level().isClientSide()) {
            this.applyEffects(this.level());
        }
    }

    private void applyEffects(Level p_455072_) {
        Entity var3 = this.getFirstPassenger();
        if (var3 instanceof Player) {
            boolean flag1;
            Player player = (Player)var3;
            boolean flag = player.hasEffect(MobEffectRegistry.WITHERED_BONES.getDelegate());
            boolean bl = flag1 = p_455072_.getGameTime() % 40L == 0L;
            if (!flag || flag1) {
                player.addEffect(new MobEffectInstance(MobEffectRegistry.WITHERED_BONES.getDelegate(), 60, 0, true, true, true));
            }
        }
    }

    protected void playSwimSound(float volume) {
        if (this.onGround()) {
            super.playSwimSound(0.3f);
        } else {
            super.playSwimSound(Math.min(0.1f, volume * 25.0f));
        }
    }

    protected void playJumpSound() {
        if (this.isInWater()) {
            this.playSound(SoundRegistry.WITHER_HORSE_JUMP_WATER.get(), 0.4f, 1.0f);
        } else {
            super.playJumpSound();
        }
    }

    public EntityDimensions getDefaultDimensions(Pose p_316222_) {
        return this.isBaby() ? BABY_DIMENSIONS : super.getDefaultDimensions(p_316222_);
    }

    public InteractionResult mobInteract(Player p_479528_, InteractionHand p_479285_) {
        return !this.isTamed() ? InteractionResult.PASS : super.mobInteract(p_479528_, p_479285_);
    }

    public boolean canUseSlot(EquipmentSlot p_480066_) {
        return true;
    }

    @Nullable
    public AgeableMob getBreedOffspring(ServerLevel p_149553_, AgeableMob p_149554_) {
        return (AgeableMob)EntityRegistry.WITHER_SKELETON_HORSE.get().create((Level)p_149553_, EntitySpawnReason.BREEDING);
    }

    static {
        DATA_VARIANT_ID = SynchedEntityData.defineId(WitherHorseEntity.class, VariantsRegistry.WITHER_HORSE_VARIANT.get());
        BABY_DIMENSIONS = EntityRegistry.WITHER_SKELETON_HORSE.get().getDimensions().withAttachments(EntityAttachments.builder().attach(EntityAttachment.PASSENGER, 0.0f, EntityRegistry.WITHER_SKELETON_HORSE.get().getHeight() - 0.03125f, 0.0f)).scale(0.5f);
    }
}

