/*
 * Decompiled with CFR 0.152.
 */
package com.belgie.mounts_of_mayhem_plus.common.entity.zombieLlama;

import com.belgie.mounts_of_mayhem_plus.common.entity.spider.SpiderMountEntity;
import com.belgie.mounts_of_mayhem_plus.common.variants.ZombieLlamaVariant;
import com.belgie.mounts_of_mayhem_plus.core.EntityRegistry;
import com.belgie.mounts_of_mayhem_plus.core.SoundRegistry;
import com.belgie.mounts_of_mayhem_plus.core.VariantsRegistry;
import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.component.DataComponentGetter;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.Identifier;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.BiomeTags;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.ItemTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityAttachments;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.TemptGoal;
import net.minecraft.world.entity.animal.equine.AbstractHorse;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.monster.zombie.ZombieVillager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.LlamaSpit;
import net.minecraft.world.entity.variant.SpawnContext;
import net.minecraft.world.entity.variant.VariantUtils;
import net.minecraft.world.item.EitherHolder;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import net.minecraft.world.phys.Vec2;
import net.minecraft.world.phys.Vec3;

public class ZombieLlamaEntity
extends AbstractHorse {
    boolean didSpit;
    private int dashCooldown = 0;
    public static final EntityDataAccessor<Boolean> DASH = SynchedEntityData.defineId(ZombieLlamaEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final EntityDataAccessor<Holder<ZombieLlamaVariant>> DATA_VARIANT_ID = SynchedEntityData.defineId(ZombieLlamaEntity.class, VariantsRegistry.ZOMBIE_LLAMA_VARIANT.get());

    public Holder<ZombieLlamaVariant> getVariant() {
        return (Holder)this.entityData.get(DATA_VARIANT_ID);
    }

    private void setVariant(Holder<ZombieLlamaVariant> variant) {
        this.entityData.set(DATA_VARIANT_ID, variant);
    }

    @Nullable
    public <T> T get(DataComponentType<? extends T> component) {
        return (T)(component == VariantsRegistry.ZOMBIE_LLAMA_VARIANT_COM.get() ? ZombieLlamaEntity.castComponentValue(component, (Object)new EitherHolder(this.getVariant())) : super.get(component));
    }

    protected void applyImplicitComponents(DataComponentGetter componentGetter) {
        this.applyImplicitComponentIfPresent(componentGetter, VariantsRegistry.ZOMBIE_LLAMA_VARIANT_COM.get());
        super.applyImplicitComponents(componentGetter);
    }

    protected <T> boolean applyImplicitComponent(DataComponentType<T> component, T value) {
        if (component == VariantsRegistry.ZOMBIE_LLAMA_VARIANT_COM.get()) {
            this.setVariant((Holder<ZombieLlamaVariant>)((Holder)ZombieLlamaEntity.castComponentValue(VariantsRegistry.ZOMBIE_LLAMA_VARIANT_COM.get(), value)));
            return true;
        }
        return super.applyImplicitComponent(component, value);
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(DASH, (Object)false);
        builder.define(DATA_VARIANT_ID, (Object)VariantUtils.getDefaultOrAny((RegistryAccess)this.registryAccess(), (ResourceKey)ResourceKey.create(VariantsRegistry.ZOMBIE_LLAMA_VARIANT_REGISTRY_KEY, (Identifier)Identifier.fromNamespaceAndPath((String)"mounts_of_mayhem_plus", (String)"default"))));
    }

    protected void addAdditionalSaveData(ValueOutput output) {
        super.addAdditionalSaveData(output);
        VariantUtils.writeVariant((ValueOutput)output, this.getVariant());
    }

    protected void readAdditionalSaveData(ValueInput input) {
        super.readAdditionalSaveData(input);
        VariantUtils.readVariant((ValueInput)input, VariantsRegistry.ZOMBIE_LLAMA_VARIANT_REGISTRY_KEY).ifPresent(this::setVariant);
    }

    @Nullable
    public SpawnGroupData finalizeSpawn(ServerLevelAccessor level, DifficultyInstance difficulty, EntitySpawnReason spawnReason, @Nullable SpawnGroupData spawnGroupData) {
        ZombieVillager mob;
        spawnGroupData = super.finalizeSpawn(level, difficulty, spawnReason, spawnGroupData);
        VariantUtils.selectVariantToSpawn((SpawnContext)SpawnContext.create((ServerLevelAccessor)level, (BlockPos)this.blockPosition()), VariantsRegistry.ZOMBIE_LLAMA_VARIANT_REGISTRY_KEY).ifPresent(this::setVariant);
        if (spawnReason == EntitySpawnReason.NATURAL && (mob = (ZombieVillager)EntityType.ZOMBIE_VILLAGER.create(this.level(), EntitySpawnReason.JOCKEY)) != null) {
            mob.snapTo(this.getX(), this.getY(), this.getZ(), this.getYRot(), 0.0f);
            mob.finalizeSpawn(level, difficulty, spawnReason, (SpawnGroupData)null);
            mob.setBaby(false);
            mob.setItemSlot(EquipmentSlot.MAINHAND, new ItemStack((ItemLike)Items.IRON_SPEAR));
            mob.startRiding((Entity)this, false, false);
            this.setTamed(true);
            this.setAge(0);
        }
        return spawnGroupData;
    }

    public ZombieLlamaEntity(EntityType<? extends ZombieLlamaEntity> p_30894_, Level p_30895_) {
        super(p_30894_, p_30895_);
        this.getNavigation().setRequiredPathLength(40.0f);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return ZombieLlamaEntity.createBaseHorseAttributes().add(Attributes.MAX_HEALTH, 20.0).add(Attributes.MOVEMENT_SPEED, 0.13);
    }

    protected boolean canPerformRearing() {
        return false;
    }

    public Vec3 getLeashOffset() {
        return new Vec3(0.0, 0.75 * (double)this.getEyeHeight(), (double)this.getBbWidth() * 0.5);
    }

    protected double followLeashSpeed() {
        return 2.0;
    }

    public boolean supportQuadLeash() {
        return false;
    }

    protected void playGallopSound(SoundType p_480127_) {
        this.playSound(SoundRegistry.ZOMBIE_LLAMA_STEP.get(), p_480127_.getVolume() * 0.15f, p_480127_.getPitch());
    }

    public void tick() {
        super.tick();
        if (this.isDashing() && this.dashCooldown < 50 && (this.onGround() || this.isInLiquid() || this.isPassenger())) {
            this.setDashing(false);
            this.setSprinting(false);
        }
        if (this.dashCooldown > 0) {
            --this.dashCooldown;
            if (this.dashCooldown == 0) {
                this.level().playSound((Entity)null, this.blockPosition(), SoundRegistry.ZOMBIE_LLAMA_EAT.get(), SoundSource.NEUTRAL, 1.0f, 1.0f);
            }
        }
    }

    public boolean isDashing() {
        return (Boolean)this.entityData.get(DASH);
    }

    public void setDashing(boolean dashing) {
        this.entityData.set(DASH, (Object)dashing);
    }

    public void handleStartJump(int p_249968_) {
        this.gameEvent((Holder)GameEvent.ENTITY_ACTION);
        this.spit(this.level(), this);
    }

    public void handleStopJump() {
    }

    public int getJumpCooldown() {
        return this.dashCooldown;
    }

    public boolean canJump() {
        return this.dashCooldown == 0;
    }

    public void onPlayerJump(int p_249138_) {
        if (this.isSaddled() && this.dashCooldown <= 0 && this.onGround()) {
            super.onPlayerJump(p_249138_);
        }
    }

    protected void executeRidersJump(float p_251967_, Vec3 p_275627_) {
    }

    private void spit(Level level, ZombieLlamaEntity babyGhastEntity) {
        Vec3 look = babyGhastEntity.getLookAngle();
        double x = babyGhastEntity.getX() + look.x;
        double y = babyGhastEntity.getEyeY() - 0.5;
        double z = babyGhastEntity.getZ() + look.z;
        LlamaSpit fireball = new LlamaSpit(EntityType.LLAMA_SPIT, level);
        fireball.setPos(x, y, z);
        fireball.setOwner((Entity)babyGhastEntity);
        fireball.shoot(look.x, look.y, look.z, 1.3f, 0.0f);
        level.addFreshEntity((Entity)fireball);
        if (!this.isSilent()) {
            this.level().playSound((Entity)null, this.getX(), this.getY(), this.getZ(), SoundRegistry.ZOMBIE_LLAMA_SPIT.get(), this.getSoundSource(), 1.0f, 1.0f + (this.random.nextFloat() - this.random.nextFloat()) * 0.2f);
        }
        this.didSpit = true;
    }

    public static boolean checkPolarBearSpawnRules(EntityType<SpiderMountEntity> entityType, ServerLevelAccessor level, EntitySpawnReason spawnReason, BlockPos pos, RandomSource random) {
        Holder holder = level.getBiome(pos);
        return !holder.is(BiomeTags.POLAR_BEARS_SPAWN_ON_ALTERNATE_BLOCKS) ? ZombieLlamaEntity.checkMobSpawnRules(entityType, (LevelAccessor)level, (EntitySpawnReason)spawnReason, (BlockPos)pos, (RandomSource)random) : Monster.isDarkEnoughToSpawn((ServerLevelAccessor)level, (BlockPos)pos, (RandomSource)random) && level.getBlockState(pos.below()).is(BlockTags.POLAR_BEARS_SPAWNABLE_ON_ALTERNATE);
    }

    protected void hurtArmor(DamageSource p_379528_, float p_379933_) {
        this.doHurtEquipment(p_379528_, p_379933_, new EquipmentSlot[]{EquipmentSlot.BODY});
    }

    protected void randomizeAttributes(RandomSource p_218821_) {
        AttributeInstance var10000 = this.getAttribute(Attributes.JUMP_STRENGTH);
        Objects.requireNonNull(p_218821_);
        var10000.setBaseValue(ZombieLlamaEntity.generateJumpStrength(() -> ((RandomSource)p_218821_).nextDouble()));
    }

    protected void addBehaviourGoals() {
        this.goalSelector.addGoal(0, (Goal)new FloatGoal((Mob)this));
        this.goalSelector.addGoal(3, (Goal)new TemptGoal((PathfinderMob)this, 1.25, p_478127_ -> p_478127_.is(ItemTags.ZOMBIE_HORSE_FOOD), false));
    }

    protected EquipmentSlot sunProtectionSlot() {
        return EquipmentSlot.BODY;
    }

    protected Vec3 getPassengerAttachmentPoint(Entity p_481980_, EntityDimensions p_478389_, float p_478974_) {
        return ZombieLlamaEntity.getDefaultPassengerAttachmentPoint((Entity)this, (Entity)p_481980_, (EntityAttachments)p_478389_.attachments());
    }

    public InteractionResult mobInteract(Player p_478329_, InteractionHand p_479271_) {
        boolean flag;
        boolean bl = flag = !this.isBaby() && this.isTamed() && p_478329_.isSecondaryUseActive();
        if (!this.isVehicle() && !flag) {
            ItemStack itemstack = p_478329_.getItemInHand(p_479271_);
            if (!itemstack.isEmpty()) {
                if (this.isFood(itemstack)) {
                    return this.fedFood(p_478329_, itemstack);
                }
                if (!this.isTamed()) {
                    this.makeMad();
                    return InteractionResult.SUCCESS;
                }
            }
            return super.mobInteract(p_478329_, p_479271_);
        }
        return super.mobInteract(p_478329_, p_479271_);
    }

    public float chargeSpeedModifier() {
        return 1.4f;
    }

    public boolean canUseSlot(EquipmentSlot p_481976_) {
        return true;
    }

    public boolean canBeLeashed() {
        return this.isTamed() || !this.isMobControlled();
    }

    public boolean isFood(ItemStack p_480617_) {
        return p_480617_.is(ItemTags.ZOMBIE_HORSE_FOOD);
    }

    protected SoundEvent getAmbientSound() {
        return SoundRegistry.ZOMBIE_LLAMA_AMBIENT.get();
    }

    protected SoundEvent getDeathSound() {
        return SoundRegistry.ZOMBIE_LLAMA_DEATH.get();
    }

    protected SoundEvent getHurtSound(DamageSource damageSource) {
        return SoundRegistry.ZOMBIE_LLAMA_HURT.get();
    }

    protected SoundEvent getSwimSound() {
        return SoundEvents.GENERIC_SWIM;
    }

    protected Vec2 getRiddenRotation(LivingEntity entity) {
        return new Vec2(entity.getXRot() * 0.5f, entity.getYRot());
    }

    public boolean canFallInLove() {
        return false;
    }

    public boolean removeWhenFarAway(double p_479978_) {
        return true;
    }

    public boolean isMobControlled() {
        return this.getFirstPassenger() instanceof Mob;
    }

    public float getVoicePitch() {
        return -1.0f;
    }

    protected void playSwimSound(float volume) {
        if (this.onGround()) {
            super.playSwimSound(0.3f);
        } else {
            super.playSwimSound(Math.min(0.1f, volume * 25.0f));
        }
    }

    protected float getWaterSlowDown() {
        return 0.0f;
    }

    protected void playJumpSound() {
        super.playJumpSound();
    }

    @Nullable
    public AgeableMob getBreedOffspring(ServerLevel p_149553_, AgeableMob p_149554_) {
        return (AgeableMob)EntityRegistry.ZOMBIE_LLAMA.get().create((Level)p_149553_, EntitySpawnReason.BREEDING);
    }
}

