/*
 * Decompiled with CFR 0.152.
 */
package com.belgie.mounts_of_mayhem_plus.common.entity.zombieLlama;

import com.belgie.mounts_of_mayhem_plus.common.entity.zombieLlama.ZombieLlamaDecorLayer;
import com.belgie.mounts_of_mayhem_plus.common.entity.zombieLlama.ZombieLlamaEntity;
import com.belgie.mounts_of_mayhem_plus.common.entity.zombieLlama.ZombieLlamaRenderState;
import com.belgie.mounts_of_mayhem_plus.core.ClientEntityRegistry;
import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.Model;
import net.minecraft.client.model.animal.llama.LlamaModel;
import net.minecraft.client.model.geom.EntityModelSet;
import net.minecraft.client.model.geom.ModelLayers;
import net.minecraft.client.renderer.SubmitNodeCollector;
import net.minecraft.client.renderer.entity.AgeableMobRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.renderer.entity.state.LivingEntityRenderState;
import net.minecraft.resources.Identifier;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;

public class ZombieLlamaRenderer
extends AgeableMobRenderer<ZombieLlamaEntity, ZombieLlamaRenderState, LlamaModel> {
    private static final Identifier GRAY = Identifier.fromNamespaceAndPath((String)"mounts_of_mayhem_plus", (String)"textures/entity/zombie_llama.png");

    public ZombieLlamaRenderer(EntityRendererProvider.Context context) {
        super(context, (EntityModel)new LlamaModel(context.bakeLayer(ModelLayers.LLAMA)), (EntityModel)new LlamaModel(context.bakeLayer(ModelLayers.LLAMA_BABY)), 0.7f);
        this.addLayer(new ZombieLlamaDecorLayer((RenderLayerParent<ZombieLlamaRenderState, LlamaModel>)this, context.getModelSet(), context.getEquipmentRenderer()));
        this.addLayer(new SaddleLayer((RenderLayerParent<ZombieLlamaRenderState, LlamaModel>)this, context.getModelSet()));
    }

    public Identifier getTextureLocation(ZombieLlamaRenderState p_469910_) {
        return GRAY;
    }

    public ZombieLlamaRenderState createRenderState() {
        return new ZombieLlamaRenderState();
    }

    public void extractRenderState(ZombieLlamaEntity p_480995_, ZombieLlamaRenderState p_363082_, float p_361575_) {
        super.extractRenderState((LivingEntity)p_480995_, (LivingEntityRenderState)p_363082_, p_361575_);
        p_363082_.bodyItem = p_480995_.getBodyArmorItem();
        p_363082_.saddleItem = p_480995_.getItemBySlot(EquipmentSlot.SADDLE);
    }

    private static class SaddleLayer
    extends RenderLayer<ZombieLlamaRenderState, LlamaModel> {
        private static final Identifier CAT_COLLAR_LOCATION = Identifier.fromNamespaceAndPath((String)"mounts_of_mayhem_plus", (String)"textures/entity/equipment/zombie_llama_saddle/saddle.png");
        private final LlamaModel adultModel;
        private final LlamaModel babyModel;

        public SaddleLayer(RenderLayerParent<ZombieLlamaRenderState, LlamaModel> renderer, EntityModelSet modelSet) {
            super(renderer);
            this.adultModel = new LlamaModel(modelSet.bakeLayer(ClientEntityRegistry.ZOMBIE_LLAMA_SADDLE));
            this.babyModel = new LlamaModel(modelSet.bakeLayer(ClientEntityRegistry.ZOMBIE_LLAMA_BABY_SADDLE));
        }

        public void submit(PoseStack p_434729_, SubmitNodeCollector p_435679_, int p_435603_, ZombieLlamaRenderState p_435848_, float p_435437_, float p_432910_) {
            ItemStack stack = p_435848_.saddleItem;
            if (!stack.isEmpty()) {
                LlamaModel catmodel = p_435848_.isBaby ? this.babyModel : this.adultModel;
                SaddleLayer.coloredCutoutModelCopyLayerRender((Model)catmodel, (Identifier)CAT_COLLAR_LOCATION, (PoseStack)p_434729_, (SubmitNodeCollector)p_435679_, (int)p_435603_, (LivingEntityRenderState)p_435848_, (int)-1, (int)1);
            }
        }
    }
}

