/*
 * Decompiled with CFR 0.152.
 */
package com.belgie.mounts_of_mayhem_plus.common.entity.zombieWarboar;

import com.belgie.mounts_of_mayhem_plus.common.variants.ZombieWarboarVariant;
import com.belgie.mounts_of_mayhem_plus.core.EntityRegistry;
import com.belgie.mounts_of_mayhem_plus.core.SoundRegistry;
import com.belgie.mounts_of_mayhem_plus.core.VariantsRegistry;
import java.util.Objects;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.Holder;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.component.DataComponentGetter;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.Identifier;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.ItemTags;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityAttachment;
import net.minecraft.world.entity.EntityAttachments;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.Leashable;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.TemptGoal;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.equine.AbstractHorse;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.variant.VariantUtils;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.pathfinder.PathType;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import net.minecraft.world.phys.Vec3;
import org.jspecify.annotations.Nullable;

public class ZombieWarBoarEntity
extends AbstractHorse {
    private static final EntityDataAccessor<Byte> DATA_WOOL_ID = SynchedEntityData.defineId(ZombieWarBoarEntity.class, (EntityDataSerializer)EntityDataSerializers.BYTE);
    private static final EntityDataAccessor<Float> STAMINA = SynchedEntityData.defineId(ZombieWarBoarEntity.class, (EntityDataSerializer)EntityDataSerializers.FLOAT);
    private static final EntityDimensions BABY_DIMENSIONS;
    private static final float MAX_STAMINA = 100.0f;
    private static final EntityDataAccessor<Holder<ZombieWarboarVariant>> DATA_VARIANT_ID;

    public Holder<ZombieWarboarVariant> getVariant() {
        return (Holder)this.entityData.get(DATA_VARIANT_ID);
    }

    private void setVariant(Holder<ZombieWarboarVariant> variant) {
        this.entityData.set(DATA_VARIANT_ID, variant);
    }

    public <T> @Nullable T get(DataComponentType<? extends T> p_481681_) {
        if (p_481681_ == VariantsRegistry.ZOMBIE_WARBOAR_VARIANT_COM.get()) {
            return (T)ZombieWarBoarEntity.castComponentValue(p_481681_, this.getVariant());
        }
        return (T)(p_481681_ == DataComponents.SHEEP_COLOR ? ZombieWarBoarEntity.castComponentValue(p_481681_, (Object)this.getColor()) : super.get(p_481681_));
    }

    protected void applyImplicitComponents(DataComponentGetter componentGetter) {
        this.applyImplicitComponentIfPresent(componentGetter, VariantsRegistry.ZOMBIE_WARBOAR_VARIANT_COM.get());
        this.applyImplicitComponentIfPresent(componentGetter, DataComponents.SHEEP_COLOR);
        super.applyImplicitComponents(componentGetter);
    }

    protected <T> boolean applyImplicitComponent(DataComponentType<T> component, T value) {
        if (component == VariantsRegistry.ZOMBIE_WARBOAR_VARIANT_COM.get()) {
            this.setVariant((Holder<ZombieWarboarVariant>)((Holder)ZombieWarBoarEntity.castComponentValue(VariantsRegistry.ZOMBIE_WARBOAR_VARIANT_COM.get(), value)));
            return true;
        }
        if (component == DataComponents.SHEEP_COLOR) {
            this.setColor((DyeColor)ZombieWarBoarEntity.castComponentValue((DataComponentType)DataComponents.SHEEP_COLOR, value));
            return true;
        }
        return super.applyImplicitComponent(component, value);
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(DATA_VARIANT_ID, (Object)VariantUtils.getDefaultOrAny((RegistryAccess)this.registryAccess(), (ResourceKey)ResourceKey.create(VariantsRegistry.ZOMBIE_WARBOAR_VARIANT_REGISTRY_KEY, (Identifier)Identifier.fromNamespaceAndPath((String)"mounts_of_mayhem_plus", (String)"default"))));
        builder.define(STAMINA, (Object)Float.valueOf(100.0f));
        builder.define(DATA_WOOL_ID, (Object)0);
    }

    protected void addAdditionalSaveData(ValueOutput output) {
        super.addAdditionalSaveData(output);
        VariantUtils.writeVariant((ValueOutput)output, this.getVariant());
        output.store("Color", DyeColor.LEGACY_ID_CODEC, (Object)this.getColor());
    }

    protected void readAdditionalSaveData(ValueInput input) {
        super.readAdditionalSaveData(input);
        VariantUtils.readVariant((ValueInput)input, VariantsRegistry.ZOMBIE_WARBOAR_VARIANT_REGISTRY_KEY).ifPresent(this::setVariant);
        this.setColor(input.read("Color", DyeColor.LEGACY_ID_CODEC).orElse(DyeColor.RED));
    }

    public ZombieWarBoarEntity(EntityType<? extends ZombieWarBoarEntity> p_30894_, Level p_30895_) {
        super(p_30894_, p_30895_);
        this.setPathfindingMalus(PathType.DANGER_OTHER, -1.0f);
        this.setPathfindingMalus(PathType.DAMAGE_OTHER, -1.0f);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return ZombieWarBoarEntity.createBaseHorseAttributes().add(Attributes.MAX_HEALTH, 25.0);
    }

    public InteractionResult interact(Player p_478395_, InteractionHand p_479428_) {
        this.setPersistenceRequired();
        return super.interact(p_478395_, p_479428_);
    }

    public boolean removeWhenFarAway(double p_479978_) {
        return true;
    }

    public boolean isMobControlled() {
        return this.getFirstPassenger() instanceof Mob;
    }

    public boolean canFallInLove() {
        return false;
    }

    protected void addBehaviourGoals() {
        this.goalSelector.addGoal(0, (Goal)new FloatGoal((Mob)this));
        this.goalSelector.addGoal(3, (Goal)new TemptGoal((PathfinderMob)this, 1.25, p_478127_ -> p_478127_.is(ItemTags.HOGLIN_FOOD), false));
    }

    public boolean canUseSlot(EquipmentSlot p_481976_) {
        return true;
    }

    public boolean canBeLeashed() {
        return this.isTamed() || !this.isMobControlled();
    }

    public boolean isFood(ItemStack p_480617_) {
        return p_480617_.is(ItemTags.HOGLIN_FOOD);
    }

    public Vec3[] getQuadLeashOffsets() {
        return Leashable.createQuadLeashOffsets((Entity)this, (double)-0.2, (double)0.41, (double)0.18, (double)0.9);
    }

    public EntityDimensions getDefaultDimensions(Pose p_479251_) {
        return this.isBaby() ? BABY_DIMENSIONS : super.getDefaultDimensions(p_479251_);
    }

    public float chargeSpeedModifier() {
        return 1.4f;
    }

    public float getVoicePitch() {
        return -1.0f;
    }

    protected void hurtArmor(DamageSource p_379528_, float p_379933_) {
        this.doHurtEquipment(p_379528_, p_379933_, new EquipmentSlot[]{EquipmentSlot.BODY});
    }

    public float getStamina() {
        return ((Float)this.entityData.get(STAMINA)).floatValue();
    }

    public void setStamina(float value) {
        this.entityData.set(STAMINA, (Object)Float.valueOf(Mth.clamp((float)value, (float)0.0f, (float)100.0f)));
    }

    public void aiStep() {
        super.aiStep();
        if (this.level().isClientSide()) {
            this.updateStaminaJumpBarClient();
        }
    }

    private void updateStaminaJumpBarClient() {
        if (!this.isVehicle()) {
            return;
        }
        LivingEntity rider = this.getControllingPassenger();
        if (!(rider instanceof LocalPlayer)) {
            return;
        }
        LocalPlayer player = (LocalPlayer)rider;
        player.jumpRidingScale = this.getStamina() / 100.0f;
    }

    public boolean canJump() {
        return true;
    }

    protected void playGallopSound(SoundType p_480127_) {
        this.playSound(SoundRegistry.ZOMBIE_WARBOAR_STEP.get(), p_480127_.getVolume() * 0.15f, p_480127_.getPitch());
    }

    public void tick() {
        LivingEntity rider;
        super.tick();
        if (!this.level().isClientSide() && this.isVehicle() && (rider = this.getControllingPassenger()) instanceof Player) {
            Player player = (Player)rider;
            float stamina = this.getStamina();
            if (player.isSprinting() && stamina > 0.0f) {
                this.setStamina(stamina - 0.5f);
            } else {
                this.setStamina(stamina + 0.25f);
            }
            if (stamina <= 0.0f) {
                player.setSprinting(false);
            }
        }
    }

    public InteractionResult mobInteract(Player p_249032_, InteractionHand p_251004_) {
        ItemStack itemstack = p_249032_.getItemInHand(p_251004_);
        InteractionResult interactionresult = itemstack.interactLivingEntity(p_249032_, (LivingEntity)this, p_251004_);
        if (interactionresult.consumesAction()) {
            return interactionresult;
        }
        if (this.isFood(itemstack)) {
            return this.fedFood(p_249032_, itemstack);
        }
        if (this.isEquippableInSlot(itemstack, EquipmentSlot.BODY) && !this.isWearingBodyArmor() && !this.isBaby()) {
            this.setBodyArmorItem(itemstack.copyWithCount(1));
            itemstack.consume(1, (LivingEntity)p_249032_);
            return InteractionResult.SUCCESS;
        }
        if (this.getPassengers().isEmpty() && !this.isBaby()) {
            this.doPlayerRide(p_249032_);
        }
        return InteractionResult.SUCCESS;
    }

    protected void randomizeAttributes(RandomSource p_218821_) {
        AttributeInstance var10000 = this.getAttribute(Attributes.JUMP_STRENGTH);
        Objects.requireNonNull(p_218821_);
        var10000.setBaseValue(ZombieWarBoarEntity.generateJumpStrength(() -> ((RandomSource)p_218821_).nextDouble()));
    }

    public DyeColor getColor() {
        return DyeColor.byId((int)((Byte)this.entityData.get(DATA_WOOL_ID) & 0xF));
    }

    public void setColor(DyeColor color) {
        byte b0 = (Byte)this.entityData.get(DATA_WOOL_ID);
        this.entityData.set(DATA_WOOL_ID, (Object)((byte)(b0 & 0xF0 | color.getId() & 0xF)));
    }

    protected SoundEvent getAmbientSound() {
        return SoundRegistry.ZOMBIE_WARBOAR_AMBIENT.get();
    }

    protected SoundEvent getDeathSound() {
        return SoundRegistry.ZOMBIE_WARBOAR_DEATH.get();
    }

    protected SoundEvent getHurtSound(DamageSource damageSource) {
        return SoundRegistry.ZOMBIE_WARBOAR_HURT.get();
    }

    protected SoundEvent getSwimSound() {
        return SoundEvents.GENERIC_SWIM;
    }

    protected void playSwimSound(float volume) {
        if (this.onGround()) {
            super.playSwimSound(0.3f);
        } else {
            super.playSwimSound(Math.min(0.1f, volume * 25.0f));
        }
    }

    protected float getRiddenSpeed(Player p_278241_) {
        float f = this.isSprinting() ? 0.5f : 0.0f;
        return (float)this.getAttributeValue(Attributes.MOVEMENT_SPEED) + f;
    }

    public boolean canSprint() {
        return true;
    }

    public void handleStopJump() {
    }

    protected void playJumpSound() {
        super.playJumpSound();
    }

    protected boolean canPerformRearing() {
        return false;
    }

    public boolean canMate(Animal p_251650_) {
        return false;
    }

    @javax.annotation.Nullable
    public AgeableMob getBreedOffspring(ServerLevel p_149553_, AgeableMob p_149554_) {
        return (AgeableMob)EntityRegistry.ZOMBIE_WARBOAR.get().create((Level)p_149553_, EntitySpawnReason.BREEDING);
    }

    static {
        DATA_VARIANT_ID = SynchedEntityData.defineId(ZombieWarBoarEntity.class, VariantsRegistry.ZOMBIE_WARBOAR_VARIANT.get());
        BABY_DIMENSIONS = EntityRegistry.ZOMBIE_WARBOAR.get().getDimensions().withAttachments(EntityAttachments.builder().attach(EntityAttachment.PASSENGER, 0.0f, EntityRegistry.ZOMBIE_WARBOAR.get().getHeight() - 0.03125f, 0.0f)).scale(0.5f);
    }
}

