/*
 * Decompiled with CFR 0.152.
 */
package com.belgie.mounts_of_mayhem_plus.common.entity.zombieWarboar;

import com.belgie.mounts_of_mayhem_plus.common.entity.warboar.WarBoarModel;
import com.belgie.mounts_of_mayhem_plus.common.entity.warboar.WarBoarRenderState;
import com.belgie.mounts_of_mayhem_plus.common.entity.zombieWarboar.ZombieWarBoarEntity;
import com.belgie.mounts_of_mayhem_plus.common.entity.zombieWarboar.ZombieWarBoarPaintLayer;
import com.belgie.mounts_of_mayhem_plus.core.ClientEntityRegistry;
import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.Model;
import net.minecraft.client.model.geom.EntityModelSet;
import net.minecraft.client.renderer.SubmitNodeCollector;
import net.minecraft.client.renderer.entity.AgeableMobRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.renderer.entity.layers.SimpleEquipmentLayer;
import net.minecraft.client.renderer.entity.state.LivingEntityRenderState;
import net.minecraft.client.resources.model.EquipmentClientInfo;
import net.minecraft.resources.Identifier;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;

public class ZombieWarBoarRenderer
extends AgeableMobRenderer<ZombieWarBoarEntity, WarBoarRenderState, WarBoarModel> {
    private static final Identifier HOGLIN_LOCATION = Identifier.fromNamespaceAndPath((String)"mounts_of_mayhem_plus", (String)"textures/entity/warboar/zombie_warboar.png");

    public ZombieWarBoarRenderer(EntityRendererProvider.Context p_174165_) {
        super(p_174165_, (EntityModel)new WarBoarModel(p_174165_.bakeLayer(ClientEntityRegistry.WARBOAR)), (EntityModel)new WarBoarModel(p_174165_.bakeLayer(ClientEntityRegistry.WARBOAR_BABY)), 0.7f);
        this.addLayer(new SaddleLayer((RenderLayerParent<WarBoarRenderState, WarBoarModel>)this, p_174165_.getModelSet()));
        this.addLayer((RenderLayer)new SimpleEquipmentLayer((RenderLayerParent)this, p_174165_.getEquipmentRenderer(), EquipmentClientInfo.LayerType.WOLF_BODY, p_397943_ -> p_397943_.bodyArmorItem, (EntityModel)new WarBoarModel(p_174165_.bakeLayer(ClientEntityRegistry.WARBOAR_SADDLE)), (EntityModel)new WarBoarModel(p_174165_.bakeLayer(ClientEntityRegistry.WARBOAR_BABY_SADDLE)), 2));
        this.addLayer(new ZombieWarBoarPaintLayer((RenderLayerParent<WarBoarRenderState, WarBoarModel>)this, p_174165_.getModelSet()));
    }

    public Identifier getTextureLocation(WarBoarRenderState p_364914_) {
        return HOGLIN_LOCATION;
    }

    public WarBoarRenderState createRenderState() {
        return new WarBoarRenderState();
    }

    public void extractRenderState(ZombieWarBoarEntity p_361728_, WarBoarRenderState p_360522_, float p_363399_) {
        super.extractRenderState((LivingEntity)p_361728_, (LivingEntityRenderState)p_360522_, p_363399_);
        p_360522_.bodyArmorItem = p_361728_.getBodyArmorItem();
        p_360522_.saddle = p_361728_.getItemBySlot(EquipmentSlot.SADDLE).copy();
        p_360522_.woolColor = p_361728_.getColor();
        p_360522_.isJebSheep = ZombieWarBoarRenderer.checkMagicName((Entity)p_361728_, (String)"jeb_");
    }

    private static class SaddleLayer
    extends RenderLayer<WarBoarRenderState, WarBoarModel> {
        private static final Identifier CAT_COLLAR_LOCATION = Identifier.fromNamespaceAndPath((String)"mounts_of_mayhem_plus", (String)"textures/entity/equipment/warboar_saddle/warboar_saddle.png");
        private final WarBoarModel adultModel;
        private final WarBoarModel babyModel;

        public SaddleLayer(RenderLayerParent<WarBoarRenderState, WarBoarModel> renderer, EntityModelSet modelSet) {
            super(renderer);
            this.adultModel = new WarBoarModel(modelSet.bakeLayer(ClientEntityRegistry.WARBOAR_SADDLE));
            this.babyModel = new WarBoarModel(modelSet.bakeLayer(ClientEntityRegistry.WARBOAR_BABY_SADDLE));
        }

        public void submit(PoseStack p_434729_, SubmitNodeCollector p_435679_, int p_435603_, WarBoarRenderState p_435848_, float p_435437_, float p_432910_) {
            ItemStack stack = p_435848_.saddle;
            if (!stack.isEmpty()) {
                WarBoarModel catmodel = p_435848_.isBaby ? this.babyModel : this.adultModel;
                SaddleLayer.coloredCutoutModelCopyLayerRender((Model)catmodel, (Identifier)CAT_COLLAR_LOCATION, (PoseStack)p_434729_, (SubmitNodeCollector)p_435679_, (int)p_435603_, (LivingEntityRenderState)p_435848_, (int)-1, (int)1);
            }
        }
    }
}

