/*
 * Decompiled with CFR 0.152.
 */
package com.belgie.mounts_of_mayhem_plus.common.world;

import com.belgie.mounts_of_mayhem_plus.common.entity.babyRavager.BabyRavagerEntity;
import com.belgie.mounts_of_mayhem_plus.core.EntityRegistry;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Difficulty;
import net.minecraft.world.attribute.EnvironmentAttributes;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.CustomSpawner;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.NaturalSpawner;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gamerules.GameRules;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.material.FluidState;

public class BrutuskSpawner
implements CustomSpawner {
    private int nextTick;

    public void tick(ServerLevel p_64570_, boolean p_64571_) {
        if (p_64571_ && ((Boolean)p_64570_.getGameRules().get(GameRules.SPAWN_MOBS)).booleanValue()) {
            RandomSource randomsource = p_64570_.random;
            --this.nextTick;
            if (this.nextTick <= 0) {
                Player player;
                int i;
                this.nextTick = this.nextTick + 12000 + randomsource.nextInt(1200);
                if (p_64570_.isBrightOutside() && randomsource.nextInt(5) == 0 && (i = p_64570_.players().size()) >= 1 && !(player = (Player)p_64570_.players().get(randomsource.nextInt(i))).isSpectator() && !p_64570_.isCloseToVillage(player.blockPosition(), 2) && player.hasEffect(MobEffects.BAD_OMEN)) {
                    int j = (24 + randomsource.nextInt(24)) * (randomsource.nextBoolean() ? -1 : 1);
                    int k = (24 + randomsource.nextInt(24)) * (randomsource.nextBoolean() ? -1 : 1);
                    BlockPos.MutableBlockPos blockpos$mutableblockpos = player.blockPosition().mutable().move(j, 0, k);
                    boolean l = true;
                    if (p_64570_.hasChunksAt(blockpos$mutableblockpos.getX() - 10, blockpos$mutableblockpos.getZ() - 10, blockpos$mutableblockpos.getX() + 10, blockpos$mutableblockpos.getZ() + 10) && ((Boolean)p_64570_.environmentAttributes().getValue(EnvironmentAttributes.CAN_PILLAGER_PATROL_SPAWN, (BlockPos)blockpos$mutableblockpos)).booleanValue()) {
                        blockpos$mutableblockpos.setY(p_64570_.getHeightmapPos(Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, (BlockPos)blockpos$mutableblockpos).getY());
                        this.spawnPatrolMember(p_64570_, (BlockPos)blockpos$mutableblockpos, randomsource);
                        blockpos$mutableblockpos.setX(blockpos$mutableblockpos.getX() + randomsource.nextInt(5) - randomsource.nextInt(5));
                        blockpos$mutableblockpos.setZ(blockpos$mutableblockpos.getZ() + randomsource.nextInt(5) - randomsource.nextInt(5));
                    }
                }
            }
        }
    }

    private boolean spawnPatrolMember(ServerLevel level, BlockPos pos, RandomSource random) {
        BlockState blockstate = level.getBlockState(pos);
        if (!NaturalSpawner.isValidEmptySpawnBlock((BlockGetter)level, (BlockPos)pos, (BlockState)blockstate, (FluidState)blockstate.getFluidState(), EntityRegistry.BRUTUSK.get())) {
            return false;
        }
        if (!BrutuskSpawner.mountsOfMayhemPlus$checkPatrollingMonsterSpawnRules(EntityRegistry.BRUTUSK.get(), (LevelAccessor)level, EntitySpawnReason.PATROL, pos, random)) {
            return false;
        }
        BabyRavagerEntity patrollingmonster = (BabyRavagerEntity)EntityRegistry.BRUTUSK.get().create((Level)level, EntitySpawnReason.PATROL);
        if (patrollingmonster != null) {
            patrollingmonster.setPos(pos.getX(), pos.getY(), pos.getZ());
            patrollingmonster.finalizeSpawn((ServerLevelAccessor)level, level.getCurrentDifficultyAt(pos), EntitySpawnReason.PATROL, null);
            level.addFreshEntityWithPassengers((Entity)patrollingmonster);
            return true;
        }
        return false;
    }

    private static boolean mountsOfMayhemPlus$checkPatrollingMonsterSpawnRules(EntityType<? extends BabyRavagerEntity> entityType, LevelAccessor level, EntitySpawnReason spawnReason, BlockPos pos, RandomSource randomSource) {
        return level.getBrightness(LightLayer.BLOCK, pos) > 8 ? false : BrutuskSpawner.mountsOfMayhemPlus$checkAnyLightMonsterSpawnRules(entityType, level, spawnReason, pos, randomSource);
    }

    private static boolean mountsOfMayhemPlus$checkAnyLightMonsterSpawnRules(EntityType<? extends BabyRavagerEntity> entityType, LevelAccessor level, EntitySpawnReason spawnReason, BlockPos pos, RandomSource random) {
        return level.getDifficulty() != Difficulty.PEACEFUL && Mob.checkMobSpawnRules(entityType, (LevelAccessor)level, (EntitySpawnReason)spawnReason, (BlockPos)pos, (RandomSource)random);
    }
}

