/*
 * Decompiled with CFR 0.152.
 */
package com.belgie.mounts_of_mayhem_plus.core;

import com.belgie.mounts_of_mayhem_plus.common.entity.warboar.WarBoarEntity;
import com.belgie.mounts_of_mayhem_plus.common.entity.zombieLlama.ZombieLlamaEntity;
import com.belgie.mounts_of_mayhem_plus.common.entity.zombieWarboar.ZombieWarBoarEntity;
import com.belgie.mounts_of_mayhem_plus.common.world.BrutuskSpawner;
import com.belgie.mounts_of_mayhem_plus.core.ItemRegistry;
import com.belgie.mounts_of_mayhem_plus.core.MobEffectRegistry;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.ItemTags;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.SpearUseGoal;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.monster.skeleton.WitherSkeleton;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.CustomSpawner;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.material.FogType;
import net.minecraft.world.level.storage.loot.BuiltInLootTables;
import net.minecraft.world.level.storage.loot.LootPool;
import net.minecraft.world.level.storage.loot.entries.LootItem;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.functions.SetItemCountFunction;
import net.minecraft.world.level.storage.loot.providers.number.ConstantValue;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;
import net.minecraft.world.level.storage.loot.providers.number.UniformGenerator;
import net.neoforged.neoforge.client.event.ViewportEvent;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.LootTableLoadEvent;
import net.neoforged.neoforge.event.entity.EntityJoinLevelEvent;
import net.neoforged.neoforge.event.entity.player.PlayerInteractEvent;
import net.neoforged.neoforge.event.level.ModifyCustomSpawnersEvent;

public class EventRegistry {
    public static void setupEvents() {
        NeoForge.EVENT_BUS.addListener(EventRegistry::DyeWarBoar);
        NeoForge.EVENT_BUS.addListener(EventRegistry::onEntityInteract);
        NeoForge.EVENT_BUS.addListener(EventRegistry::addArmor);
        NeoForge.EVENT_BUS.addListener(EventRegistry::JoinLevel);
        NeoForge.EVENT_BUS.addListener(EventRegistry::onRenderFog);
        NeoForge.EVENT_BUS.addListener(EventRegistry::addSpawner);
    }

    public static void addSpawner(ModifyCustomSpawnersEvent event) {
        event.addCustomSpawner((CustomSpawner)new BrutuskSpawner());
    }

    public static void onRenderFog(ViewportEvent.RenderFog event) {
        LivingEntity living;
        Entity entity;
        if (event.getType() == FogType.LAVA && (entity = event.getCamera().entity()) instanceof LivingEntity && (living = (LivingEntity)entity).hasEffect(MobEffectRegistry.WITHERED_BONES.getDelegate())) {
            event.setNearPlaneDistance(0.2f);
            event.setFarPlaneDistance(event.getRenderer().getRenderDistance() * 0.15f);
        }
    }

    public static void JoinLevel(EntityJoinLevelEvent event) {
        Entity entity = event.getEntity();
        if (entity instanceof WitherSkeleton) {
            WitherSkeleton skeleton = (WitherSkeleton)entity;
            skeleton.goalSelector.addGoal(2, (Goal)new SpearUseGoal((Monster)skeleton, 1.0, 1.0, 10.0f, 2.0f));
        }
    }

    public static void addArmor(LootTableLoadEvent event) {
        LootPool pool;
        if (event.getKey() == BuiltInLootTables.BASTION_HOGLIN_STABLE) {
            pool = LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)((ItemLike)ItemRegistry.WARBOAR_ARMOR.get())).setWeight(12).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)UniformGenerator.between((float)0.0f, (float)1.0f)))).build();
            event.getTable().addPool(pool);
        }
        if (event.getKey() == BuiltInLootTables.PILLAGER_OUTPOST) {
            pool = LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)((ItemLike)ItemRegistry.BRUTUSK_ARMOR.get())).setWeight(6).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)UniformGenerator.between((float)0.0f, (float)1.0f)))).build();
            event.getTable().addPool(pool);
        }
    }

    public static void DyeWarBoar(PlayerInteractEvent.EntityInteract event) {
        EventRegistry.interactLivingEntity(event.getItemStack(), event.getEntity(), event.getTarget(), event.getHand());
    }

    public static void onEntityInteract(PlayerInteractEvent.EntityInteract event) {
        Entity entity = event.getTarget();
        if (!(entity instanceof ZombieLlamaEntity)) {
            return;
        }
        ZombieLlamaEntity entity2 = (ZombieLlamaEntity)entity;
        ItemStack stack = event.getItemStack();
        if (!stack.is(ItemTags.WOOL_CARPETS)) {
            return;
        }
        if (!entity2.isWearingBodyArmor()) {
            entity2.setItemSlot(EquipmentSlot.BODY, stack.copyWithCount(1));
            stack.shrink(1);
            event.setCanceled(true);
            event.setCancellationResult((InteractionResult)InteractionResult.SUCCESS);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static InteractionResult interactLivingEntity(ItemStack stack, Player player, Entity target, InteractionHand hand) {
        Item item;
        if (target instanceof WarBoarEntity) {
            WarBoarEntity sheep = (WarBoarEntity)target;
            if (player.isCrouching() && (item = stack.getItem()) instanceof DyeItem) {
                DyeItem dyeItem = (DyeItem)item;
                if (!sheep.isAlive() || sheep.getColor() == dyeItem.getDyeColor()) return InteractionResult.PASS;
                sheep.level().playSound((Entity)player, (Entity)sheep, SoundEvents.DYE_USE, SoundSource.PLAYERS, 1.0f, 1.0f);
                if (player.level().isClientSide()) return InteractionResult.SUCCESS;
                sheep.setColor(dyeItem.getDyeColor());
                stack.consume(1, (LivingEntity)player);
                return InteractionResult.SUCCESS;
            }
        }
        if (!(target instanceof ZombieWarBoarEntity)) return InteractionResult.PASS;
        ZombieWarBoarEntity sheep = (ZombieWarBoarEntity)target;
        if (!player.isCrouching() || !((item = stack.getItem()) instanceof DyeItem)) return InteractionResult.PASS;
        DyeItem dyeItem = (DyeItem)item;
        if (!sheep.isAlive() || sheep.getColor() == dyeItem.getDyeColor()) return InteractionResult.PASS;
        sheep.level().playSound((Entity)player, (Entity)sheep, SoundEvents.DYE_USE, SoundSource.PLAYERS, 1.0f, 1.0f);
        if (player.level().isClientSide()) return InteractionResult.SUCCESS;
        sheep.setColor(dyeItem.getDyeColor());
        stack.consume(1, (LivingEntity)player);
        return InteractionResult.SUCCESS;
    }
}

