/*
 * Decompiled with CFR 0.152.
 */
package com.github.L_Ender.cataclysm.event;

import com.github.L_Ender.cataclysm.Attachment.ChargeAttachment;
import com.github.L_Ender.cataclysm.Attachment.ParryAttachment;
import com.github.L_Ender.cataclysm.Attachment.RenderRushAttachment;
import com.github.L_Ender.cataclysm.entity.InternalAnimationMonster.Draugar.Royal_Draugr_Entity;
import com.github.L_Ender.cataclysm.init.ModAttribute;
import com.github.L_Ender.cataclysm.init.ModDataAttachments;
import com.github.L_Ender.cataclysm.init.ModEffect;
import com.github.L_Ender.cataclysm.init.ModItems;
import com.github.L_Ender.cataclysm.init.ModParticle;
import com.github.L_Ender.cataclysm.init.ModSounds;
import com.github.L_Ender.cataclysm.init.ModTag;
import com.github.L_Ender.cataclysm.items.ILeftClick;
import com.github.L_Ender.cataclysm.message.MessageSwingArm;
import com.github.L_Ender.cataclysm.util.CMDamageTypes;
import com.github.L_Ender.lionfishapi.server.event.StandOnFluidEvent;
import java.util.List;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.living.LivingChangeTargetEvent;
import net.neoforged.neoforge.event.entity.living.LivingDamageEvent;
import net.neoforged.neoforge.event.entity.living.LivingDeathEvent;
import net.neoforged.neoforge.event.entity.living.LivingEntityUseItemEvent;
import net.neoforged.neoforge.event.entity.living.LivingEvent;
import net.neoforged.neoforge.event.entity.living.LivingFallEvent;
import net.neoforged.neoforge.event.entity.living.LivingHealEvent;
import net.neoforged.neoforge.event.entity.living.LivingIncomingDamageEvent;
import net.neoforged.neoforge.event.entity.living.LivingKnockBackEvent;
import net.neoforged.neoforge.event.entity.living.LivingShieldBlockEvent;
import net.neoforged.neoforge.event.entity.living.MobEffectEvent;
import net.neoforged.neoforge.event.entity.player.AdvancementEvent;
import net.neoforged.neoforge.event.entity.player.AttackEntityEvent;
import net.neoforged.neoforge.event.entity.player.CriticalHitEvent;
import net.neoforged.neoforge.event.entity.player.PlayerInteractEvent;
import net.neoforged.neoforge.event.level.BlockEvent;
import net.neoforged.neoforge.event.tick.PlayerTickEvent;
import net.neoforged.neoforge.network.PacketDistributor;
import top.theillusivec4.curios.api.CuriosApi;

@EventBusSubscriber(modid="cataclysm")
public class ServerEventHandler {
    @SubscribeEvent
    public static void onLivingUpdateEvent(PlayerTickEvent.Post event) {
        ((ChargeAttachment)event.getEntity().getData(ModDataAttachments.CHARGE_ATTACHMENT)).tick((LivingEntity)event.getEntity());
        ((RenderRushAttachment)event.getEntity().getData(ModDataAttachments.RENDER_RUSH_ATTACHMENT)).tick((LivingEntity)event.getEntity());
        if (((Boolean)event.getEntity().getData(ModDataAttachments.HOOK_FALLING)).booleanValue()) {
            event.getEntity().setIgnoreFallDamageFromCurrentImpulse(true);
            event.getEntity().currentImpulseImpactPos = event.getEntity().position();
        }
    }

    @SubscribeEvent
    public static void StandOnFluidEventEvent(StandOnFluidEvent event) {
        if (!event.getEntity().getItemBySlot(EquipmentSlot.FEET).isEmpty() && event.getEntity().getItemBySlot(EquipmentSlot.FEET).getItem() == ModItems.IGNITIUM_BOOTS.get() && !event.getEntity().isShiftKeyDown() && (event.getFluidState().is((Fluid)Fluids.LAVA) || event.getFluidState().is((Fluid)Fluids.FLOWING_LAVA))) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void onPlayerAttack(AttackEntityEvent event) {
        if (event.getEntity().hasEffect(ModEffect.EFFECTSTUN)) {
            event.setCanceled(true);
        }
        if (event.getEntity().hasEffect(ModEffect.EFFECTGHOST_FORM)) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void BlockHeal(LivingHealEvent event) {
        float heal = event.getAmount();
        if (event.getEntity().hasEffect(ModEffect.EFFECTABYSSAL_FEAR)) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void onLivingJump(LivingEvent.LivingJumpEvent event) {
        LivingEntity entity = event.getEntity();
        if (entity.getEffect(ModEffect.EFFECTSTUN) != null) {
            entity.setDeltaMovement(entity.getDeltaMovement().x(), 0.0, entity.getDeltaMovement().z());
        }
    }

    @SubscribeEvent
    public static void onPlayerLeftClick(PlayerInteractEvent.LeftClickBlock event) {
        Player player = event.getEntity();
        if (player.hasEffect(ModEffect.EFFECTSTUN)) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void onUseItemStart(LivingEntityUseItemEvent.Start event) {
        LivingEntity living = event.getEntity();
        ItemStack itemStack = event.getItem();
        if (living.hasEffect(ModEffect.EFFECTSTUN)) {
            event.setCanceled(true);
        }
        if (living.hasEffect(ModEffect.EFFECTGHOST_FORM)) {
            event.setCanceled(true);
        }
        if (itemStack.has(DataComponents.FOOD)) {
            int originalDuration = event.getDuration();
            float EatSpeed = (float)living.getAttributeValue(ModAttribute.EAT_SPEED) / 100.0f;
            int newDuration = (int)((double)originalDuration / (1.0 + (double)EatSpeed));
            event.setDuration(Math.max(1, newDuration));
        }
    }

    @SubscribeEvent
    public static void onUseItem(LivingEntityUseItemEvent event) {
        LivingEntity living = event.getEntity();
        if (living.hasEffect(ModEffect.EFFECTSTUN)) {
            event.setDuration(0);
        }
        if (living.hasEffect(ModEffect.EFFECTGHOST_FORM)) {
            event.setDuration(0);
        }
    }

    @SubscribeEvent
    public static void onPlaceBlock(BlockEvent.EntityPlaceEvent event) {
        LivingEntity living;
        Entity entity = event.getEntity();
        if (entity instanceof LivingEntity && (living = (LivingEntity)entity).hasEffect(ModEffect.EFFECTSTUN)) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void KnockbackEvent(LivingKnockBackEvent event) {
        Royal_Draugr_Entity royalDraugr;
        LivingEntity living = event.getEntity();
        if (living instanceof Royal_Draugr_Entity && (royalDraugr = (Royal_Draugr_Entity)living).isDraugrBlocking()) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void onBreakBlock(BlockEvent.BreakEvent event) {
        if (event.getPlayer().hasEffect(ModEffect.EFFECTSTUN)) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void onPlayerInteract1(PlayerInteractEvent.RightClickEmpty event) {
    }

    @SubscribeEvent
    public static void onPlayerInteract2(PlayerInteractEvent.LeftClickEmpty event) {
        if (event.getEntity().hasEffect(ModEffect.EFFECTSTUN)) {
            // empty if block
        }
        boolean flag = false;
        ItemStack leftItem = event.getEntity().getOffhandItem();
        ItemStack rightItem = event.getEntity().getMainHandItem();
        if (!event.getEntity().hasEffect(ModEffect.EFFECTSTUN)) {
            if (leftItem.getItem() instanceof ILeftClick) {
                ((ILeftClick)leftItem.getItem()).onLeftClick(leftItem, (LivingEntity)event.getEntity());
                flag = true;
            }
            if (rightItem.getItem() instanceof ILeftClick) {
                ((ILeftClick)rightItem.getItem()).onLeftClick(rightItem, (LivingEntity)event.getEntity());
                flag = true;
            }
            if (event.getLevel().isClientSide && flag) {
                PacketDistributor.sendToServer((CustomPacketPayload)new MessageSwingArm(InteractionHand.MAIN_HAND), (CustomPacketPayload[])new CustomPacketPayload[0]);
            }
        }
    }

    @SubscribeEvent
    public static void onPlayerInteract3(PlayerInteractEvent.EntityInteract event) {
        if (event.getEntity().hasEffect(ModEffect.EFFECTSTUN)) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void onPlayerInteract4(PlayerInteractEvent.RightClickBlock event) {
        if (event.getEntity().hasEffect(ModEffect.EFFECTSTUN)) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void onPlayerInteract5(PlayerInteractEvent.LeftClickBlock event) {
        if (event.getEntity().hasEffect(ModEffect.EFFECTSTUN)) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void onLivingSetTargetEvent(LivingChangeTargetEvent event) {
        Mob mob;
        LivingEntity livingEntity;
        if (event.getNewAboutToBeSetTarget() != null && (livingEntity = event.getEntity()) instanceof Mob && (mob = (Mob)livingEntity).getType().is(ModTag.LAVA_MONSTER) && event.getEntity().getLastHurtByMob() != event.getNewAboutToBeSetTarget() && event.getNewAboutToBeSetTarget().getItemBySlot(EquipmentSlot.HEAD).is((Item)ModItems.IGNITIUM_HELMET.get())) {
            event.setCanceled(true);
            return;
        }
    }

    @SubscribeEvent
    public static void onLivingDamage(LivingDamageEvent.Post event) {
        Entity attacker;
        Entity entity;
        LivingEntity entity2 = event.getEntity();
        DamageSource source = event.getSource();
        if (entity2.getHealth() <= event.getNewDamage() && entity2.hasEffect(ModEffect.EFFECTSTUN)) {
            entity2.removeEffect(ModEffect.EFFECTSTUN);
        }
        if (source.is(CMDamageTypes.DRACONIC_WOUND) && entity2.hasEffect(MobEffects.ABSORPTION)) {
            entity2.removeEffect(MobEffects.ABSORPTION);
        }
        if ((entity = event.getSource().getDirectEntity()) instanceof LivingEntity) {
            LivingEntity living = (LivingEntity)entity;
            List slot = CuriosApi.getCuriosHelper().findCurios(living, stack -> stack.is((Item)ModItems.BLAZING_GRIPS.get()));
            if (!slot.isEmpty() && event.getEntity().getRandom().nextFloat() < 0.15f * (float)slot.size()) {
                MobEffectInstance effectinstance = new MobEffectInstance(ModEffect.EFFECTBLAZING_BRAND, 60, 0);
                entity2.addEffect(effectinstance);
            }
        }
        if (!event.getEntity().getItemBySlot(EquipmentSlot.LEGS).isEmpty() && event.getSource() != null && event.getSource().getEntity() != null && event.getEntity().getItemBySlot(EquipmentSlot.LEGS).getItem() == ModItems.IGNITIUM_LEGGINGS.get() && (attacker = event.getSource().getEntity()) instanceof LivingEntity && attacker != event.getEntity() && event.getEntity().getRandom().nextFloat() < 0.5f) {
            MobEffectInstance effectinstance = new MobEffectInstance(ModEffect.EFFECTBLAZING_BRAND, 100, 0, false, false, true);
            ((LivingEntity)attacker).addEffect(effectinstance);
            if (!attacker.isOnFire()) {
                attacker.igniteForSeconds(5.0f);
            }
        }
    }

    @SubscribeEvent
    public static void onShieldDamage(LivingShieldBlockEvent event) {
        MobEffectInstance effectinstance;
        LivingEntity livingEntity;
        DamageSource source = event.getDamageSource();
        LivingEntity entity = event.getEntity();
        Item item = entity.getUseItem().getItem();
        Entity directEntity = source.getDirectEntity();
        if (source.is(CMDamageTypes.MALEDICTIO_SAGITTA)) {
            event.setShieldDamage(0.0f);
        }
        ParryAttachment charge = (ParryAttachment)entity.getData(ModDataAttachments.PARRY_ATTACHMENT);
        if (item == ModItems.BULWARK_OF_THE_FLAME.get() && event.getBlocked() && charge.getParryFrame() < 13 && directEntity instanceof LivingEntity) {
            livingEntity = (LivingEntity)directEntity;
            livingEntity.igniteForSeconds(3.0f);
            livingEntity.playSound(SoundEvents.ANVIL_LAND, 0.8f, 1.3f);
            effectinstance = new MobEffectInstance(ModEffect.EFFECTBLAZING_BRAND, 100, 0);
            livingEntity.knockback(0.5, entity.getX() - livingEntity.getX(), entity.getZ() - livingEntity.getZ());
            livingEntity.addEffect(effectinstance);
        }
        if (item == ModItems.AZURE_SEA_SHIELD.get() && event.getBlocked() && charge.getParryFrame() < 10) {
            event.setShieldDamage(0.0f);
            if (directEntity instanceof LivingEntity) {
                livingEntity = (LivingEntity)directEntity;
                livingEntity.playSound((SoundEvent)ModSounds.PARRY.get(), 0.4f, 1.0f);
                entity.addEffect(new MobEffectInstance(MobEffects.DAMAGE_BOOST, 40, 1));
                effectinstance = new MobEffectInstance(MobEffects.MOVEMENT_SLOWDOWN, 120, 1);
                livingEntity.knockback(0.5, entity.getX() - livingEntity.getX(), entity.getZ() - livingEntity.getZ());
                livingEntity.addEffect(effectinstance);
            }
        }
    }

    @SubscribeEvent
    public static void DeathEvent(LivingDeathEvent event) {
        DamageSource source = event.getSource();
        if (!source.is(DamageTypeTags.BYPASSES_INVULNERABILITY) && ServerEventHandler.tryCursiumPlateRebirth(event.getEntity())) {
            event.setCanceled(true);
        }
    }

    private static boolean tryCursiumPlateRebirth(LivingEntity living) {
        ItemStack chestplate = living.getItemBySlot(EquipmentSlot.CHEST);
        Level level = living.level();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            if (chestplate.getItem() == ModItems.CURSIUM_CHESTPLATE.get() && !living.hasEffect(ModEffect.EFFECTGHOST_SICKNESS) && !living.hasEffect(ModEffect.EFFECTGHOST_FORM)) {
                living.setHealth(5.0f);
                serverLevel.playSound(null, living.getX(), living.getY(), living.getZ(), SoundEvents.TOTEM_USE, living.getSoundSource(), 1.25f, 1.0f);
                living.addEffect(new MobEffectInstance(MobEffects.FIRE_RESISTANCE, 200, 0));
                living.addEffect(new MobEffectInstance(ModEffect.EFFECTGHOST_FORM, 100, 0, false, true, true));
                double d0 = living.getX();
                double d1 = living.getY() + 3.0;
                double d2 = living.getZ();
                serverLevel.sendParticles((ParticleOptions)((SimpleParticleType)ModParticle.CURSED_ALGIZ.get()), d0, d1, d2, 1, 0.0, 0.0, 0.0, 0.0);
                return true;
            }
        }
        return false;
    }

    @SubscribeEvent
    public static void onLivingAttack(LivingIncomingDamageEvent event) {
        MobEffectInstance effectinstance1;
        DamageSource source = event.getSource();
        float damage = event.getAmount();
        if (source.is(DamageTypeTags.IS_LIGHTNING) && event.getEntity().hasEffect(ModEffect.EFFECTWETNESS) && (effectinstance1 = event.getEntity().getEffect(ModEffect.EFFECTWETNESS)) != null) {
            float i = (float)(effectinstance1.getAmplifier() + 1) * 0.2f;
            float f = damage + damage * i;
            damage = Math.min(Float.MAX_VALUE, f);
            event.setAmount(damage);
        }
        if (event.getEntity().hasEffect(ModEffect.EFFECTGHOST_FORM) && !event.getSource().is(DamageTypeTags.BYPASSES_INVULNERABILITY)) {
            event.setCanceled(true);
        }
        if (!event.getEntity().getItemBySlot(EquipmentSlot.LEGS).isEmpty() && event.getEntity().getItemBySlot(EquipmentSlot.LEGS).getItem() == ModItems.CURSIUM_LEGGINGS.get()) {
            if (event.getSource().is(DamageTypeTags.IS_PROJECTILE)) {
                if (event.getEntity().getRandom().nextFloat() < 0.15f) {
                    event.setCanceled(true);
                }
            } else if (!event.getSource().is(DamageTypeTags.BYPASSES_INVULNERABILITY) && event.getEntity().getRandom().nextFloat() < 0.08f) {
                event.setCanceled(true);
            }
        }
    }

    @SubscribeEvent
    public static void onCriticalAttack(CriticalHitEvent event) {
        AttributeInstance attackDamageAttr;
        Entity entity;
        Player player = event.getEntity();
        ItemStack weapon = player.getMainHandItem();
        if (!weapon.isEmpty() && (entity = event.getTarget()) instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)entity;
            if (weapon.getItem() == ModItems.THE_IMMOLATOR.get() && livingEntity.hasEffect(ModEffect.EFFECTBLAZING_BRAND)) {
                event.setCriticalHit(true);
            }
            if ((weapon.getItem() == ModItems.THE_ANNIHILATOR.get() || weapon.getItem() == ModItems.CERAUNUS.get() || weapon.getItem() == ModItems.THE_IMMOLATOR.get()) && event.isCriticalHit()) {
                livingEntity.playSound((SoundEvent)ModSounds.PARRY.get(), 0.5f, 1.1f);
            }
        }
        if ((attackDamageAttr = player.getAttribute(ModAttribute.ADDITIONAL_CRITICAL_DAMAGE)) != null) {
            double extraCritPercent = attackDamageAttr.getValue();
            float vanillaCrit = event.getDamageMultiplier();
            float finalMultiplier = (float)((double)vanillaCrit + extraCritPercent / 100.0);
            if (finalMultiplier < 1.0f) {
                finalMultiplier = 1.0f;
            }
            event.setDamageMultiplier(finalMultiplier);
        }
    }

    @SubscribeEvent
    public static void preventEffectRemoval(MobEffectEvent.Remove event) {
        MobEffectInstance effectInstance = event.getEffectInstance();
        if (effectInstance != null && effectInstance.getEffect() == ModEffect.EFFECTGHOST_SICKNESS.get()) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void onLivingFall(LivingFallEvent event) {
        Player player;
        LivingEntity livingEntity;
        if (!event.getEntity().getItemBySlot(EquipmentSlot.FEET).isEmpty() && event.getEntity().getItemBySlot(EquipmentSlot.FEET).getItem() == ModItems.CURSIUM_BOOTS.get()) {
            event.setDistance(event.getDistance() * 0.3f);
        }
        if ((livingEntity = event.getEntity()) instanceof Player && ((Boolean)(player = (Player)livingEntity).getData(ModDataAttachments.HOOK_FALLING)).booleanValue()) {
            event.setDistance(0.0f);
            event.setCanceled(false);
        }
    }

    @SubscribeEvent
    public static void onPlayerInteract(PlayerInteractEvent.RightClickItem event) {
        if (event.getEntity().hasEffect(ModEffect.EFFECTSTUN)) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void onStartUsing(LivingEntityUseItemEvent.Start event) {
        Player player;
        LivingEntity livingEntity;
        Item item = event.getItem().getItem();
        if ((item == ModItems.AZURE_SEA_SHIELD.get() || item == ModItems.BULWARK_OF_THE_FLAME.get()) && (livingEntity = event.getEntity()) instanceof Player && !(player = (Player)livingEntity).getCooldowns().isOnCooldown(item)) {
            ParryAttachment charge = (ParryAttachment)player.getData(ModDataAttachments.PARRY_ATTACHMENT);
            charge.setParryFrame(0);
        }
    }

    @SubscribeEvent
    public static void onUseTick(LivingEntityUseItemEvent.Tick event) {
        LivingEntity livingEntity;
        Item item = event.getItem().getItem();
        if ((item == ModItems.AZURE_SEA_SHIELD.get() || item == ModItems.BULWARK_OF_THE_FLAME.get()) && (livingEntity = event.getEntity()) instanceof Player) {
            Player player = (Player)livingEntity;
            ParryAttachment charge = (ParryAttachment)player.getData(ModDataAttachments.PARRY_ATTACHMENT);
            charge.setParryFrame(charge.getParryFrame() + 1);
        }
    }

    @SubscribeEvent
    public static void onStopUsing(LivingEntityUseItemEvent.Stop event) {
        LivingEntity livingEntity;
        Item item = event.getItem().getItem();
        if ((item == ModItems.AZURE_SEA_SHIELD.get() || item == ModItems.BULWARK_OF_THE_FLAME.get()) && (livingEntity = event.getEntity()) instanceof Player) {
            Player player = (Player)livingEntity;
            ParryAttachment charge = (ParryAttachment)player.getData(ModDataAttachments.PARRY_ATTACHMENT);
            charge.setParryFrame(0);
        }
    }

    @SubscribeEvent
    public static void onAdvancementEarned(AdvancementEvent.AdvancementEarnEvent event) {
        Player player = event.getEntity();
        ResourceLocation advId = event.getAdvancement().id();
        if (advId.equals((Object)ResourceLocation.fromNamespaceAndPath((String)"cataclysm", (String)"kill_all_bosses"))) {
            ItemStack reward = new ItemStack((ItemLike)ModItems.MUSIC_DISC_THE_CATACLYSM_FARER.get());
            if (!player.getInventory().add(reward)) {
                player.drop(reward, false);
            }
            player.playNotifySound((SoundEvent)ModSounds.THE_CATACLYSM_FARER.get(), SoundSource.RECORDS, 1.0f, 1.0f);
        }
    }
}

