/*
 * Decompiled with CFR 0.152.
 */
package com.github.L_Ender.cataclysm.util;

import java.util.HashSet;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponentPatch;
import net.minecraft.core.component.DataComponents;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.ItemAttributeModifiers;

public class AttributeUtils {
    public static void mergeAttributes(DataComponentPatch.Builder builder, Item item, ItemAttributeModifiers newModifiers) {
        ItemAttributeModifiers existingModifiers = (ItemAttributeModifiers)item.components().getOrDefault(DataComponents.ATTRIBUTE_MODIFIERS, (Object)ItemAttributeModifiers.EMPTY);
        HashSet<Holder> attributesOverwritten = new HashSet<Holder>();
        for (ItemAttributeModifiers.Entry entry : newModifiers.modifiers()) {
            attributesOverwritten.add(entry.attribute());
        }
        ItemAttributeModifiers.Builder combinedBuilder = ItemAttributeModifiers.builder();
        for (ItemAttributeModifiers.Entry entry : existingModifiers.modifiers()) {
            if (attributesOverwritten.contains(entry.attribute())) continue;
            combinedBuilder.add(entry.attribute(), entry.modifier(), entry.slot());
        }
        for (ItemAttributeModifiers.Entry entry : newModifiers.modifiers()) {
            combinedBuilder.add(entry.attribute(), entry.modifier(), entry.slot());
        }
        builder.set(DataComponents.ATTRIBUTE_MODIFIERS, (Object)combinedBuilder.build());
    }

    public static float OriginDamage(LivingEntity living, ItemStack itemStack) {
        double totalDamage = living.getAttributeValue(Attributes.ATTACK_DAMAGE);
        if (living.getMainHandItem() == itemStack) {
            return (float)totalDamage;
        }
        ItemStack mainHandStack = living.getMainHandItem();
        if (!mainHandStack.isEmpty()) {
            ItemAttributeModifiers modifiers = (ItemAttributeModifiers)mainHandStack.getOrDefault(DataComponents.ATTRIBUTE_MODIFIERS, (Object)ItemAttributeModifiers.EMPTY);
            for (ItemAttributeModifiers.Entry entry : modifiers.modifiers()) {
                if (!entry.attribute().is(Attributes.ATTACK_DAMAGE) || !entry.slot().test(EquipmentSlot.MAINHAND) || entry.modifier().operation() != AttributeModifier.Operation.ADD_VALUE) continue;
                totalDamage -= entry.modifier().amount();
            }
        }
        ItemAttributeModifiers shredderModifiers = (ItemAttributeModifiers)itemStack.getOrDefault(DataComponents.ATTRIBUTE_MODIFIERS, (Object)ItemAttributeModifiers.EMPTY);
        for (ItemAttributeModifiers.Entry entry : shredderModifiers.modifiers()) {
            if (!entry.attribute().is(Attributes.ATTACK_DAMAGE) || !entry.slot().test(EquipmentSlot.MAINHAND) || entry.modifier().operation() != AttributeModifier.Operation.ADD_VALUE) continue;
            totalDamage += entry.modifier().amount();
        }
        return (float)totalDamage;
    }
}

