/*
 * Decompiled with CFR 0.152.
 */
package toastysmobs.client.model;

import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.renderer.entity.state.LivingEntityRenderState;
import net.minecraft.resources.ResourceLocation;

public class ModelButterfly
extends EntityModel<LivingEntityRenderState> {
    public static final ModelLayerLocation LAYER_LOCATION = new ModelLayerLocation(ResourceLocation.fromNamespaceAndPath((String)"toastysmobs", (String)"model_butterfly"), "main");
    public final ModelPart butterfly;
    public final ModelPart body;
    public final ModelPart lwing;
    public final ModelPart rwing;

    public ModelButterfly(ModelPart root) {
        super(root);
        this.butterfly = root.getChild("butterfly");
        this.body = this.butterfly.getChild("body");
        this.lwing = this.butterfly.getChild("lwing");
        this.rwing = this.butterfly.getChild("rwing");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        PartDefinition butterfly = partdefinition.addOrReplaceChild("butterfly", CubeListBuilder.create(), PartPose.offset((float)2.0f, (float)22.0f, (float)-6.0f));
        PartDefinition body = butterfly.addOrReplaceChild("body", CubeListBuilder.create().texOffs(22, 18).addBox(-1.0f, -2.0f, -2.0f, 0.0f, 2.0f, 3.0f, new CubeDeformation(0.0f)).texOffs(16, 18).addBox(-3.0f, -2.0f, -2.0f, 0.0f, 2.0f, 3.0f, new CubeDeformation(0.0f)).texOffs(0, 18).addBox(-3.0f, 0.0f, 1.0f, 2.0f, 2.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition lwing = butterfly.addOrReplaceChild("lwing", CubeListBuilder.create().texOffs(0, 0).addBox(0.0f, 0.0f, -3.0f, 5.0f, 0.0f, 9.0f, new CubeDeformation(0.0f)), PartPose.offset((float)-1.0f, (float)0.0f, (float)3.0f));
        PartDefinition rwing = butterfly.addOrReplaceChild("rwing", CubeListBuilder.create().texOffs(0, 9).addBox(-5.0f, 0.0f, -3.0f, 5.0f, 0.0f, 9.0f, new CubeDeformation(0.0f)), PartPose.offset((float)-3.0f, (float)0.0f, (float)3.0f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)32, (int)32);
    }

    public void setupAnim(LivingEntityRenderState state) {
        float limbSwing = state.walkAnimationPos;
        float limbSwingAmount = state.walkAnimationSpeed;
        float ageInTicks = state.ageInTicks;
        float netHeadYaw = state.yRot;
        float headPitch = state.xRot;
    }
}

