/*
 * Decompiled with CFR 0.152.
 */
package toastysmobs.client.model;

import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.renderer.entity.state.LivingEntityRenderState;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;

public class Modelduck
extends EntityModel<LivingEntityRenderState> {
    public static final ModelLayerLocation LAYER_LOCATION = new ModelLayerLocation(ResourceLocation.fromNamespaceAndPath((String)"toastysmobs", (String)"modelduck"), "main");
    public final ModelPart bone;
    public final ModelPart body;
    public final ModelPart right_leg;
    public final ModelPart head;
    public final ModelPart right_wing;
    public final ModelPart left_leg;
    public final ModelPart left_wing;
    public final ModelPart tail;

    public Modelduck(ModelPart root) {
        super(root);
        this.bone = root.getChild("bone");
        this.body = this.bone.getChild("body");
        this.right_leg = this.body.getChild("right_leg");
        this.head = this.body.getChild("head");
        this.right_wing = this.body.getChild("right_wing");
        this.left_leg = this.body.getChild("left_leg");
        this.left_wing = this.body.getChild("left_wing");
        this.tail = this.body.getChild("tail");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        PartDefinition bone = partdefinition.addOrReplaceChild("bone", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)24.0f, (float)0.0f));
        PartDefinition body = bone.addOrReplaceChild("body", CubeListBuilder.create().texOffs(0, 0).addBox(-3.0f, -4.0f, -3.0f, 6.0f, 7.0f, 10.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)-7.0f, (float)-2.0f));
        PartDefinition right_leg = body.addOrReplaceChild("right_leg", CubeListBuilder.create().texOffs(16, 41).addBox(-1.0f, 1.0f, -3.0f, 3.0f, 4.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.offset((float)-2.0f, (float)2.0f, (float)3.0f));
        PartDefinition head = body.addOrReplaceChild("head", CubeListBuilder.create().texOffs(1, 30).addBox(-2.0f, -7.0f, -2.0f, 4.0f, 9.0f, 3.0f, new CubeDeformation(0.0f)).texOffs(33, 11).addBox(-1.5f, -5.0f, -6.0f, 3.0f, 1.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)-3.0f, (float)-2.0f));
        PartDefinition right_wing = body.addOrReplaceChild("right_wing", CubeListBuilder.create().texOffs(0, 17).addBox(-1.0f, -2.0f, -1.0f, 2.0f, 5.0f, 7.0f, new CubeDeformation(0.0f)).texOffs(35, 32).addBox(-1.0f, -2.0f, 6.0f, 1.0f, 5.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offset((float)-4.0f, (float)-2.0f, (float)-1.0f));
        PartDefinition left_leg = body.addOrReplaceChild("left_leg", CubeListBuilder.create().texOffs(36, 17).addBox(-1.0f, 1.0f, -3.0f, 3.0f, 4.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.offset((float)1.0f, (float)2.0f, (float)3.0f));
        PartDefinition left_wing = body.addOrReplaceChild("left_wing", CubeListBuilder.create().texOffs(19, 32).addBox(0.0f, 0.0f, 6.0f, 1.0f, 5.0f, 4.0f, new CubeDeformation(0.0f)).texOffs(18, 17).addBox(-1.0f, 0.0f, -1.0f, 2.0f, 5.0f, 7.0f, new CubeDeformation(0.0f)), PartPose.offset((float)4.0f, (float)-4.0f, (float)-1.0f));
        PartDefinition tail = body.addOrReplaceChild("tail", CubeListBuilder.create().texOffs(31, 0).addBox(-1.5f, 0.0f, 0.0f, 3.0f, 2.0f, 8.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)-3.0f, (float)6.0f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)64, (int)64);
    }

    public void setupAnim(LivingEntityRenderState state) {
        float limbSwing = state.walkAnimationPos;
        float limbSwingAmount = state.walkAnimationSpeed;
        float ageInTicks = state.ageInTicks;
        float netHeadYaw = state.yRot;
        float headPitch = state.xRot;
        this.head.yRot = netHeadYaw / 57.295776f;
        this.head.xRot = headPitch / 57.295776f;
        this.left_leg.xRot = Mth.cos((float)(limbSwing * 1.0f)) * -1.0f * limbSwingAmount;
        this.right_leg.xRot = Mth.cos((float)(limbSwing * 1.0f)) * 1.0f * limbSwingAmount;
    }
}

