/*
 * Decompiled with CFR 0.152.
 */
package toastysmobs.client.model;

import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.renderer.entity.state.LivingEntityRenderState;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;

public class Modelpigeon
extends EntityModel<LivingEntityRenderState> {
    public static final ModelLayerLocation LAYER_LOCATION = new ModelLayerLocation(ResourceLocation.fromNamespaceAndPath((String)"toastysmobs", (String)"modelpigeon"), "main");
    public final ModelPart root;
    public final ModelPart body;
    public final ModelPart head;
    public final ModelPart eyelids;
    public final ModelPart wings;
    public final ModelPart rightWing;
    public final ModelPart leftWing;
    public final ModelPart legs;
    public final ModelPart rightLeg;
    public final ModelPart rightFoot;
    public final ModelPart leftLeg;
    public final ModelPart leftFoot;

    public Modelpigeon(ModelPart root) {
        super(root);
        this.root = root.getChild("root");
        this.body = this.root.getChild("body");
        this.head = this.body.getChild("head");
        this.eyelids = this.head.getChild("eyelids");
        this.wings = this.body.getChild("wings");
        this.rightWing = this.wings.getChild("rightWing");
        this.leftWing = this.wings.getChild("leftWing");
        this.legs = this.body.getChild("legs");
        this.rightLeg = this.legs.getChild("rightLeg");
        this.rightFoot = this.rightLeg.getChild("rightFoot");
        this.leftLeg = this.legs.getChild("leftLeg");
        this.leftFoot = this.leftLeg.getChild("leftFoot");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        PartDefinition root = partdefinition.addOrReplaceChild("root", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)20.0f, (float)0.0f));
        PartDefinition body = root.addOrReplaceChild("body", CubeListBuilder.create().texOffs(0, 0).addBox(-2.0f, -2.0f, -2.0f, 4.0f, 4.0f, 5.0f, new CubeDeformation(0.0f)).texOffs(0, 9).addBox(-1.5f, -2.0f, 3.0f, 3.0f, 3.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition head = body.addOrReplaceChild("head", CubeListBuilder.create().texOffs(10, 13).addBox(-1.0f, -4.0f, -1.5f, 2.0f, 5.0f, 2.0f, new CubeDeformation(0.0f)).texOffs(0, 15).addBox(-0.5f, -3.0f, -2.5f, 1.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)-1.0f, (float)-1.0f));
        PartDefinition eyelids = head.addOrReplaceChild("eyelids", CubeListBuilder.create().texOffs(20, 17).addBox(-1.0f, -0.5f, -0.5f, 2.0f, 1.0f, 1.0f, new CubeDeformation(-0.01f)), PartPose.offset((float)0.0f, (float)-2.5f, (float)-1.0f));
        PartDefinition wings = body.addOrReplaceChild("wings", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)-2.0f, (float)-1.0f));
        PartDefinition rightWing = wings.addOrReplaceChild("rightWing", CubeListBuilder.create().texOffs(22, 25).addBox(-1.001f, 0.0f, 0.0f, 1.0f, 3.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offset((float)-2.0f, (float)0.0f, (float)0.0f));
        PartDefinition leftWing = wings.addOrReplaceChild("leftWing", CubeListBuilder.create().texOffs(22, 0).addBox(0.001f, 0.0f, 0.0f, 1.0f, 3.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offset((float)2.0f, (float)0.0f, (float)0.0f));
        PartDefinition legs = body.addOrReplaceChild("legs", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)2.0f, (float)1.5f));
        PartDefinition rightLeg = legs.addOrReplaceChild("rightLeg", CubeListBuilder.create().texOffs(0, 2).addBox(-0.5f, 0.0f, -0.5f, 1.0f, 1.0f, 1.0f, new CubeDeformation(-0.01f)).texOffs(3, 2).addBox(-0.5f, 1.0f, 0.0f, 1.0f, 1.0f, 0.0f, new CubeDeformation(-0.01f)), PartPose.offset((float)-1.5f, (float)0.0f, (float)0.0f));
        PartDefinition rightFoot = rightLeg.addOrReplaceChild("rightFoot", CubeListBuilder.create().texOffs(4, 28).addBox(-1.5f, 0.0f, -2.5f, 3.0f, 0.0f, 4.0f, new CubeDeformation(-0.01f)), PartPose.offset((float)0.0f, (float)2.0f, (float)0.0f));
        PartDefinition leftLeg = legs.addOrReplaceChild("leftLeg", CubeListBuilder.create().texOffs(0, 0).addBox(-0.5f, 0.0f, -0.5f, 1.0f, 1.0f, 1.0f, new CubeDeformation(-0.01f)).texOffs(3, 0).addBox(-0.5f, 1.0f, 0.0f, 1.0f, 1.0f, 0.0f, new CubeDeformation(-0.01f)), PartPose.offset((float)1.5f, (float)0.0f, (float)0.0f));
        PartDefinition leftFoot = leftLeg.addOrReplaceChild("leftFoot", CubeListBuilder.create().texOffs(22, 10).addBox(-1.5f, 0.0f, -2.5f, 3.0f, 0.0f, 4.0f, new CubeDeformation(-0.01f)), PartPose.offset((float)0.0f, (float)2.0f, (float)0.0f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)32, (int)32);
    }

    public void setupAnim(LivingEntityRenderState state) {
        float limbSwing = state.walkAnimationPos;
        float limbSwingAmount = state.walkAnimationSpeed;
        float ageInTicks = state.ageInTicks;
        float netHeadYaw = state.yRot;
        float headPitch = state.xRot;
        this.head.yRot = netHeadYaw / 57.295776f;
        this.head.xRot = headPitch / 57.295776f;
        this.rightLeg.xRot = Mth.cos((float)(limbSwing * 1.0f)) * 1.0f * limbSwingAmount;
        this.leftLeg.xRot = Mth.cos((float)(limbSwing * 1.0f)) * -1.0f * limbSwingAmount;
    }
}

