/*
 * Decompiled with CFR 0.152.
 */
package toastysmobs.client.renderer;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.renderer.entity.state.EntityRenderState;
import net.minecraft.client.renderer.entity.state.LivingEntityRenderState;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import toastysmobs.client.model.Modelbear;
import toastysmobs.entity.BearEntity;
import toastysmobs.procedures.BearDisplayConditionProcedure;
import toastysmobs.procedures.BearWinnieThePoohDisplayConditionProcedure;

public class BearRenderer
extends MobRenderer<BearEntity, LivingEntityRenderState, Modelbear> {
    private BearEntity entity = null;

    public BearRenderer(EntityRendererProvider.Context context) {
        super(context, (EntityModel)new Modelbear(context.bakeLayer(Modelbear.LAYER_LOCATION)), 0.5f);
        this.addLayer((RenderLayer)new RenderLayer<LivingEntityRenderState, Modelbear>((RenderLayerParent)this){
            final ResourceLocation LAYER_TEXTURE;
            {
                this.LAYER_TEXTURE = ResourceLocation.parse((String)"toastysmobs:textures/entities/bear_texture_angry.png");
            }

            public void render(PoseStack poseStack, MultiBufferSource bufferSource, int light, LivingEntityRenderState state, float headYaw, float headPitch) {
                Level world = BearRenderer.this.entity.level();
                double x = BearRenderer.this.entity.getX();
                double y = BearRenderer.this.entity.getY();
                double z = BearRenderer.this.entity.getZ();
                if (BearDisplayConditionProcedure.execute((Entity)BearRenderer.this.entity)) {
                    VertexConsumer vertexConsumer = bufferSource.getBuffer(RenderType.eyes((ResourceLocation)this.LAYER_TEXTURE));
                    Modelbear model = new Modelbear(Minecraft.getInstance().getEntityModels().bakeLayer(Modelbear.LAYER_LOCATION));
                    model.setupAnim((EntityRenderState)state);
                    model.renderToBuffer(poseStack, vertexConsumer, light, LivingEntityRenderer.getOverlayCoords((LivingEntityRenderState)state, (float)0.0f));
                }
            }
        });
        this.addLayer((RenderLayer)new RenderLayer<LivingEntityRenderState, Modelbear>((RenderLayerParent)this){
            final ResourceLocation LAYER_TEXTURE;
            {
                this.LAYER_TEXTURE = ResourceLocation.parse((String)"toastysmobs:textures/entities/winnie_bear_texture.png");
            }

            public void render(PoseStack poseStack, MultiBufferSource bufferSource, int light, LivingEntityRenderState state, float headYaw, float headPitch) {
                Level world = BearRenderer.this.entity.level();
                double x = BearRenderer.this.entity.getX();
                double y = BearRenderer.this.entity.getY();
                double z = BearRenderer.this.entity.getZ();
                if (BearWinnieThePoohDisplayConditionProcedure.execute((Entity)BearRenderer.this.entity)) {
                    VertexConsumer vertexConsumer = bufferSource.getBuffer(RenderType.entityCutoutNoCull((ResourceLocation)this.LAYER_TEXTURE));
                    Modelbear model = new Modelbear(Minecraft.getInstance().getEntityModels().bakeLayer(Modelbear.LAYER_LOCATION));
                    model.setupAnim((EntityRenderState)state);
                    model.renderToBuffer(poseStack, vertexConsumer, light, LivingEntityRenderer.getOverlayCoords((LivingEntityRenderState)state, (float)0.0f));
                }
            }
        });
    }

    public LivingEntityRenderState createRenderState() {
        return new LivingEntityRenderState();
    }

    public void extractRenderState(BearEntity entity, LivingEntityRenderState state, float partialTicks) {
        super.extractRenderState((LivingEntity)entity, state, partialTicks);
        this.entity = entity;
    }

    public ResourceLocation getTextureLocation(LivingEntityRenderState state) {
        return ResourceLocation.parse((String)"toastysmobs:textures/entities/bear_texture.png");
    }

    protected void scale(LivingEntityRenderState state, PoseStack poseStack) {
        poseStack.scale(this.entity.getAgeScale(), this.entity.getAgeScale(), this.entity.getAgeScale());
    }
}

