/*
 * Decompiled with CFR 0.152.
 */
package toastysmobs.client.renderer;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.renderer.entity.state.LivingEntityRenderState;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import toastysmobs.client.model.ModelCrab;
import toastysmobs.client.model.animations.CrabAnimation;
import toastysmobs.client.model.animations.CrabAttackAnimation;
import toastysmobs.entity.CrabEntity;
import toastysmobs.procedures.CrabDisplayConditionBlueProcedure;

public class CrabRenderer
extends MobRenderer<CrabEntity, LivingEntityRenderState, ModelCrab> {
    private CrabEntity entity = null;

    public CrabRenderer(EntityRendererProvider.Context context) {
        super(context, (EntityModel)new AnimatedModel(context.bakeLayer(ModelCrab.LAYER_LOCATION)), 0.5f);
        this.addLayer((RenderLayer)new RenderLayer<LivingEntityRenderState, ModelCrab>((RenderLayerParent)this){
            final ResourceLocation LAYER_TEXTURE;
            {
                this.LAYER_TEXTURE = ResourceLocation.parse((String)"toastysmobs:textures/entities/blue.png");
            }

            public void render(PoseStack poseStack, MultiBufferSource bufferSource, int light, LivingEntityRenderState state, float headYaw, float headPitch) {
                Level world = CrabRenderer.this.entity.level();
                double x = CrabRenderer.this.entity.getX();
                double y = CrabRenderer.this.entity.getY();
                double z = CrabRenderer.this.entity.getZ();
                if (CrabDisplayConditionBlueProcedure.execute((Entity)CrabRenderer.this.entity)) {
                    VertexConsumer vertexConsumer = bufferSource.getBuffer(RenderType.entityCutoutNoCull((ResourceLocation)this.LAYER_TEXTURE));
                    ((ModelCrab)this.getParentModel()).renderToBuffer(poseStack, vertexConsumer, light, LivingEntityRenderer.getOverlayCoords((LivingEntityRenderState)state, (float)0.0f));
                }
            }
        });
    }

    public LivingEntityRenderState createRenderState() {
        return new LivingEntityRenderState();
    }

    public void extractRenderState(CrabEntity entity, LivingEntityRenderState state, float partialTicks) {
        super.extractRenderState((LivingEntity)entity, state, partialTicks);
        this.entity = entity;
        if (this.model instanceof AnimatedModel) {
            ((AnimatedModel)this.model).setEntity(entity);
        }
    }

    public ResourceLocation getTextureLocation(LivingEntityRenderState state) {
        return ResourceLocation.parse((String)"toastysmobs:textures/entities/crab_texture.png");
    }

    protected void scale(LivingEntityRenderState state, PoseStack poseStack) {
        poseStack.scale(0.9f, 0.9f, 0.9f);
        poseStack.scale(this.entity.getAgeScale(), this.entity.getAgeScale(), this.entity.getAgeScale());
    }

    private static final class AnimatedModel
    extends ModelCrab {
        private CrabEntity entity = null;

        public AnimatedModel(ModelPart root) {
            super(root);
        }

        public void setEntity(CrabEntity entity) {
            this.entity = entity;
        }

        @Override
        public void setupAnim(LivingEntityRenderState state) {
            this.root().getAllParts().forEach(ModelPart::resetPose);
            this.animate(this.entity.animationState0, CrabAnimation.walk, state.ageInTicks, 1.0f);
            this.animate(this.entity.animationState1, CrabAttackAnimation.crabattack, state.ageInTicks, 1.0f);
            super.setupAnim(state);
        }
    }
}

