/*
 * Decompiled with CFR 0.152.
 */
package toastysmobs.client.renderer;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.renderer.entity.state.LivingEntityRenderState;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import toastysmobs.client.model.Modelduck;
import toastysmobs.entity.DuckEntity;
import toastysmobs.procedures.DuckDisplayConditionProcedure;

public class DuckRenderer
extends MobRenderer<DuckEntity, LivingEntityRenderState, Modelduck> {
    private DuckEntity entity = null;

    public DuckRenderer(EntityRendererProvider.Context context) {
        super(context, (EntityModel)new Modelduck(context.bakeLayer(Modelduck.LAYER_LOCATION)), 0.5f);
        this.addLayer((RenderLayer)new RenderLayer<LivingEntityRenderState, Modelduck>((RenderLayerParent)this){
            final ResourceLocation LAYER_TEXTURE;
            {
                this.LAYER_TEXTURE = ResourceLocation.parse((String)"toastysmobs:textures/entities/duckling_texture_fix.png");
            }

            public void render(PoseStack poseStack, MultiBufferSource bufferSource, int light, LivingEntityRenderState state, float headYaw, float headPitch) {
                Level world = DuckRenderer.this.entity.level();
                double x = DuckRenderer.this.entity.getX();
                double y = DuckRenderer.this.entity.getY();
                double z = DuckRenderer.this.entity.getZ();
                if (DuckDisplayConditionProcedure.execute((Entity)DuckRenderer.this.entity)) {
                    VertexConsumer vertexConsumer = bufferSource.getBuffer(RenderType.entityCutoutNoCull((ResourceLocation)this.LAYER_TEXTURE));
                    ((Modelduck)this.getParentModel()).renderToBuffer(poseStack, vertexConsumer, light, LivingEntityRenderer.getOverlayCoords((LivingEntityRenderState)state, (float)0.0f));
                }
            }
        });
    }

    public LivingEntityRenderState createRenderState() {
        return new LivingEntityRenderState();
    }

    public void extractRenderState(DuckEntity entity, LivingEntityRenderState state, float partialTicks) {
        super.extractRenderState((LivingEntity)entity, state, partialTicks);
        this.entity = entity;
    }

    public ResourceLocation getTextureLocation(LivingEntityRenderState state) {
        return ResourceLocation.parse((String)"toastysmobs:textures/entities/duck_texture.png");
    }

    protected void scale(LivingEntityRenderState state, PoseStack poseStack) {
        poseStack.scale(this.entity.getAgeScale(), this.entity.getAgeScale(), this.entity.getAgeScale());
    }
}

