/*
 * Decompiled with CFR 0.152.
 */
package toastysmobs.client.renderer;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.renderer.entity.state.LivingEntityRenderState;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import toastysmobs.client.model.Modelpigeon;
import toastysmobs.client.model.animations.pigeonAnimation;
import toastysmobs.entity.PigeonEntity;
import toastysmobs.procedures.PigeonDisplayCondition2Procedure;
import toastysmobs.procedures.PigeonDisplayCondition3Procedure;
import toastysmobs.procedures.PigeonDisplayConditionProcedure;

public class PigeonRenderer
extends MobRenderer<PigeonEntity, LivingEntityRenderState, Modelpigeon> {
    private PigeonEntity entity = null;

    public PigeonRenderer(EntityRendererProvider.Context context) {
        super(context, (EntityModel)new AnimatedModel(context.bakeLayer(Modelpigeon.LAYER_LOCATION)), 0.4f);
        this.addLayer((RenderLayer)new RenderLayer<LivingEntityRenderState, Modelpigeon>((RenderLayerParent)this){
            final ResourceLocation LAYER_TEXTURE;
            {
                this.LAYER_TEXTURE = ResourceLocation.parse((String)"toastysmobs:textures/entities/pigeon_texture.png");
            }

            public void render(PoseStack poseStack, MultiBufferSource bufferSource, int light, LivingEntityRenderState state, float headYaw, float headPitch) {
                Level world = PigeonRenderer.this.entity.level();
                double x = PigeonRenderer.this.entity.getX();
                double y = PigeonRenderer.this.entity.getY();
                double z = PigeonRenderer.this.entity.getZ();
                if (PigeonDisplayConditionProcedure.execute((Entity)PigeonRenderer.this.entity)) {
                    VertexConsumer vertexConsumer = bufferSource.getBuffer(RenderType.entityCutoutNoCull((ResourceLocation)this.LAYER_TEXTURE));
                    ((Modelpigeon)this.getParentModel()).renderToBuffer(poseStack, vertexConsumer, light, LivingEntityRenderer.getOverlayCoords((LivingEntityRenderState)state, (float)0.0f));
                }
            }
        });
        this.addLayer((RenderLayer)new RenderLayer<LivingEntityRenderState, Modelpigeon>((RenderLayerParent)this){
            final ResourceLocation LAYER_TEXTURE;
            {
                this.LAYER_TEXTURE = ResourceLocation.parse((String)"toastysmobs:textures/entities/pigeon_1_texture.png");
            }

            public void render(PoseStack poseStack, MultiBufferSource bufferSource, int light, LivingEntityRenderState state, float headYaw, float headPitch) {
                Level world = PigeonRenderer.this.entity.level();
                double x = PigeonRenderer.this.entity.getX();
                double y = PigeonRenderer.this.entity.getY();
                double z = PigeonRenderer.this.entity.getZ();
                if (PigeonDisplayCondition2Procedure.execute((Entity)PigeonRenderer.this.entity)) {
                    VertexConsumer vertexConsumer = bufferSource.getBuffer(RenderType.entityCutoutNoCull((ResourceLocation)this.LAYER_TEXTURE));
                    ((Modelpigeon)this.getParentModel()).renderToBuffer(poseStack, vertexConsumer, light, LivingEntityRenderer.getOverlayCoords((LivingEntityRenderState)state, (float)0.0f));
                }
            }
        });
        this.addLayer((RenderLayer)new RenderLayer<LivingEntityRenderState, Modelpigeon>((RenderLayerParent)this){
            final ResourceLocation LAYER_TEXTURE;
            {
                this.LAYER_TEXTURE = ResourceLocation.parse((String)"toastysmobs:textures/entities/pigeon_3_texture.png");
            }

            public void render(PoseStack poseStack, MultiBufferSource bufferSource, int light, LivingEntityRenderState state, float headYaw, float headPitch) {
                Level world = PigeonRenderer.this.entity.level();
                double x = PigeonRenderer.this.entity.getX();
                double y = PigeonRenderer.this.entity.getY();
                double z = PigeonRenderer.this.entity.getZ();
                if (PigeonDisplayCondition3Procedure.execute((Entity)PigeonRenderer.this.entity)) {
                    VertexConsumer vertexConsumer = bufferSource.getBuffer(RenderType.entityCutoutNoCull((ResourceLocation)this.LAYER_TEXTURE));
                    ((Modelpigeon)this.getParentModel()).renderToBuffer(poseStack, vertexConsumer, light, LivingEntityRenderer.getOverlayCoords((LivingEntityRenderState)state, (float)0.0f));
                }
            }
        });
    }

    public LivingEntityRenderState createRenderState() {
        return new LivingEntityRenderState();
    }

    public void extractRenderState(PigeonEntity entity, LivingEntityRenderState state, float partialTicks) {
        super.extractRenderState((LivingEntity)entity, state, partialTicks);
        this.entity = entity;
        if (this.model instanceof AnimatedModel) {
            ((AnimatedModel)this.model).setEntity(entity);
        }
    }

    public ResourceLocation getTextureLocation(LivingEntityRenderState state) {
        return ResourceLocation.parse((String)"toastysmobs:textures/entities/pigeon_texture.png");
    }

    protected void scale(LivingEntityRenderState state, PoseStack poseStack) {
        poseStack.scale(this.entity.getAgeScale(), this.entity.getAgeScale(), this.entity.getAgeScale());
    }

    private static final class AnimatedModel
    extends Modelpigeon {
        private PigeonEntity entity = null;

        public AnimatedModel(ModelPart root) {
            super(root);
        }

        public void setEntity(PigeonEntity entity) {
            this.entity = entity;
        }

        @Override
        public void setupAnim(LivingEntityRenderState state) {
            this.root().getAllParts().forEach(ModelPart::resetPose);
            this.animate(this.entity.animationState0, pigeonAnimation.fly, state.ageInTicks, 1.0f);
            super.setupAnim(state);
        }
    }
}

