/*
 * Decompiled with CFR 0.152.
 */
package toastysmobs.init;

import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.EntityAttributeCreationEvent;
import net.neoforged.neoforge.event.entity.RegisterSpawnPlacementsEvent;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredRegister;
import toastysmobs.entity.BearEntity;
import toastysmobs.entity.BlueFootedBoobyEntity;
import toastysmobs.entity.ButterflyEntity;
import toastysmobs.entity.CaterpillarEntity;
import toastysmobs.entity.CrabEntity;
import toastysmobs.entity.DoDoEntity;
import toastysmobs.entity.DuckEntity;
import toastysmobs.entity.EndlingEntity;
import toastysmobs.entity.OkapiEntity;
import toastysmobs.entity.PigeonEntity;
import toastysmobs.entity.SeaHareEntity;
import toastysmobs.entity.SnailEntity;

@EventBusSubscriber(bus=EventBusSubscriber.Bus.MOD)
public class ToastysmobsModEntities {
    public static final DeferredRegister<EntityType<?>> REGISTRY = DeferredRegister.create((ResourceKey)Registries.ENTITY_TYPE, (String)"toastysmobs");
    public static final DeferredHolder<EntityType<?>, EntityType<BearEntity>> BEAR = ToastysmobsModEntities.register("bear", EntityType.Builder.of(BearEntity::new, (MobCategory)MobCategory.CREATURE).setShouldReceiveVelocityUpdates(true).setTrackingRange(64).setUpdateInterval(3).sized(0.6f, 1.8f));
    public static final DeferredHolder<EntityType<?>, EntityType<CrabEntity>> CRAB = ToastysmobsModEntities.register("crab", EntityType.Builder.of(CrabEntity::new, (MobCategory)MobCategory.AMBIENT).setShouldReceiveVelocityUpdates(true).setTrackingRange(64).setUpdateInterval(3).sized(0.6f, 1.8f));
    public static final DeferredHolder<EntityType<?>, EntityType<SeaHareEntity>> SEA_HARE = ToastysmobsModEntities.register("sea_hare", EntityType.Builder.of(SeaHareEntity::new, (MobCategory)MobCategory.WATER_CREATURE).setShouldReceiveVelocityUpdates(true).setTrackingRange(64).setUpdateInterval(3).sized(0.6f, 1.8f));
    public static final DeferredHolder<EntityType<?>, EntityType<OkapiEntity>> OKAPI = ToastysmobsModEntities.register("okapi", EntityType.Builder.of(OkapiEntity::new, (MobCategory)MobCategory.MONSTER).setShouldReceiveVelocityUpdates(true).setTrackingRange(64).setUpdateInterval(3).sized(0.6f, 1.8f));
    public static final DeferredHolder<EntityType<?>, EntityType<DuckEntity>> DUCK = ToastysmobsModEntities.register("duck", EntityType.Builder.of(DuckEntity::new, (MobCategory)MobCategory.CREATURE).setShouldReceiveVelocityUpdates(true).setTrackingRange(64).setUpdateInterval(3).sized(0.5f, 0.7f));
    public static final DeferredHolder<EntityType<?>, EntityType<DoDoEntity>> DO_DO = ToastysmobsModEntities.register("do_do", EntityType.Builder.of(DoDoEntity::new, (MobCategory)MobCategory.CREATURE).setShouldReceiveVelocityUpdates(true).setTrackingRange(64).setUpdateInterval(3).sized(0.6f, 1.8f));
    public static final DeferredHolder<EntityType<?>, EntityType<ButterflyEntity>> BUTTERFLY = ToastysmobsModEntities.register("butterfly", EntityType.Builder.of(ButterflyEntity::new, (MobCategory)MobCategory.CREATURE).setShouldReceiveVelocityUpdates(true).setTrackingRange(64).setUpdateInterval(3).sized(0.6f, 1.8f));
    public static final DeferredHolder<EntityType<?>, EntityType<PigeonEntity>> PIGEON = ToastysmobsModEntities.register("pigeon", EntityType.Builder.of(PigeonEntity::new, (MobCategory)MobCategory.CREATURE).setShouldReceiveVelocityUpdates(true).setTrackingRange(64).setUpdateInterval(3).sized(0.4f, 0.4f));
    public static final DeferredHolder<EntityType<?>, EntityType<BlueFootedBoobyEntity>> BLUE_FOOTED_BOOBY = ToastysmobsModEntities.register("blue_footed_booby", EntityType.Builder.of(BlueFootedBoobyEntity::new, (MobCategory)MobCategory.CREATURE).setShouldReceiveVelocityUpdates(true).setTrackingRange(64).setUpdateInterval(3).sized(0.6f, 0.6f));
    public static final DeferredHolder<EntityType<?>, EntityType<CaterpillarEntity>> CATERPILLAR = ToastysmobsModEntities.register("caterpillar", EntityType.Builder.of(CaterpillarEntity::new, (MobCategory)MobCategory.CREATURE).setShouldReceiveVelocityUpdates(true).setTrackingRange(64).setUpdateInterval(3).sized(0.3f, 0.3f));
    public static final DeferredHolder<EntityType<?>, EntityType<EndlingEntity>> ENDLING = ToastysmobsModEntities.register("endling", EntityType.Builder.of(EndlingEntity::new, (MobCategory)MobCategory.MONSTER).setShouldReceiveVelocityUpdates(true).setTrackingRange(64).setUpdateInterval(3).sized(0.6f, 0.8f));
    public static final DeferredHolder<EntityType<?>, EntityType<SnailEntity>> SNAIL = ToastysmobsModEntities.register("snail", EntityType.Builder.of(SnailEntity::new, (MobCategory)MobCategory.CREATURE).setShouldReceiveVelocityUpdates(true).setTrackingRange(64).setUpdateInterval(3).sized(0.3f, 0.3f));

    private static <T extends Entity> DeferredHolder<EntityType<?>, EntityType<T>> register(String registryname, EntityType.Builder<T> entityTypeBuilder) {
        return REGISTRY.register(registryname, () -> entityTypeBuilder.build(ResourceKey.create((ResourceKey)Registries.ENTITY_TYPE, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"toastysmobs", (String)registryname))));
    }

    @SubscribeEvent
    public static void init(RegisterSpawnPlacementsEvent event) {
        BearEntity.init(event);
        CrabEntity.init(event);
        SeaHareEntity.init(event);
        OkapiEntity.init(event);
        DuckEntity.init(event);
        DoDoEntity.init(event);
        ButterflyEntity.init(event);
        PigeonEntity.init(event);
        BlueFootedBoobyEntity.init(event);
        CaterpillarEntity.init(event);
        EndlingEntity.init(event);
        SnailEntity.init(event);
    }

    @SubscribeEvent
    public static void registerAttributes(EntityAttributeCreationEvent event) {
        event.put((EntityType)BEAR.get(), BearEntity.createAttributes().build());
        event.put((EntityType)CRAB.get(), CrabEntity.createAttributes().build());
        event.put((EntityType)SEA_HARE.get(), SeaHareEntity.createAttributes().build());
        event.put((EntityType)OKAPI.get(), OkapiEntity.createAttributes().build());
        event.put((EntityType)DUCK.get(), DuckEntity.createAttributes().build());
        event.put((EntityType)DO_DO.get(), DoDoEntity.createAttributes().build());
        event.put((EntityType)BUTTERFLY.get(), ButterflyEntity.createAttributes().build());
        event.put((EntityType)PIGEON.get(), PigeonEntity.createAttributes().build());
        event.put((EntityType)BLUE_FOOTED_BOOBY.get(), BlueFootedBoobyEntity.createAttributes().build());
        event.put((EntityType)CATERPILLAR.get(), CaterpillarEntity.createAttributes().build());
        event.put((EntityType)ENDLING.get(), EndlingEntity.createAttributes().build());
        event.put((EntityType)SNAIL.get(), SnailEntity.createAttributes().build());
    }
}

