/*
 * Decompiled with CFR 0.152.
 */
package toastysmobs.client.model;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;

public class Modelbobby<T extends Entity>
extends EntityModel<T> {
    public static final ModelLayerLocation LAYER_LOCATION = new ModelLayerLocation(ResourceLocation.fromNamespaceAndPath((String)"toastysmobs", (String)"modelbobby"), "main");
    public final ModelPart bone;
    public final ModelPart body;
    public final ModelPart right_leg;
    public final ModelPart head;
    public final ModelPart right_wing;
    public final ModelPart left_leg;
    public final ModelPart left_wing;
    public final ModelPart tail;

    public Modelbobby(ModelPart root) {
        this.bone = root.getChild("bone");
        this.body = this.bone.getChild("body");
        this.right_leg = this.body.getChild("right_leg");
        this.head = this.body.getChild("head");
        this.right_wing = this.body.getChild("right_wing");
        this.left_leg = this.body.getChild("left_leg");
        this.left_wing = this.body.getChild("left_wing");
        this.tail = this.body.getChild("tail");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        PartDefinition bone = partdefinition.addOrReplaceChild("bone", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)24.0f, (float)0.0f));
        PartDefinition body = bone.addOrReplaceChild("body", CubeListBuilder.create().texOffs(0, 0).addBox(-3.0f, -4.0f, -3.0f, 6.0f, 7.0f, 10.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)-7.0f, (float)-2.0f));
        PartDefinition right_leg = body.addOrReplaceChild("right_leg", CubeListBuilder.create().texOffs(16, 41).addBox(-1.0f, 1.0f, -3.0f, 3.0f, 4.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.offset((float)-2.0f, (float)2.0f, (float)3.0f));
        PartDefinition head = body.addOrReplaceChild("head", CubeListBuilder.create().texOffs(0, 29).addBox(-2.0f, -7.0f, -2.0f, 4.0f, 9.0f, 4.0f, new CubeDeformation(0.0f)).texOffs(32, 10).addBox(-1.0f, -6.0f, -7.0f, 2.0f, 2.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)-2.0f, (float)-3.0f));
        PartDefinition right_wing = body.addOrReplaceChild("right_wing", CubeListBuilder.create().texOffs(0, 17).addBox(-1.0f, 0.0f, -1.0f, 2.0f, 5.0f, 7.0f, new CubeDeformation(0.0f)).texOffs(32, 29).addBox(-1.0f, 0.0f, 6.0f, 1.0f, 5.0f, 7.0f, new CubeDeformation(0.0f)), PartPose.offset((float)-4.0f, (float)-3.0f, (float)-2.0f));
        PartDefinition left_leg = body.addOrReplaceChild("left_leg", CubeListBuilder.create().texOffs(36, 17).addBox(-1.0f, 1.0f, -3.0f, 3.0f, 4.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.offset((float)1.0f, (float)2.0f, (float)3.0f));
        PartDefinition left_wing = body.addOrReplaceChild("left_wing", CubeListBuilder.create().texOffs(16, 29).addBox(0.0f, 0.0f, 6.0f, 1.0f, 5.0f, 7.0f, new CubeDeformation(0.0f)).texOffs(18, 17).addBox(-1.0f, 0.0f, -1.0f, 2.0f, 5.0f, 7.0f, new CubeDeformation(0.0f)), PartPose.offset((float)4.0f, (float)-3.0f, (float)-2.0f));
        PartDefinition tail = body.addOrReplaceChild("tail", CubeListBuilder.create().texOffs(32, 0).addBox(-1.0f, -1.0f, -2.0f, 2.0f, 3.0f, 7.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)-4.0f, (float)6.0f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)64, (int)64);
    }

    public void renderToBuffer(PoseStack poseStack, VertexConsumer vertexConsumer, int packedLight, int packedOverlay, int rgb) {
        this.bone.render(poseStack, vertexConsumer, packedLight, packedOverlay, rgb);
    }

    public void setupAnim(T entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.head.yRot = netHeadYaw / 57.295776f;
        this.head.xRot = headPitch / 57.295776f;
        this.left_leg.xRot = Mth.cos((float)(limbSwing * 1.0f)) * -1.0f * limbSwingAmount;
        this.right_leg.xRot = Mth.cos((float)(limbSwing * 1.0f)) * 1.0f * limbSwingAmount;
    }
}

