/*
 * Decompiled with CFR 0.152.
 */
package toastysmobs.client.renderer;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.HierarchicalModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import toastysmobs.client.model.ModelCrab;
import toastysmobs.client.model.animations.CrabAnimation;
import toastysmobs.client.model.animations.CrabAttackAnimation;
import toastysmobs.entity.CrabEntity;
import toastysmobs.procedures.CrabDisplayConditionBlueProcedure;

public class CrabRenderer
extends MobRenderer<CrabEntity, ModelCrab<CrabEntity>> {
    public CrabRenderer(EntityRendererProvider.Context context) {
        super(context, (EntityModel)new AnimatedModel(context.bakeLayer(ModelCrab.LAYER_LOCATION)), 0.5f);
        this.addLayer((RenderLayer)new RenderLayer<CrabEntity, ModelCrab<CrabEntity>>(this, (RenderLayerParent)this){
            final ResourceLocation LAYER_TEXTURE = ResourceLocation.parse((String)"toastysmobs:textures/entities/blue.png");

            public void render(PoseStack poseStack, MultiBufferSource bufferSource, int light, CrabEntity entity, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
                Level world = entity.level();
                double x = entity.getX();
                double y = entity.getY();
                double z = entity.getZ();
                if (CrabDisplayConditionBlueProcedure.execute((Entity)entity)) {
                    VertexConsumer vertexConsumer = bufferSource.getBuffer(RenderType.entityCutoutNoCull((ResourceLocation)this.LAYER_TEXTURE));
                    ((ModelCrab)this.getParentModel()).renderToBuffer(poseStack, vertexConsumer, light, LivingEntityRenderer.getOverlayCoords((LivingEntity)entity, (float)0.0f));
                }
            }
        });
    }

    protected void scale(CrabEntity entity, PoseStack poseStack, float f) {
        poseStack.scale(0.9f, 0.9f, 0.9f);
        poseStack.scale(entity.getAgeScale(), entity.getAgeScale(), entity.getAgeScale());
    }

    public ResourceLocation getTextureLocation(CrabEntity entity) {
        return ResourceLocation.parse((String)"toastysmobs:textures/entities/crab_texture.png");
    }

    private static final class AnimatedModel
    extends ModelCrab<CrabEntity> {
        private final ModelPart root;
        private final HierarchicalModel animator = new HierarchicalModel<CrabEntity>(){

            public ModelPart root() {
                return root;
            }

            public void setupAnim(CrabEntity entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
                this.root().getAllParts().forEach(ModelPart::resetPose);
                this.animate(entity.animationState0, CrabAnimation.walk, ageInTicks, 1.0f);
                this.animate(entity.animationState1, CrabAttackAnimation.crabattack, ageInTicks, 1.0f);
            }
        };

        public AnimatedModel(ModelPart root) {
            super(root);
            this.root = root;
        }

        @Override
        public void setupAnim(CrabEntity entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
            this.animator.setupAnim((Entity)entity, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
            super.setupAnim(entity, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
        }
    }
}

