/*
 * Decompiled with CFR 0.152.
 */
package toastysmobs.client.renderer;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import toastysmobs.client.model.ModelEndling;
import toastysmobs.client.model.ModelEndlingChest;
import toastysmobs.entity.EndlingEntity;

public class EndlingRenderer
extends MobRenderer<EndlingEntity, ModelEndling<EndlingEntity>> {
    public EndlingRenderer(EntityRendererProvider.Context context) {
        super(context, new ModelEndling(context.bakeLayer(ModelEndling.LAYER_LOCATION)), 0.6f);
        this.addLayer((RenderLayer)new RenderLayer<EndlingEntity, ModelEndling<EndlingEntity>>(this, (RenderLayerParent)this){
            final ResourceLocation LAYER_TEXTURE = ResourceLocation.parse((String)"toastysmobs:textures/entities/endlingoverlay.png");

            public void render(PoseStack poseStack, MultiBufferSource bufferSource, int light, EndlingEntity entity, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
                VertexConsumer vertexConsumer = bufferSource.getBuffer(RenderType.eyes((ResourceLocation)this.LAYER_TEXTURE));
                ((ModelEndling)this.getParentModel()).renderToBuffer(poseStack, vertexConsumer, light, LivingEntityRenderer.getOverlayCoords((LivingEntity)entity, (float)0.0f));
            }
        });
        this.addLayer((RenderLayer)new RenderLayer<EndlingEntity, ModelEndling<EndlingEntity>>(this, (RenderLayerParent)this){
            final ResourceLocation LAYER_TEXTURE = ResourceLocation.parse((String)"toastysmobs:textures/entities/endlingenderchest.png");

            public void render(PoseStack poseStack, MultiBufferSource bufferSource, int light, EndlingEntity entity, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
                VertexConsumer vertexConsumer = bufferSource.getBuffer(RenderType.entityCutoutNoCull((ResourceLocation)this.LAYER_TEXTURE));
                ModelEndlingChest model = new ModelEndlingChest(Minecraft.getInstance().getEntityModels().bakeLayer(ModelEndlingChest.LAYER_LOCATION));
                ((ModelEndling)this.getParentModel()).copyPropertiesTo(model);
                model.prepareMobModel((Entity)entity, limbSwing, limbSwingAmount, partialTicks);
                model.setupAnim((Entity)entity, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
                model.renderToBuffer(poseStack, vertexConsumer, light, LivingEntityRenderer.getOverlayCoords((LivingEntity)entity, (float)0.0f));
            }
        });
    }

    public ResourceLocation getTextureLocation(EndlingEntity entity) {
        return ResourceLocation.parse((String)"toastysmobs:textures/entities/endlingtexture.png");
    }
}

