/*
 * Decompiled with CFR 0.152.
 */
package com.crabmods.instantworldmirror;

import com.crabmods.instantworldmirror.MirrorConfig;
import com.crabmods.instantworldmirror.client.ClientConfig;
import com.crabmods.instantworldmirror.entity.ModEntities;
import com.crabmods.instantworldmirror.registry.ModBlocks;
import com.crabmods.instantworldmirror.registry.ModChunkGenerators;
import com.crabmods.instantworldmirror.registry.ModCreativeTabs;
import com.crabmods.instantworldmirror.registry.ModItems;
import com.crabmods.instantworldmirror.world.DimensionPool;
import com.crabmods.instantworldmirror.world.ModDimensions;
import com.mojang.logging.LogUtils;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.config.IConfigSpec;
import net.neoforged.fml.config.ModConfig;
import net.neoforged.fml.event.lifecycle.FMLCommonSetupEvent;
import net.neoforged.fml.loading.FMLEnvironment;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.server.ServerStartingEvent;
import org.slf4j.Logger;

@Mod(value="instantworldmirror")
public class InstantWorldMirror {
    public static final String MODID = "instantworldmirror";
    public static final Logger LOGGER = LogUtils.getLogger();

    public InstantWorldMirror(IEventBus modEventBus, ModContainer modContainer) {
        modEventBus.addListener(this::commonSetup);
        ModItems.ITEMS.register(modEventBus);
        ModBlocks.BLOCKS.register(modEventBus);
        ModBlocks.BLOCK_ENTITIES.register(modEventBus);
        ModCreativeTabs.CREATIVE_MODE_TABS.register(modEventBus);
        ModChunkGenerators.CHUNK_GENERATORS.register(modEventBus);
        ModEntities.ENTITY_TYPES.register(modEventBus);
        NeoForge.EVENT_BUS.register((Object)this);
        modContainer.registerConfig(ModConfig.Type.COMMON, (IConfigSpec)MirrorConfig.SPEC);
        if (FMLEnvironment.dist == Dist.CLIENT) {
            modContainer.registerConfig(ModConfig.Type.CLIENT, (IConfigSpec)ClientConfig.SPEC);
        }
    }

    private void commonSetup(FMLCommonSetupEvent event) {
        LOGGER.info("InstantWorldMirror - Common Setup");
        event.enqueueWork(() -> {
            ModDimensions.updatePoolSizeFromConfig();
            DimensionPool.initialize();
        });
    }

    @SubscribeEvent
    public void onServerStarting(ServerStartingEvent event) {
        LOGGER.info("InstantWorldMirror - Server Starting");
        ModDimensions.updatePoolSizeFromConfig();
        DimensionPool.initializeWithServer(event.getServer());
    }
}

