/*
 * Decompiled with CFR 0.152.
 */
package com.crabmods.instantworldmirror.block;

import com.crabmods.instantworldmirror.InstantWorldMirror;
import com.crabmods.instantworldmirror.registry.ModBlocks;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;

public class PortalLightBlockEntity
extends BlockEntity {
    private UUID portalEntityId = null;
    private int checkCounter = 0;
    private static final int CHECK_INTERVAL = 10;
    private int orphanTickCounter = 0;
    private static final int ORPHAN_GRACE_PERIOD = 100;
    private static final int MAX_ORPHAN_TICKS = 600;

    public PortalLightBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)ModBlocks.PORTAL_LIGHT_BLOCK_ENTITY.get(), pos, state);
    }

    public void setPortalEntityId(UUID portalId) {
        this.portalEntityId = portalId;
        this.orphanTickCounter = 0;
        this.setChanged();
    }

    public UUID getPortalEntityId() {
        return this.portalEntityId;
    }

    public static void serverTick(Level level, BlockPos pos, BlockState state, PortalLightBlockEntity blockEntity) {
        ++blockEntity.checkCounter;
        if (blockEntity.checkCounter < 10) {
            return;
        }
        blockEntity.checkCounter = 0;
        if (blockEntity.portalEntityId == null) {
            blockEntity.orphanTickCounter += 10;
            if (blockEntity.orphanTickCounter < 100) {
                return;
            }
            InstantWorldMirror.LOGGER.debug("Portal light block at {} has no bound portal after grace period, removing", (Object)pos);
            PortalLightBlockEntity.removeSelf(level, pos);
            return;
        }
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            Entity portalEntity = serverLevel.getEntity(blockEntity.portalEntityId);
            if (portalEntity == null || !portalEntity.isAlive()) {
                blockEntity.orphanTickCounter += 10;
                if (blockEntity.orphanTickCounter >= 600) {
                    InstantWorldMirror.LOGGER.debug("Portal entity {} no longer exists for {} ticks, removing light block at {}", new Object[]{blockEntity.portalEntityId, blockEntity.orphanTickCounter, pos});
                    PortalLightBlockEntity.removeSelf(level, pos);
                }
            } else {
                blockEntity.orphanTickCounter = 0;
            }
        }
    }

    private static void removeSelf(Level level, BlockPos pos) {
        level.setBlockAndUpdate(pos, Blocks.AIR.defaultBlockState());
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            serverLevel.getChunkSource().blockChanged(pos);
        }
    }

    protected void saveAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.saveAdditional(tag, registries);
        if (this.portalEntityId != null) {
            tag.putUUID("PortalEntityId", this.portalEntityId);
        }
        tag.putInt("OrphanTickCounter", this.orphanTickCounter);
    }

    protected void loadAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.loadAdditional(tag, registries);
        if (tag.hasUUID("PortalEntityId")) {
            this.portalEntityId = tag.getUUID("PortalEntityId");
        }
        if (tag.contains("OrphanTickCounter")) {
            this.orphanTickCounter = tag.getInt("OrphanTickCounter");
        }
    }
}

