/*
 * Decompiled with CFR 0.152.
 */
package com.crabmods.instantworldmirror.client;

import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class ClientCooldownTracker {
    private static long cooldownEndTimestamp = 0L;
    private static long totalCooldownMillis = 0L;

    @Deprecated
    public static void setCooldownEndTimestamp(long timestamp) {
        cooldownEndTimestamp = timestamp;
    }

    public static void setCooldown(long endTimestamp, long totalMillis) {
        cooldownEndTimestamp = endTimestamp;
        totalCooldownMillis = totalMillis;
    }

    public static long getTotalCooldownMillis() {
        return totalCooldownMillis;
    }

    public static long getRemainingCooldownMillis() {
        if (cooldownEndTimestamp == 0L) {
            return 0L;
        }
        long remaining = cooldownEndTimestamp - System.currentTimeMillis();
        if (remaining <= 0L) {
            cooldownEndTimestamp = 0L;
            return 0L;
        }
        return remaining;
    }

    public static boolean hasCooldown() {
        return ClientCooldownTracker.getRemainingCooldownMillis() > 0L;
    }

    public static void clear() {
        cooldownEndTimestamp = 0L;
        totalCooldownMillis = 0L;
    }

    public static String formatRemainingTime() {
        long millisLeft = ClientCooldownTracker.getRemainingCooldownMillis();
        if (millisLeft <= 0L) {
            return null;
        }
        long secondsLeft = millisLeft / 1000L;
        long minutesLeft = secondsLeft / 60L;
        return String.format("%02d:%02d", minutesLeft, secondsLeft %= 60L);
    }
}

