/*
 * Decompiled with CFR 0.152.
 */
package com.crabmods.instantworldmirror.client;

import com.crabmods.instantworldmirror.InstantWorldMirror;
import com.crabmods.instantworldmirror.client.CooldownHudOverlay;
import com.crabmods.instantworldmirror.client.CooldownItemDecorator;
import com.crabmods.instantworldmirror.client.model.MirrorPortalModel;
import com.crabmods.instantworldmirror.client.renderer.MirrorPortalRenderer;
import com.crabmods.instantworldmirror.entity.ModEntities;
import com.crabmods.instantworldmirror.registry.ModItems;
import net.minecraft.client.gui.LayeredDraw;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.ItemLike;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.client.IItemDecorator;
import net.neoforged.neoforge.client.event.EntityRenderersEvent;
import net.neoforged.neoforge.client.event.RegisterGuiLayersEvent;
import net.neoforged.neoforge.client.event.RegisterItemDecorationsEvent;
import net.neoforged.neoforge.client.gui.VanillaGuiLayers;

@EventBusSubscriber(modid="instantworldmirror", bus=EventBusSubscriber.Bus.MOD, value={Dist.CLIENT})
public class ClientEvents {
    @SubscribeEvent
    public static void registerEntityRenderers(EntityRenderersEvent.RegisterRenderers event) {
        event.registerEntityRenderer((EntityType)ModEntities.MIRROR_PORTAL.get(), MirrorPortalRenderer::new);
        InstantWorldMirror.LOGGER.info("Mirror Portal renderer registered");
    }

    @SubscribeEvent
    public static void registerLayerDefinitions(EntityRenderersEvent.RegisterLayerDefinitions event) {
        event.registerLayerDefinition(MirrorPortalModel.LAYER_LOCATION, MirrorPortalModel::createBodyLayer);
        InstantWorldMirror.LOGGER.info("Mirror Portal model layer registered");
    }

    @SubscribeEvent
    public static void registerGuiLayers(RegisterGuiLayersEvent event) {
        event.registerAbove(VanillaGuiLayers.HOTBAR, CooldownHudOverlay.OVERLAY_ID, (LayeredDraw.Layer)new CooldownHudOverlay());
        InstantWorldMirror.LOGGER.info("Cooldown HUD overlay registered");
    }

    @SubscribeEvent
    public static void registerItemDecorations(RegisterItemDecorationsEvent event) {
        event.register((ItemLike)ModItems.DIMENSION_MIRROR.get(), (IItemDecorator)new CooldownItemDecorator());
        InstantWorldMirror.LOGGER.info("Cooldown item decorator registered");
    }
}

