/*
 * Decompiled with CFR 0.152.
 */
package com.crabmods.instantworldmirror.client;

import com.crabmods.instantworldmirror.client.ClientConfig;
import com.crabmods.instantworldmirror.client.ClientCooldownTracker;
import com.crabmods.instantworldmirror.registry.ModItems;
import net.minecraft.client.DeltaTracker;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.LayeredDraw;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class CooldownHudOverlay
implements LayeredDraw.Layer {
    public static final ResourceLocation OVERLAY_ID = ResourceLocation.fromNamespaceAndPath((String)"instantworldmirror", (String)"cooldown_hud");
    private static final int TIMER_COLOR = -7807489;
    private static final int TIMER_SHADOW_COLOR = -14531482;
    private static final int OFFSET_X = 10;
    private static final int OFFSET_Y = 10;

    public void render(GuiGraphics guiGraphics, DeltaTracker deltaTracker) {
        if (!ClientConfig.shouldShowCooldownHud()) {
            return;
        }
        Minecraft mc = Minecraft.getInstance();
        LocalPlayer player = mc.player;
        if (player == null || player.isSpectator()) {
            return;
        }
        if (!this.hasModMirrorInInventory(player)) {
            return;
        }
        if (!ClientCooldownTracker.hasCooldown()) {
            return;
        }
        String timeText = ClientCooldownTracker.formatRemainingTime();
        if (timeText == null) {
            return;
        }
        Font font = mc.font;
        String displayText = "\u25c8 " + timeText;
        guiGraphics.drawString(font, displayText, 11, 11, -14531482, false);
        guiGraphics.drawString(font, displayText, 10, 10, -7807489, false);
    }

    private boolean hasModMirrorInInventory(LocalPlayer player) {
        for (int i = 0; i < player.getInventory().getContainerSize(); ++i) {
            ItemStack stack = player.getInventory().getItem(i);
            if (stack.isEmpty() || !stack.is((Item)ModItems.DIMENSION_MIRROR.get())) continue;
            return true;
        }
        ItemStack offhand = player.getOffhandItem();
        return !offhand.isEmpty() && offhand.is((Item)ModItems.DIMENSION_MIRROR.get());
    }
}

