/*
 * Decompiled with CFR 0.152.
 */
package com.crabmods.instantworldmirror.client;

import com.crabmods.instantworldmirror.client.ClientCooldownTracker;
import com.mojang.blaze3d.systems.RenderSystem;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.world.item.ItemStack;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.neoforge.client.IItemDecorator;

@OnlyIn(value=Dist.CLIENT)
public class CooldownItemDecorator
implements IItemDecorator {
    private static final int BAR_COLOR = -16724737;
    private static final int BAR_BG_COLOR = -16777216;

    public boolean render(GuiGraphics guiGraphics, Font font, ItemStack stack, int xOffset, int yOffset) {
        if (!ClientCooldownTracker.hasCooldown()) {
            return false;
        }
        long remainingMillis = ClientCooldownTracker.getRemainingCooldownMillis();
        long totalCooldownMillis = ClientCooldownTracker.getTotalCooldownMillis();
        if (remainingMillis <= 0L || totalCooldownMillis <= 0L) {
            return false;
        }
        float chargeProgress = 1.0f - Math.min(1.0f, (float)remainingMillis / (float)totalCooldownMillis);
        int barX = xOffset + 2;
        int barY = yOffset + 13;
        int barWidth = 13;
        guiGraphics.pose().pushPose();
        guiGraphics.pose().translate(0.0f, 0.0f, 200.0f);
        RenderSystem.disableDepthTest();
        guiGraphics.fill(barX, barY, barX + barWidth, barY + 2, -16777216);
        int filledWidth = Math.round((float)barWidth * chargeProgress);
        if (filledWidth > 0) {
            guiGraphics.fill(barX, barY, barX + filledWidth, barY + 1, -16724737);
        }
        RenderSystem.enableDepthTest();
        guiGraphics.pose().popPose();
        return true;
    }
}

