/*
 * Decompiled with CFR 0.152.
 */
package com.crabmods.instantworldmirror.client;

import com.crabmods.instantworldmirror.InstantWorldMirror;
import com.crabmods.instantworldmirror.world.ModDimensions;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.DimensionSpecialEffects;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.client.DimensionSpecialEffectsManager;

public class MirrorDimensionEffectsManager {
    private static final Map<Integer, ResourceLocation> mirrorToSourceEffects = new ConcurrentHashMap<Integer, ResourceLocation>();
    private static final Map<ResourceLocation, DimensionSpecialEffects> effectsCache = new ConcurrentHashMap<ResourceLocation, DimensionSpecialEffects>();

    public static void setSourceEffects(int mirrorDimIndex, ResourceLocation sourceEffects) {
        mirrorToSourceEffects.put(mirrorDimIndex, sourceEffects);
        InstantWorldMirror.LOGGER.debug("Set mirror dimension {} to use effects: {}", (Object)mirrorDimIndex, (Object)sourceEffects);
    }

    public static void clearSourceEffects(int mirrorDimIndex) {
        mirrorToSourceEffects.remove(mirrorDimIndex);
    }

    public static void clearAll() {
        mirrorToSourceEffects.clear();
        effectsCache.clear();
    }

    public static DimensionSpecialEffects getEffectsForLevel(ClientLevel level) {
        if (level == null) {
            return null;
        }
        ResourceKey dimension = level.dimension();
        int dimIndex = ModDimensions.getMirrorWorldIndex((ResourceKey<Level>)dimension);
        if (dimIndex < 0) {
            return null;
        }
        ResourceLocation sourceEffects = mirrorToSourceEffects.get(dimIndex);
        if (sourceEffects == null) {
            return null;
        }
        return MirrorDimensionEffectsManager.getOrCreateEffects(sourceEffects);
    }

    private static DimensionSpecialEffects getOrCreateEffects(ResourceLocation effectsKey) {
        return effectsCache.computeIfAbsent(effectsKey, key -> DimensionSpecialEffectsManager.getForType((ResourceLocation)key));
    }
}

