/*
 * Decompiled with CFR 0.152.
 */
package com.crabmods.instantworldmirror.client.renderer;

import com.crabmods.instantworldmirror.client.model.MirrorPortalModel;
import com.crabmods.instantworldmirror.entity.MirrorPortalEntity;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;

public class MirrorPortalRenderer
extends EntityRenderer<MirrorPortalEntity> {
    private static final ResourceLocation TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"instantworldmirror", (String)"textures/entity/mirror_portal.png");
    private final MirrorPortalModel model;

    public MirrorPortalRenderer(EntityRendererProvider.Context context) {
        super(context);
        this.model = new MirrorPortalModel(context.bakeLayer(MirrorPortalModel.LAYER_LOCATION));
    }

    public void render(MirrorPortalEntity entity, float entityYaw, float partialTicks, PoseStack poseStack, MultiBufferSource buffer, int packedLight) {
        poseStack.pushPose();
        float time = (float)entity.tickCount + partialTicks;
        float bob = (float)Math.sin((double)time * 0.1) * 0.1f;
        poseStack.translate(0.0, 1.0 + (double)bob, 0.0);
        boolean isLoading = entity.isLoading();
        if (isLoading) {
            float spinAngle = time * 10.0f;
            poseStack.mulPose(Axis.YP.rotationDegrees(spinAngle));
            float pulse = 1.0f + (float)Math.sin((double)time * 0.3) * 0.15f;
            poseStack.scale(pulse, pulse, pulse);
        } else {
            poseStack.mulPose(Axis.YP.rotationDegrees(-this.entityRenderDispatcher.camera.getYRot()));
        }
        float scale = 1.5f;
        poseStack.scale(scale, scale, scale);
        int lifetime = entity.getLifetime();
        float alpha = 1.0f;
        if (lifetime > 0 && lifetime < 40 && !isLoading) {
            alpha = lifetime % 10 >= 5 ? 0.5f : 1.0f;
        }
        int fullBright = 0xF000F0;
        VertexConsumer vertexConsumer = buffer.getBuffer(RenderType.entityTranslucent((ResourceLocation)TEXTURE));
        int color = (int)(alpha * 255.0f) << 24 | 0xFFFFFF;
        this.model.renderToBuffer(poseStack, vertexConsumer, fullBright, OverlayTexture.NO_OVERLAY, color);
        poseStack.popPose();
        super.render((Entity)entity, entityYaw, partialTicks, poseStack, buffer, packedLight);
    }

    public ResourceLocation getTextureLocation(MirrorPortalEntity entity) {
        return TEXTURE;
    }
}

