/*
 * Decompiled with CFR 0.152.
 */
package com.crabmods.instantworldmirror.command;

import com.crabmods.instantworldmirror.InstantWorldMirror;
import com.crabmods.instantworldmirror.MirrorConfig;
import com.crabmods.instantworldmirror.entity.MirrorPortalEntity;
import com.crabmods.instantworldmirror.entity.ModEntities;
import com.crabmods.instantworldmirror.world.DimensionPool;
import com.crabmods.instantworldmirror.world.MirrorWorldManager;
import com.crabmods.instantworldmirror.world.ModDimensions;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Comparator;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.commands.arguments.DimensionArgument;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.entity.EntityTypeTest;
import net.minecraft.world.level.storage.LevelResource;

public class ModCommands {
    private static final SuggestionProvider<CommandSourceStack> MIRROR_DIMENSION_SUGGESTIONS = (context, builder) -> {
        int poolSize = ModDimensions.getPoolSize();
        return SharedSuggestionProvider.suggestResource(IntStream.range(0, poolSize).mapToObj(i -> ModDimensions.getMirrorWorld(i).location()).toList(), (SuggestionsBuilder)builder);
    };

    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"iwm").then(Commands.literal((String)"return").executes(ModCommands::returnCommand))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"mob").requires(source -> source.hasPermission(2))).then(Commands.literal((String)"on").executes(ModCommands::mobOnCommand))).then(Commands.literal((String)"off").executes(ModCommands::mobOffCommand))).then(Commands.literal((String)"status").executes(ModCommands::mobStatusCommand)))).then(((LiteralArgumentBuilder)Commands.literal((String)"allow").requires(source -> source.hasPermission(2))).then(Commands.argument((String)"player", (ArgumentType)EntityArgument.player()).executes(ModCommands::allowCommand)))).then(((LiteralArgumentBuilder)Commands.literal((String)"deny").requires(source -> source.hasPermission(2))).then(Commands.argument((String)"player", (ArgumentType)EntityArgument.player()).executes(ModCommands::denyCommand)))).then(((LiteralArgumentBuilder)Commands.literal((String)"itemtransfer").requires(source -> source.hasPermission(2))).then(Commands.argument((String)"player", (ArgumentType)EntityArgument.player()).then(Commands.argument((String)"allowed", (ArgumentType)BoolArgumentType.bool()).executes(ModCommands::itemTransferCommand))))).then(((LiteralArgumentBuilder)Commands.literal((String)"status").requires(source -> source.hasPermission(2))).executes(ModCommands::statusCommand))).then(((LiteralArgumentBuilder)Commands.literal((String)"forceclear").requires(source -> source.hasPermission(3))).then(Commands.argument((String)"dimension", (ArgumentType)DimensionArgument.dimension()).suggests(MIRROR_DIMENSION_SUGGESTIONS).executes(ModCommands::forceClearCommand)))).then(((LiteralArgumentBuilder)Commands.literal((String)"purge").requires(source -> source.hasPermission(3))).executes(ModCommands::purgeCommand)));
    }

    private static int returnCommand(CommandContext<CommandSourceStack> context) {
        CommandSourceStack source = (CommandSourceStack)context.getSource();
        Entity entity = source.getEntity();
        if (entity instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)entity;
            if (MirrorWorldManager.isInMirrorWorld(player)) {
                MirrorWorldManager.forceReturn(player);
                source.sendSuccess(() -> Component.translatable((String)"command.instantworldmirror.return.success"), false);
                return 1;
            }
            source.sendFailure((Component)Component.translatable((String)"command.instantworldmirror.return.not_in_mirror"));
            return 0;
        }
        source.sendFailure((Component)Component.translatable((String)"command.instantworldmirror.player_only"));
        return 0;
    }

    private static int mobOnCommand(CommandContext<CommandSourceStack> context) {
        MirrorConfig.setRuntimeMobSpawning(true);
        MinecraftServer server = ((CommandSourceStack)context.getSource()).getServer();
        ModCommands.setMirrorWorldsMobSpawning(server, true);
        ((CommandSourceStack)context.getSource()).sendSuccess(() -> Component.translatable((String)"command.instantworldmirror.mob.on"), true);
        return 1;
    }

    private static int mobOffCommand(CommandContext<CommandSourceStack> context) {
        MirrorConfig.setRuntimeMobSpawning(false);
        MinecraftServer server = ((CommandSourceStack)context.getSource()).getServer();
        ModCommands.setMirrorWorldsMobSpawning(server, false);
        ((CommandSourceStack)context.getSource()).sendSuccess(() -> Component.translatable((String)"command.instantworldmirror.mob.off"), true);
        return 1;
    }

    private static void setMirrorWorldsMobSpawning(MinecraftServer server, boolean enabled) {
        for (int i = 0; i < ModDimensions.getPoolSize(); ++i) {
            ServerLevel mirrorWorld = DimensionPool.getDimensionLevel(server, i);
            if (mirrorWorld == null) continue;
            ((GameRules.BooleanValue)mirrorWorld.getGameRules().getRule(GameRules.RULE_DOMOBSPAWNING)).set(enabled, server);
        }
    }

    private static int mobStatusCommand(CommandContext<CommandSourceStack> context) {
        String status = MirrorConfig.getMobSpawningStatus();
        ((CommandSourceStack)context.getSource()).sendSuccess(() -> Component.translatable((String)"command.instantworldmirror.mob.status", (Object[])new Object[]{status}), false);
        return 1;
    }

    private static int allowCommand(CommandContext<CommandSourceStack> context) {
        try {
            ServerPlayer target = EntityArgument.getPlayer(context, (String)"player");
            MirrorWorldManager.setAccessPermission(target.getUUID(), true);
            ((CommandSourceStack)context.getSource()).sendSuccess(() -> Component.translatable((String)"command.instantworldmirror.allow.success", (Object[])new Object[]{target.getName().getString()}), true);
            return 1;
        }
        catch (Exception e) {
            ((CommandSourceStack)context.getSource()).sendFailure((Component)Component.translatable((String)"command.instantworldmirror.player_not_found"));
            return 0;
        }
    }

    private static int denyCommand(CommandContext<CommandSourceStack> context) {
        try {
            ServerPlayer target = EntityArgument.getPlayer(context, (String)"player");
            MirrorWorldManager.setAccessPermission(target.getUUID(), false);
            ((CommandSourceStack)context.getSource()).sendSuccess(() -> Component.translatable((String)"command.instantworldmirror.deny.success", (Object[])new Object[]{target.getName().getString()}), true);
            return 1;
        }
        catch (Exception e) {
            ((CommandSourceStack)context.getSource()).sendFailure((Component)Component.translatable((String)"command.instantworldmirror.player_not_found"));
            return 0;
        }
    }

    private static int itemTransferCommand(CommandContext<CommandSourceStack> context) {
        try {
            ServerPlayer target = EntityArgument.getPlayer(context, (String)"player");
            boolean allowed = BoolArgumentType.getBool(context, (String)"allowed");
            MirrorWorldManager.setItemTransferPermission(target.getUUID(), allowed);
            if (allowed) {
                ((CommandSourceStack)context.getSource()).sendSuccess(() -> Component.translatable((String)"command.instantworldmirror.itemtransfer.enabled", (Object[])new Object[]{target.getName().getString()}), true);
            } else {
                ((CommandSourceStack)context.getSource()).sendSuccess(() -> Component.translatable((String)"command.instantworldmirror.itemtransfer.disabled", (Object[])new Object[]{target.getName().getString()}), true);
            }
            return 1;
        }
        catch (Exception e) {
            ((CommandSourceStack)context.getSource()).sendFailure((Component)Component.translatable((String)"command.instantworldmirror.player_not_found"));
            return 0;
        }
    }

    private static int statusCommand(CommandContext<CommandSourceStack> context) {
        CommandSourceStack source = (CommandSourceStack)context.getSource();
        int poolSize = ModDimensions.getPoolSize();
        source.sendSuccess(() -> Component.translatable((String)"command.instantworldmirror.status.header"), false);
        source.sendSuccess(() -> Component.translatable((String)"command.instantworldmirror.status.summary", (Object[])new Object[]{DimensionPool.getAvailableCount(), DimensionPool.getInUseCount(), DimensionPool.getCleaningCount()}), false);
        for (int i = 0; i < poolSize; ++i) {
            ServerLevel mirrorWorld;
            int dimIndex = i;
            DimensionPool.DimensionState state = DimensionPool.getDimensionState(i);
            String stateKey = switch (state) {
                default -> throw new MatchException(null, null);
                case DimensionPool.DimensionState.AVAILABLE -> "command.instantworldmirror.status.available";
                case DimensionPool.DimensionState.IN_USE -> "command.instantworldmirror.status.in_use";
                case DimensionPool.DimensionState.CLEANING -> "command.instantworldmirror.status.cleaning";
            };
            int playerCount = 0;
            if (source.getServer() != null && (mirrorWorld = DimensionPool.getDimensionLevel(source.getServer(), i)) != null) {
                playerCount = mirrorWorld.players().size();
            }
            int finalPlayerCount = playerCount;
            String finalStateKey = stateKey;
            source.sendSuccess(() -> Component.translatable((String)"command.instantworldmirror.status.entry", (Object[])new Object[]{dimIndex, Component.translatable((String)finalStateKey), finalPlayerCount}), false);
        }
        return 1;
    }

    private static int forceClearCommand(CommandContext<CommandSourceStack> context) {
        CommandSourceStack source = (CommandSourceStack)context.getSource();
        try {
            ServerLevel dimension = DimensionArgument.getDimension(context, (String)"dimension");
            ResourceKey dimKey = dimension.dimension();
            int dimIndex = ModDimensions.getMirrorWorldIndex((ResourceKey<Level>)dimKey);
            if (dimIndex < 0) {
                source.sendFailure((Component)Component.translatable((String)"command.instantworldmirror.forceclear.invalid_dim", (Object[])new Object[]{ModDimensions.getPoolSize() - 1}));
                return 0;
            }
            if (source.getServer() != null) {
                DimensionPool.DimensionState state = DimensionPool.getDimensionState(dimIndex);
                int playersReturned = MirrorWorldManager.forceClearDimension(dimIndex, source.getServer());
                source.sendSuccess(() -> Component.translatable((String)"command.instantworldmirror.forceclear.success", (Object[])new Object[]{dimIndex, playersReturned}), true);
                source.sendSuccess(() -> Component.translatable((String)"command.instantworldmirror.forceclear.state_info", (Object[])new Object[]{state.name()}), false);
                return 1;
            }
            source.sendFailure((Component)Component.translatable((String)"command.instantworldmirror.server_unavailable"));
            return 0;
        }
        catch (Exception e) {
            source.sendFailure((Component)Component.translatable((String)"command.instantworldmirror.forceclear.invalid_dim", (Object[])new Object[]{ModDimensions.getPoolSize() - 1}));
            return 0;
        }
    }

    private static int purgeCommand(CommandContext<CommandSourceStack> context) {
        CommandSourceStack source = (CommandSourceStack)context.getSource();
        MinecraftServer server = source.getServer();
        if (server == null) {
            source.sendFailure((Component)Component.translatable((String)"command.instantworldmirror.server_unavailable"));
            return 0;
        }
        MirrorWorldManager.enablePurgeMode();
        source.sendSuccess(() -> Component.translatable((String)"command.instantworldmirror.purge.mode_enabled"), true);
        int totalPlayersReturned = 0;
        for (int i = 0; i < ModDimensions.getPoolSize(); ++i) {
            totalPlayersReturned += MirrorWorldManager.forceClearDimension(i, server);
        }
        int portalsRemoved = 0;
        for (ServerLevel level : server.getAllLevels()) {
            for (MirrorPortalEntity portal : level.getEntities((EntityTypeTest)ModEntities.MIRROR_PORTAL.get(), entity -> true)) {
                portal.discard();
                ++portalsRemoved;
            }
        }
        int finalPortalsRemoved = portalsRemoved;
        if (portalsRemoved > 0) {
            source.sendSuccess(() -> Component.translatable((String)"command.instantworldmirror.purge.portals_removed", (Object[])new Object[]{finalPortalsRemoved}), true);
        }
        Path worldPath = server.getWorldPath(LevelResource.ROOT);
        Path dimensionsPath = worldPath.resolve("dimensions").resolve("instantworldmirror");
        int deletedCount = 0;
        int failedCount = 0;
        for (int i = 0; i < 8; ++i) {
            Path mirrorWorldPath = dimensionsPath.resolve("mirror_world_" + i);
            if (!Files.exists(mirrorWorldPath, new LinkOption[0])) continue;
            try {
                ModCommands.deleteDirectoryRecursively(mirrorWorldPath);
                ++deletedCount;
                InstantWorldMirror.LOGGER.info("Deleted mirror world directory: {}", (Object)mirrorWorldPath);
                continue;
            }
            catch (IOException e) {
                ++failedCount;
                InstantWorldMirror.LOGGER.error("Failed to delete mirror world directory: {}", (Object)mirrorWorldPath, (Object)e);
            }
        }
        int finalDeletedCount = deletedCount;
        int finalFailedCount = failedCount;
        int finalPlayersReturned = totalPlayersReturned;
        if (deletedCount > 0) {
            source.sendSuccess(() -> Component.translatable((String)"command.instantworldmirror.purge.success", (Object[])new Object[]{finalDeletedCount, finalPlayersReturned}), true);
            source.sendSuccess(() -> Component.translatable((String)"command.instantworldmirror.purge.restart_required"), false);
        }
        if (failedCount > 0) {
            source.sendFailure((Component)Component.translatable((String)"command.instantworldmirror.purge.partial_failure", (Object[])new Object[]{finalFailedCount}));
        }
        if (deletedCount == 0 && failedCount == 0) {
            source.sendSuccess(() -> Component.translatable((String)"command.instantworldmirror.purge.nothing_to_delete"), false);
        }
        return deletedCount > 0 ? 1 : 0;
    }

    private static void deleteDirectoryRecursively(Path directory) throws IOException {
        if (Files.exists(directory, new LinkOption[0])) {
            try (Stream<Path> walk = Files.walk(directory, new FileVisitOption[0]);){
                walk.sorted(Comparator.reverseOrder()).forEach(path -> {
                    try {
                        Files.delete(path);
                    }
                    catch (IOException e) {
                        throw new RuntimeException("Failed to delete: " + String.valueOf(path), e);
                    }
                });
            }
        }
    }
}

