/*
 * Decompiled with CFR 0.152.
 */
package com.crabmods.instantworldmirror.entity;

import com.crabmods.instantworldmirror.InstantWorldMirror;
import com.crabmods.instantworldmirror.MirrorConfig;
import com.crabmods.instantworldmirror.block.PortalLightBlock;
import com.crabmods.instantworldmirror.block.PortalLightBlockEntity;
import com.crabmods.instantworldmirror.entity.ModEntities;
import com.crabmods.instantworldmirror.registry.ModBlocks;
import com.crabmods.instantworldmirror.world.MirrorSession;
import com.crabmods.instantworldmirror.world.MirrorWorldManager;
import com.crabmods.instantworldmirror.world.WorldCopyService;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;

public class MirrorPortalEntity
extends Entity {
    private static final EntityDataAccessor<Integer> DATA_LIFETIME = SynchedEntityData.defineId(MirrorPortalEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private static final EntityDataAccessor<Boolean> DATA_LOADING = SynchedEntityData.defineId(MirrorPortalEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final EntityDataAccessor<Boolean> DATA_IS_RETURN = SynchedEntityData.defineId(MirrorPortalEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private UUID ownerUUID;
    private UUID sessionId;
    private boolean isReturnPortal;
    private BlockPos clickPos;
    private boolean worldCopyStarted = false;
    private boolean worldCopyComplete = false;
    private int dimensionIndex = -1;
    private int lastDisplayedQueuePosition = 0;
    private boolean copyActivelyProcessing = false;
    private BlockPos currentLightPos = null;
    private final Map<UUID, Integer> playerStandingTime = new HashMap<UUID, Integer>();
    private final Set<UUID> playersLeftPortalOnce = new HashSet<UUID>();
    private static final int RETURN_PORTAL_STANDING_REQUIRED = 20;
    private static final int LEAVE_FIRST_PROTECTION_TICKS = 200;
    private boolean isAutoGenerated = false;
    private UUID returnPortalSessionId = null;

    public MirrorPortalEntity(EntityType<?> entityType, Level level) {
        super(entityType, level);
        this.noPhysics = true;
    }

    public static MirrorPortalEntity spawnReturnPortal(ServerLevel level, BlockPos groundBlockPos, UUID owner, boolean isAutoGenerated, UUID sessionId) {
        BlockPos spawnPos = groundBlockPos.above();
        MirrorPortalEntity portal = new MirrorPortalEntity((Level)level, (double)spawnPos.getX() + 0.5, (double)spawnPos.getY() + 0.5, (double)spawnPos.getZ() + 0.5, owner, true, isAutoGenerated, sessionId);
        level.addFreshEntity((Entity)portal);
        return portal;
    }

    public MirrorPortalEntity(Level level, double x, double y, double z, UUID owner, boolean isReturn) {
        this(level, x, y, z, owner, isReturn, false, null);
    }

    public MirrorPortalEntity(Level level, double x, double y, double z, UUID owner, boolean isReturn, boolean isAutoGen, UUID sessionIdForReturn) {
        this((EntityType)ModEntities.MIRROR_PORTAL.get(), level);
        this.setPos(x, y, z);
        this.ownerUUID = owner;
        this.isReturnPortal = isReturn;
        this.sessionId = null;
        this.clickPos = null;
        this.isAutoGenerated = isAutoGen;
        this.returnPortalSessionId = sessionIdForReturn;
        if (isReturn) {
            this.worldCopyComplete = true;
            this.entityData.set(DATA_LOADING, (Object)false);
            this.entityData.set(DATA_IS_RETURN, (Object)true);
            if (isAutoGen) {
                this.entityData.set(DATA_LIFETIME, (Object)-1);
            } else {
                this.entityData.set(DATA_LIFETIME, (Object)MirrorConfig.getReturnPortalLifetimeTicks());
            }
        }
    }

    public MirrorPortalEntity(Level level, double x, double y, double z, UUID owner, MirrorSession session, BlockPos clickPos) {
        this((EntityType)ModEntities.MIRROR_PORTAL.get(), level);
        this.setPos(x, y, z);
        this.ownerUUID = owner;
        this.isReturnPortal = false;
        this.sessionId = session.getSessionId();
        this.clickPos = clickPos;
        MirrorWorldManager.bindPortalToSession(session.getSessionId(), this.getUUID());
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        builder.define(DATA_LIFETIME, (Object)MirrorConfig.getEntryPortalLifetimeTicks());
        builder.define(DATA_LOADING, (Object)true);
        builder.define(DATA_IS_RETURN, (Object)false);
    }

    public void remove(Entity.RemovalReason reason) {
        Level level;
        if (!this.isReturnPortal && this.sessionId != null && (level = this.level()) instanceof ServerLevel) {
            MirrorSession session;
            int dimIndex;
            ServerLevel serverLevel = (ServerLevel)level;
            Optional<MirrorSession> sessionOpt = MirrorWorldManager.getSession(this.sessionId);
            if (sessionOpt.isPresent() && (dimIndex = (session = sessionOpt.get()).getDimensionIndex()) >= 0) {
                WorldCopyService.cancelCopyTask(dimIndex);
            }
            MirrorWorldManager.cancelSession(this.sessionId, serverLevel.getServer());
            InstantWorldMirror.LOGGER.info("Portal removed (reason: {}), session {} cancelled", (Object)reason, (Object)this.sessionId);
        }
        super.remove(reason);
    }

    public void tick() {
        super.tick();
        boolean isClient = this.level().isClientSide;
        if (!isClient) {
            Optional<MirrorSession> sessionOpt;
            int firstLightTick;
            ServerLevel serverLevel = (ServerLevel)this.level();
            int n = firstLightTick = this.isReturnPortal ? 20 : 1;
            if (this.tickCount == firstLightTick || this.tickCount > firstLightTick && this.tickCount % 5 == 0) {
                this.updateLightBlock();
            }
            if (!this.isReturnPortal && !this.worldCopyStarted && this.clickPos != null && this.sessionId != null) {
                this.worldCopyStarted = true;
                this.startAsyncWorldCopy(serverLevel);
            }
            if (!this.isReturnPortal && this.worldCopyStarted && !this.worldCopyComplete && this.sessionId != null && this.tickCount % 5 == 0 && (sessionOpt = MirrorWorldManager.getSession(this.sessionId)).isPresent()) {
                MirrorSession session = sessionOpt.get();
                if (session.isCopyComplete()) {
                    this.worldCopyComplete = true;
                    InstantWorldMirror.LOGGER.debug("World copy complete for session {}", (Object)this.sessionId);
                } else {
                    this.updateQueuePositionDisplay(serverLevel);
                }
            }
            if (!this.isReturnPortal) {
                int maxLoadingTicks;
                boolean shouldRemove = false;
                Object removeReason = null;
                if (!this.worldCopyComplete && this.tickCount > (maxLoadingTicks = MirrorConfig.getMaxPortalLoadingTicks())) {
                    shouldRemove = true;
                    removeReason = "loading timeout (exceeded " + maxLoadingTicks / 20 + " seconds)";
                }
                if (this.sessionId != null && this.tickCount % 20 == 0) {
                    Optional<MirrorSession> sessionOpt2 = MirrorWorldManager.getSession(this.sessionId);
                    if (sessionOpt2.isEmpty()) {
                        shouldRemove = true;
                        removeReason = "session no longer exists";
                    } else if (sessionOpt2.get().isDestroyed()) {
                        shouldRemove = true;
                        removeReason = "session is destroyed";
                    }
                }
                if (this.worldCopyStarted && this.sessionId == null) {
                    shouldRemove = true;
                    removeReason = "invalid state (no session ID)";
                }
                if (shouldRemove) {
                    InstantWorldMirror.LOGGER.warn("Removing inactive portal: {}", removeReason);
                    this.level().playSound(null, this.getX(), this.getY(), this.getZ(), SoundEvents.GLASS_BREAK, SoundSource.BLOCKS, 0.3f, 0.5f);
                    if (this.sessionId != null && !((String)removeReason).contains("destroyed")) {
                        MirrorWorldManager.cancelSession(this.sessionId, serverLevel.getServer());
                    }
                    this.discard();
                    return;
                }
            }
            if (this.isReturnPortal && this.isAutoGenerated && this.returnPortalSessionId != null && this.tickCount % 20 == 0 && ((sessionOpt = MirrorWorldManager.getSession(this.returnPortalSessionId)).isEmpty() || sessionOpt.get().isDestroyed())) {
                this.level().playSound(null, this.getX(), this.getY(), this.getZ(), SoundEvents.GLASS_BREAK, SoundSource.BLOCKS, 0.3f, 0.5f);
                this.discard();
                return;
            }
        }
        boolean isLoading = (Boolean)this.entityData.get(DATA_LOADING);
        if (this.worldCopyComplete && isLoading) {
            this.entityData.set(DATA_LOADING, (Object)false);
            isLoading = false;
            this.entityData.set(DATA_LIFETIME, (Object)MirrorConfig.getEntryPortalLifetimeTicks());
        }
        int lifetime = (Integer)this.entityData.get(DATA_LIFETIME);
        if (!isLoading && lifetime != -1) {
            this.entityData.set(DATA_LIFETIME, (Object)(--lifetime));
            if (lifetime <= 0) {
                if (!isClient) {
                    this.onPortalTimeout();
                }
                this.discard();
                return;
            }
        }
        if (isClient) {
            this.spawnAmbientParticles();
        }
        if (!isClient && !isLoading) {
            this.checkPlayerCollision((ServerLevel)this.level());
        }
    }

    private void onPortalTimeout() {
        Level level;
        this.level().playSound(null, this.getX(), this.getY(), this.getZ(), SoundEvents.GLASS_BREAK, SoundSource.BLOCKS, 0.5f, 1.5f);
        if (!this.isReturnPortal && this.sessionId != null && (level = this.level()) instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            MirrorWorldManager.cancelSession(this.sessionId, serverLevel.getServer());
            InstantWorldMirror.LOGGER.info("Portal timed out, session {} cancelled", (Object)this.sessionId);
        }
    }

    private void updateLightBlock() {
        if (this.level().isClientSide) {
            return;
        }
        ServerLevel serverLevel = (ServerLevel)this.level();
        BlockPos newLightPos = BlockPos.containing((double)this.getX(), (double)(this.getY() + 1.0), (double)this.getZ());
        if (newLightPos.equals((Object)this.currentLightPos)) {
            return;
        }
        this.removeLightBlock();
        BlockState currentState = serverLevel.getBlockState(newLightPos);
        if (currentState.isAir() || currentState.canBeReplaced()) {
            serverLevel.setBlock(newLightPos, ((PortalLightBlock)((Object)ModBlocks.PORTAL_LIGHT_BLOCK.get())).defaultBlockState(), 3);
            BlockEntity be = serverLevel.getBlockEntity(newLightPos);
            if (be instanceof PortalLightBlockEntity) {
                PortalLightBlockEntity lightBE = (PortalLightBlockEntity)be;
                lightBE.setPortalEntityId(this.getUUID());
            }
            this.currentLightPos = newLightPos;
            serverLevel.getLightEngine().checkBlock(newLightPos);
            for (Direction dir : Direction.values()) {
                serverLevel.getLightEngine().checkBlock(newLightPos.relative(dir));
            }
            serverLevel.getChunkSource().blockChanged(newLightPos);
        }
    }

    private void removeLightBlock() {
        if (this.level() == null || this.level().isClientSide) {
            return;
        }
        ServerLevel serverLevel = (ServerLevel)this.level();
        if (this.currentLightPos != null) {
            BlockState state = serverLevel.getBlockState(this.currentLightPos);
            if (state.is((Block)ModBlocks.PORTAL_LIGHT_BLOCK.get())) {
                serverLevel.setBlockAndUpdate(this.currentLightPos, Blocks.AIR.defaultBlockState());
                serverLevel.getChunkSource().blockChanged(this.currentLightPos);
            }
            this.currentLightPos = null;
        }
    }

    private void startAsyncWorldCopy(ServerLevel serverLevel) {
        Optional<MirrorSession> sessionOpt = MirrorWorldManager.getSession(this.sessionId);
        if (sessionOpt.isEmpty()) {
            InstantWorldMirror.LOGGER.warn("Session {} not found for portal", (Object)this.sessionId);
            this.worldCopyComplete = true;
            return;
        }
        MirrorSession session = sessionOpt.get();
        this.dimensionIndex = session.getDimensionIndex();
        Player owner = serverLevel.getPlayerByUUID(this.ownerUUID);
        if (owner instanceof ServerPlayer) {
            int queuePosition;
            ServerPlayer serverPlayer = (ServerPlayer)owner;
            this.lastDisplayedQueuePosition = queuePosition = MirrorWorldManager.prepareWorldCopy(serverPlayer, session);
            if (queuePosition > 1) {
                serverPlayer.displayClientMessage((Component)Component.translatable((String)"message.instantworldmirror.queue_position", (Object[])new Object[]{queuePosition}), true);
            } else {
                this.copyActivelyProcessing = true;
                serverPlayer.displayClientMessage((Component)Component.translatable((String)"message.instantworldmirror.copy_started"), true);
            }
            InstantWorldMirror.LOGGER.debug("Started world copy for session {}, queue position: {}", (Object)this.sessionId, (Object)queuePosition);
        } else {
            this.worldCopyComplete = true;
        }
    }

    private void updateQueuePositionDisplay(ServerLevel serverLevel) {
        if (this.dimensionIndex < 0 || this.ownerUUID == null) {
            return;
        }
        Player owner = serverLevel.getPlayerByUUID(this.ownerUUID);
        if (!(owner instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer serverPlayer = (ServerPlayer)owner;
        int currentQueuePosition = WorldCopyService.getCopyQueuePosition(this.dimensionIndex);
        if (currentQueuePosition <= 0) {
            return;
        }
        if (currentQueuePosition == 1 && !this.copyActivelyProcessing) {
            this.copyActivelyProcessing = true;
            serverPlayer.displayClientMessage((Component)Component.translatable((String)"message.instantworldmirror.copy_started"), true);
            this.lastDisplayedQueuePosition = 1;
            return;
        }
        if (currentQueuePosition > 1 && currentQueuePosition != this.lastDisplayedQueuePosition) {
            this.lastDisplayedQueuePosition = currentQueuePosition;
            serverPlayer.displayClientMessage((Component)Component.translatable((String)"message.instantworldmirror.queue_position", (Object[])new Object[]{currentQueuePosition}), true);
        }
    }

    private void checkPlayerCollision(ServerLevel serverLevel) {
        AABB boundingBox = this.getBoundingBox();
        List players = serverLevel.getEntitiesOfClass(Player.class, boundingBox);
        HashSet<UUID> playersInBox = new HashSet<UUID>();
        for (Player player : players) {
            if (!(player instanceof ServerPlayer)) continue;
            ServerPlayer serverPlayer = (ServerPlayer)player;
            if (this.isReturnPortal) {
                playersInBox.add(player.getUUID());
                boolean isWithinProtectionPeriod = false;
                CompoundTag playerData = player.getPersistentData();
                if (playerData.contains("MirrorWorldEnterTime")) {
                    long enterTime = playerData.getLong("MirrorWorldEnterTime");
                    long currentTime = this.level().getGameTime();
                    boolean bl = isWithinProtectionPeriod = currentTime - enterTime < 200L;
                }
                if (isWithinProtectionPeriod && !this.playersLeftPortalOnce.contains(player.getUUID())) {
                    this.playerStandingTime.putIfAbsent(player.getUUID(), 0);
                    continue;
                }
                int currentStandTime = this.playerStandingTime.getOrDefault(player.getUUID(), 0);
                this.playerStandingTime.put(player.getUUID(), ++currentStandTime);
                if (currentStandTime < 20) {
                    float progress = (float)currentStandTime / 20.0f;
                    serverPlayer.displayClientMessage((Component)Component.translatable((String)"message.instantworldmirror.portal_activating", (Object[])new Object[]{String.format("%.0f%%", Float.valueOf(progress * 100.0f))}), true);
                    continue;
                }
                boolean success = MirrorWorldManager.returnToOverworldFromPosition(serverPlayer, this.blockPosition());
                if (success) {
                    this.level().playSound(null, this.getX(), this.getY(), this.getZ(), SoundEvents.ENDERMAN_TELEPORT, SoundSource.PLAYERS, 1.0f, 1.0f);
                    if (!this.isAutoGenerated) {
                        this.discard();
                    } else {
                        this.playerStandingTime.clear();
                    }
                } else {
                    serverPlayer.displayClientMessage((Component)Component.translatable((String)"message.instantworldmirror.return_failed"), true);
                }
                return;
            }
            if (!MirrorWorldManager.canAccessMirrorWorld(serverPlayer)) {
                serverPlayer.displayClientMessage((Component)Component.translatable((String)"message.instantworldmirror.access_denied"), true);
                continue;
            }
            Optional<MirrorSession> sessionOpt = MirrorWorldManager.getSession(this.sessionId);
            if (sessionOpt.isEmpty()) {
                InstantWorldMirror.LOGGER.info("Session {} no longer exists, removing portal", (Object)this.sessionId);
                serverPlayer.displayClientMessage((Component)Component.translatable((String)"message.instantworldmirror.session_expired"), true);
                this.discard();
                return;
            }
            MirrorSession session = sessionOpt.get();
            if (session.isDestroyed()) {
                InstantWorldMirror.LOGGER.info("Session {} is destroyed, removing portal", (Object)this.sessionId);
                serverPlayer.displayClientMessage((Component)Component.translatable((String)"message.instantworldmirror.session_expired"), true);
                this.discard();
                return;
            }
            boolean isHost = session.isHost(serverPlayer.getUUID());
            if (!isHost && !session.hasHostEntered()) {
                serverPlayer.displayClientMessage((Component)Component.translatable((String)"message.instantworldmirror.wait_for_host"), true);
                continue;
            }
            if (MirrorWorldManager.hasActiveSession(serverPlayer.getUUID()) && !isHost) {
                serverPlayer.displayClientMessage((Component)Component.translatable((String)"message.instantworldmirror.already_has_session"), true);
                continue;
            }
            boolean success = MirrorWorldManager.teleportToMirrorWorld(serverPlayer, session);
            if (success) {
                this.level().playSound(null, this.getX(), this.getY(), this.getZ(), SoundEvents.ENDERMAN_TELEPORT, SoundSource.PLAYERS, 1.0f, 1.0f);
                if (isHost) {
                    session.markHostEntered();
                    InstantWorldMirror.LOGGER.info("Host {} entered session {}, portal now open for others", (Object)serverPlayer.getName().getString(), (Object)this.sessionId);
                }
            } else {
                InstantWorldMirror.LOGGER.warn("Entry portal FAILED to teleport player {}", (Object)serverPlayer.getName().getString());
            }
            return;
        }
        if (this.isReturnPortal) {
            for (UUID uuid : new HashSet<UUID>(this.playerStandingTime.keySet())) {
                if (playersInBox.contains(uuid)) continue;
                this.playersLeftPortalOnce.add(uuid);
                this.playerStandingTime.remove(uuid);
            }
        }
    }

    private void spawnAmbientParticles() {
        double z;
        double y;
        double x;
        if (this.random.nextInt(2) == 0) {
            x = this.getX() + (this.random.nextDouble() - 0.5) * 1.0;
            y = this.getY() - 0.5 + this.random.nextDouble() * 2.0;
            z = this.getZ() + (this.random.nextDouble() - 0.5) * 1.0;
            this.level().addParticle((ParticleOptions)ParticleTypes.PORTAL, x, y, z, 0.0, 0.1, 0.0);
        }
        if (this.random.nextInt(6) == 0) {
            x = this.getX() + (this.random.nextDouble() - 0.5) * 0.6;
            y = this.getY() + this.random.nextDouble() * 1.0;
            z = this.getZ() + (this.random.nextDouble() - 0.5) * 0.6;
            this.level().addParticle((ParticleOptions)ParticleTypes.END_ROD, x, y, z, 0.0, 0.02, 0.0);
        }
        if (this.random.nextInt(4) == 0) {
            double angle = (double)this.tickCount * 0.2;
            double radius = 0.5;
            double x2 = this.getX() + Math.cos(angle) * radius;
            double y2 = this.getY() + 0.5 + (double)(this.tickCount % 20) * 0.05;
            double z2 = this.getZ() + Math.sin(angle) * radius;
            this.level().addParticle((ParticleOptions)ParticleTypes.REVERSE_PORTAL, x2, y2, z2, 0.0, 0.02, 0.0);
        }
    }

    protected void readAdditionalSaveData(CompoundTag compound) {
        if (compound.hasUUID("Owner")) {
            this.ownerUUID = compound.getUUID("Owner");
        }
        if (compound.hasUUID("SessionId")) {
            this.sessionId = compound.getUUID("SessionId");
        }
        this.isReturnPortal = compound.getBoolean("IsReturn");
        this.entityData.set(DATA_LIFETIME, (Object)compound.getInt("Lifetime"));
        this.entityData.set(DATA_IS_RETURN, (Object)this.isReturnPortal);
        this.entityData.set(DATA_LOADING, (Object)(!compound.getBoolean("WorldCopyComplete") ? 1 : 0));
        this.worldCopyComplete = compound.getBoolean("WorldCopyComplete");
        this.worldCopyStarted = compound.getBoolean("WorldCopyStarted");
        if (compound.contains("ClickPosX")) {
            this.clickPos = new BlockPos(compound.getInt("ClickPosX"), compound.getInt("ClickPosY"), compound.getInt("ClickPosZ"));
        }
        if (compound.contains("LightPosX")) {
            this.currentLightPos = new BlockPos(compound.getInt("LightPosX"), compound.getInt("LightPosY"), compound.getInt("LightPosZ"));
        }
        this.isAutoGenerated = compound.getBoolean("IsAutoGenerated");
        if (compound.hasUUID("ReturnPortalSessionId")) {
            this.returnPortalSessionId = compound.getUUID("ReturnPortalSessionId");
        }
    }

    protected void addAdditionalSaveData(CompoundTag compound) {
        if (this.ownerUUID != null) {
            compound.putUUID("Owner", this.ownerUUID);
        }
        if (this.sessionId != null) {
            compound.putUUID("SessionId", this.sessionId);
        }
        compound.putBoolean("IsReturn", this.isReturnPortal);
        compound.putInt("Lifetime", ((Integer)this.entityData.get(DATA_LIFETIME)).intValue());
        compound.putBoolean("WorldCopyComplete", this.worldCopyComplete);
        compound.putBoolean("WorldCopyStarted", this.worldCopyStarted);
        if (this.clickPos != null) {
            compound.putInt("ClickPosX", this.clickPos.getX());
            compound.putInt("ClickPosY", this.clickPos.getY());
            compound.putInt("ClickPosZ", this.clickPos.getZ());
        }
        if (this.currentLightPos != null) {
            compound.putInt("LightPosX", this.currentLightPos.getX());
            compound.putInt("LightPosY", this.currentLightPos.getY());
            compound.putInt("LightPosZ", this.currentLightPos.getZ());
        }
        compound.putBoolean("IsAutoGenerated", this.isAutoGenerated);
        if (this.returnPortalSessionId != null) {
            compound.putUUID("ReturnPortalSessionId", this.returnPortalSessionId);
        }
    }

    public int getLifetime() {
        return (Integer)this.entityData.get(DATA_LIFETIME);
    }

    public Optional<UUID> getOwnerUUID() {
        return Optional.ofNullable(this.ownerUUID);
    }

    public Optional<UUID> getSessionId() {
        return Optional.ofNullable(this.sessionId);
    }

    public boolean isReturnPortal() {
        return (Boolean)this.entityData.get(DATA_IS_RETURN);
    }

    public boolean isLoading() {
        return (Boolean)this.entityData.get(DATA_LOADING);
    }

    public boolean isPickable() {
        return false;
    }

    public boolean isPushable() {
        return false;
    }
}

