/*
 * Decompiled with CFR 0.152.
 */
package com.crabmods.instantworldmirror.event;

import com.crabmods.instantworldmirror.InstantWorldMirror;
import com.crabmods.instantworldmirror.MirrorConfig;
import com.crabmods.instantworldmirror.command.ModCommands;
import com.crabmods.instantworldmirror.item.DimensionMirrorItem;
import com.crabmods.instantworldmirror.world.DimensionPool;
import com.crabmods.instantworldmirror.world.MirrorWorldManager;
import com.crabmods.instantworldmirror.world.ModDimensions;
import com.crabmods.instantworldmirror.world.WorldCopyService;
import com.mojang.brigadier.CommandDispatcher;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.GameType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.ServerLevelData;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.RegisterCommandsEvent;
import net.neoforged.neoforge.event.entity.EntityTravelToDimensionEvent;
import net.neoforged.neoforge.event.entity.living.FinalizeSpawnEvent;
import net.neoforged.neoforge.event.entity.living.LivingDeathEvent;
import net.neoforged.neoforge.event.entity.player.PlayerEvent;
import net.neoforged.neoforge.event.level.BlockEvent;
import net.neoforged.neoforge.event.server.ServerStoppingEvent;
import net.neoforged.neoforge.event.tick.LevelTickEvent;

@EventBusSubscriber(modid="instantworldmirror")
public class ModEvents {
    private static int tickCounter = 0;
    private static final Map<UUID, Long> lastTrackedChunkPos = new ConcurrentHashMap<UUID, Long>();
    private static final int CHUNK_TRACK_DISTANCE_THRESHOLD = 2;

    @SubscribeEvent
    public static void onRegisterCommands(RegisterCommandsEvent event) {
        ModCommands.register((CommandDispatcher<CommandSourceStack>)event.getDispatcher());
        InstantWorldMirror.LOGGER.info("Mirror commands registered");
    }

    @SubscribeEvent
    public static void onPlayerDeath(LivingDeathEvent event) {
        ServerPlayer player;
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity instanceof ServerPlayer && MirrorWorldManager.isInMirrorWorld(player = (ServerPlayer)livingEntity)) {
            InstantWorldMirror.LOGGER.info("Player {} died in Mirror World, cleaning up session", (Object)player.getName().getString());
            MirrorWorldManager.handleMirrorWorldDeath(player, player.getServer());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SubscribeEvent
    public static void onPlayerRespawn(PlayerEvent.PlayerRespawnEvent event) {
        ServerPlayer player;
        Player player2 = event.getEntity();
        if (player2 instanceof ServerPlayer && ModDimensions.isMirrorWorld((ResourceKey<Level>)(player = (ServerPlayer)player2).level().dimension())) {
            ServerLevel overworld = player.getServer().overworld();
            BlockPos spawnPos = overworld.getSharedSpawnPos();
            MirrorWorldManager.markPlayerBeingTeleported(player.getUUID());
            try {
                player.teleportTo(overworld, (double)spawnPos.getX() + 0.5, (double)spawnPos.getY(), (double)spawnPos.getZ() + 0.5, player.getYRot(), player.getXRot());
            }
            finally {
                MirrorWorldManager.unmarkPlayerBeingTeleported(player.getUUID());
            }
            InstantWorldMirror.LOGGER.info("Force teleported {} to overworld after respawn in mirror world", (Object)player.getName().getString());
        }
    }

    @SubscribeEvent
    public static void onPlayerChangeDimension(PlayerEvent.PlayerChangedDimensionEvent event) {
        Player player = event.getEntity();
        if (player instanceof ServerPlayer) {
            ServerPlayer player2 = (ServerPlayer)player;
            if (ModDimensions.isMirrorWorld((ResourceKey<Level>)event.getFrom()) && !ModDimensions.isMirrorWorld((ResourceKey<Level>)event.getTo())) {
                InstantWorldMirror.LOGGER.info("Player {} left Mirror World via external means (from {} to {})", new Object[]{player2.getName().getString(), event.getFrom().location(), event.getTo().location()});
                MirrorWorldManager.handleExternalExit(player2, player2.getServer());
            }
        }
    }

    @SubscribeEvent
    public static void onPlayerLogout(PlayerEvent.PlayerLoggedOutEvent event) {
        Player player = event.getEntity();
        if (player instanceof ServerPlayer) {
            ServerPlayer player2 = (ServerPlayer)player;
            DimensionMirrorItem.saveCooldown(player2);
            MirrorWorldManager.handlePlayerDisconnect(player2, player2.getServer());
            lastTrackedChunkPos.remove(player2.getUUID());
            if (MirrorWorldManager.isInMirrorWorld(player2)) {
                InstantWorldMirror.LOGGER.info("Player {} logged out from Mirror World", (Object)player2.getName().getString());
            }
        }
    }

    @SubscribeEvent
    public static void onBlockPlace(BlockEvent.EntityPlaceEvent event) {
        Level level = (Level)event.getLevel();
        if (ModDimensions.isMirrorWorld((ResourceKey<Level>)level.dimension())) {
            int dimIndex;
            BlockState state = event.getPlacedBlock();
            if (state.is(Blocks.END_PORTAL_FRAME)) {
                Entity entity = event.getEntity();
                if (entity instanceof ServerPlayer) {
                    ServerPlayer player = (ServerPlayer)entity;
                    GameType gameType = player.gameMode.getGameModeForPlayer();
                    if (gameType == GameType.SURVIVAL || gameType == GameType.ADVENTURE) {
                        event.setCanceled(true);
                        return;
                    }
                } else {
                    event.setCanceled(true);
                    return;
                }
            }
            if ((dimIndex = ModDimensions.getMirrorWorldIndex((ResourceKey<Level>)level.dimension())) >= 0) {
                BlockPos pos = event.getPos();
                WorldCopyService.trackModifiedChunk(dimIndex, pos.getX() >> 4, pos.getZ() >> 4);
            }
        }
    }

    @SubscribeEvent
    public static void onBlockBreak(BlockEvent.BreakEvent event) {
        int dimIndex;
        Level level = (Level)event.getLevel();
        if (ModDimensions.isMirrorWorld((ResourceKey<Level>)level.dimension()) && (dimIndex = ModDimensions.getMirrorWorldIndex((ResourceKey<Level>)level.dimension())) >= 0) {
            BlockPos pos = event.getPos();
            WorldCopyService.trackModifiedChunk(dimIndex, pos.getX() >> 4, pos.getZ() >> 4);
        }
    }

    @SubscribeEvent
    public static void onPortalSpawn(BlockEvent.PortalSpawnEvent event) {
        Level level = (Level)event.getLevel();
        if (ModDimensions.isMirrorWorld((ResourceKey<Level>)level.dimension())) {
            event.setCanceled(true);
            InstantWorldMirror.LOGGER.info("Blocked nether portal spawn in Mirror World at {}", (Object)event.getPos());
        }
    }

    @SubscribeEvent
    public static void onMobSpawn(FinalizeSpawnEvent event) {
        ServerLevel level = event.getLevel().getLevel();
        if (ModDimensions.isMirrorWorld((ResourceKey<Level>)level.dimension()) && !MirrorConfig.isMobSpawningEnabled()) {
            MobSpawnType spawnType = event.getSpawnType();
            if (spawnType == MobSpawnType.SPAWN_EGG || spawnType == MobSpawnType.TRIGGERED || spawnType == MobSpawnType.COMMAND || spawnType == MobSpawnType.BUCKET || spawnType == MobSpawnType.CONVERSION || spawnType == MobSpawnType.BREEDING || spawnType == MobSpawnType.DISPENSER || spawnType == MobSpawnType.EVENT) {
                return;
            }
            event.setSpawnCancelled(true);
        }
    }

    @SubscribeEvent
    public static void onEntityTravelToDimension(EntityTravelToDimensionEvent event) {
        Entity entity = event.getEntity();
        if (ModDimensions.isMirrorWorld((ResourceKey<Level>)entity.level().dimension())) {
            ServerPlayer player;
            if (entity instanceof ServerPlayer) {
                player = (ServerPlayer)entity;
                if (MirrorWorldManager.isBeingTeleportedByMod(player.getUUID())) {
                    return;
                }
                GameType gameType = player.gameMode.getGameModeForPlayer();
                if (gameType != GameType.SURVIVAL && gameType != GameType.ADVENTURE) {
                    return;
                }
            }
            event.setCanceled(true);
            if (entity instanceof ServerPlayer) {
                player = (ServerPlayer)entity;
                player.displayClientMessage((Component)Component.translatable((String)"message.instantworldmirror.portal_blocked"), true);
            }
            InstantWorldMirror.LOGGER.info("Blocked dimension travel from Mirror World to {} for {}", (Object)event.getDimension().location(), (Object)entity.getName().getString());
        }
    }

    @SubscribeEvent
    public static void onWorldTick(LevelTickEvent.Post event) {
        Level level = event.getLevel();
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel serverLevel = (ServerLevel)level;
        if (serverLevel.dimension().equals(Level.OVERWORLD)) {
            WorldCopyService.processCopyQueues(serverLevel.getServer());
            WorldCopyService.processCleanupQueues(serverLevel.getServer());
            int staleCleanupTicks = MirrorConfig.getStaleSessionCleanupTicks();
            if (staleCleanupTicks > 0 && ++tickCounter % staleCleanupTicks == 0) {
                MirrorWorldManager.cleanupStaleSessions(serverLevel.getServer());
            }
            if (tickCounter >= 262144) {
                tickCounter = 0;
            }
            return;
        }
        if (!ModDimensions.isMirrorWorld((ResourceKey<Level>)serverLevel.dimension())) {
            return;
        }
        int dimIndex = ModDimensions.getMirrorWorldIndex((ResourceKey<Level>)serverLevel.dimension());
        if (dimIndex < 0) {
            return;
        }
        long gameTime = serverLevel.getGameTime();
        if (gameTime % 10L == 0L && !serverLevel.players().isEmpty()) {
            int viewDistance = serverLevel.getServer().getPlayerList().getViewDistance();
            for (ServerPlayer player : serverLevel.players()) {
                int chunkX = player.getBlockX() >> 4;
                int chunkZ = player.getBlockZ() >> 4;
                long currentChunkPacked = (long)chunkX << 32 | (long)chunkZ & 0xFFFFFFFFL;
                Long lastPos = lastTrackedChunkPos.get(player.getUUID());
                if (lastPos == null) {
                    WorldCopyService.trackChunksInRadius(dimIndex, chunkX, chunkZ, viewDistance);
                    lastTrackedChunkPos.put(player.getUUID(), currentChunkPacked);
                    continue;
                }
                int lastChunkX = (int)(lastPos >> 32);
                int lastChunkZ = lastPos.intValue();
                int distX = Math.abs(chunkX - lastChunkX);
                int distZ = Math.abs(chunkZ - lastChunkZ);
                if (distX < 2 && distZ < 2) continue;
                WorldCopyService.trackChunksInRadius(dimIndex, chunkX, chunkZ, viewDistance);
                lastTrackedChunkPos.put(player.getUUID(), currentChunkPacked);
            }
        }
        if (gameTime % 20L == 0L) {
            ResourceKey<Level> sourceDimKey = DimensionPool.getSourceDimension(dimIndex);
            ServerLevel sourceLevel = serverLevel.getServer().getLevel(sourceDimKey);
            if (sourceLevel == null) {
                sourceLevel = serverLevel.getServer().overworld();
            }
            ModEvents.syncLevelTime(sourceLevel, serverLevel);
            boolean sourceRaining = sourceLevel.isRaining();
            boolean sourceThundering = sourceLevel.isThundering();
            if (sourceRaining != serverLevel.isRaining() || sourceThundering != serverLevel.isThundering()) {
                serverLevel.setWeatherParameters(sourceRaining ? 0 : 6000, sourceRaining ? 6000 : 0, sourceRaining, sourceThundering);
            }
        }
    }

    private static void syncLevelTime(ServerLevel source, ServerLevel mirror) {
        mirror.setDayTime(source.getDayTime());
        try {
            ServerLevelData mirrorData = (ServerLevelData)mirror.getLevelData();
            mirrorData.setGameTime(source.getGameTime());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @SubscribeEvent
    public static void onPlayerLogin(PlayerEvent.PlayerLoggedInEvent event) {
        Player player = event.getEntity();
        if (player instanceof ServerPlayer) {
            ServerPlayer player2 = (ServerPlayer)player;
            DimensionMirrorItem.restoreCooldown(player2);
            if (MirrorWorldManager.hasSavedInventory(player2)) {
                player2.getServer().execute(() -> {
                    if (ModDimensions.isMirrorWorld((ResourceKey<Level>)player2.level().dimension())) {
                        ServerLevel overworld = player2.getServer().overworld();
                        BlockPos spawnPos = overworld.getSharedSpawnPos();
                        MirrorWorldManager.markPlayerBeingTeleported(player2.getUUID());
                        try {
                            player2.teleportTo(overworld, (double)spawnPos.getX() + 0.5, (double)spawnPos.getY(), (double)spawnPos.getZ() + 0.5, player2.getYRot(), player2.getXRot());
                        }
                        finally {
                            MirrorWorldManager.unmarkPlayerBeingTeleported(player2.getUUID());
                        }
                    }
                    MirrorWorldManager.forceReturn(player2);
                    InstantWorldMirror.LOGGER.info("Player {} had saved inventory data, restored on login", (Object)player2.getName().getString());
                });
            } else if (ModDimensions.isMirrorWorld((ResourceKey<Level>)player2.level().dimension())) {
                player2.getServer().execute(() -> {
                    ServerLevel overworld = player2.getServer().overworld();
                    BlockPos spawnPos = overworld.getSharedSpawnPos();
                    MirrorWorldManager.markPlayerBeingTeleported(player2.getUUID());
                    try {
                        player2.teleportTo(overworld, (double)spawnPos.getX() + 0.5, (double)spawnPos.getY(), (double)spawnPos.getZ() + 0.5, player2.getYRot(), player2.getXRot());
                    }
                    finally {
                        MirrorWorldManager.unmarkPlayerBeingTeleported(player2.getUUID());
                    }
                    InstantWorldMirror.LOGGER.info("Player {} was in Mirror World on login (no saved data), teleported to Overworld", (Object)player2.getName().getString());
                });
            }
        }
    }

    @SubscribeEvent
    public static void onServerStopping(ServerStoppingEvent event) {
        for (ServerPlayer player : event.getServer().getPlayerList().getPlayers()) {
            DimensionMirrorItem.saveCooldown(player);
        }
        DimensionMirrorItem.clearAllCooldowns();
        MirrorWorldManager.clearAllSessions();
        WorldCopyService.clearAllTasks();
        InstantWorldMirror.LOGGER.info("Server stopping, mirror sessions and tasks cleared.");
    }
}

