/*
 * Decompiled with CFR 0.152.
 */
package com.crabmods.instantworldmirror.item;

import com.crabmods.instantworldmirror.InstantWorldMirror;
import com.crabmods.instantworldmirror.MirrorConfig;
import com.crabmods.instantworldmirror.entity.MirrorPortalEntity;
import com.crabmods.instantworldmirror.network.SyncCooldownPacket;
import com.crabmods.instantworldmirror.network.TeleportToSpawnPacket;
import com.crabmods.instantworldmirror.world.MirrorSession;
import com.crabmods.instantworldmirror.world.MirrorWorldManager;
import com.crabmods.instantworldmirror.world.ModDimensions;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.network.PacketDistributor;

public class DimensionMirrorItem
extends Item {
    private static final String COOLDOWN_NBT_KEY = "instantworldmirror:mirror_cooldown_until";
    private static final String COOLDOWN_DURATION_NBT_KEY = "instantworldmirror:mirror_cooldown_duration";
    private static final Map<UUID, Long> COOLDOWNS = new ConcurrentHashMap<UUID, Long>();
    private static final Map<UUID, Long> COOLDOWN_DURATIONS = new ConcurrentHashMap<UUID, Long>();
    private static final int HOLD_DURATION_TICKS = 20;

    public DimensionMirrorItem(Item.Properties properties) {
        super(properties);
    }

    public static long getRemainingCooldownMillis(UUID playerUUID) {
        Long endTime = COOLDOWNS.get(playerUUID);
        if (endTime == null) {
            return 0L;
        }
        long remaining = endTime - System.currentTimeMillis();
        if (remaining <= 0L) {
            COOLDOWNS.remove(playerUUID);
            return 0L;
        }
        return remaining;
    }

    public static void setCooldown(UUID playerUUID, int seconds) {
        long durationMillis = (long)seconds * 1000L;
        long endTime = System.currentTimeMillis() + durationMillis;
        COOLDOWNS.put(playerUUID, endTime);
        COOLDOWN_DURATIONS.put(playerUUID, durationMillis);
    }

    public static void clearCooldown(UUID playerUUID) {
        COOLDOWNS.remove(playerUUID);
        COOLDOWN_DURATIONS.remove(playerUUID);
    }

    public static void clearAllCooldowns() {
        COOLDOWNS.clear();
        COOLDOWN_DURATIONS.clear();
    }

    public static void saveCooldown(ServerPlayer player) {
        UUID playerId = player.getUUID();
        Long cooldownUntil = COOLDOWNS.get(playerId);
        Long cooldownDuration = COOLDOWN_DURATIONS.get(playerId);
        if (cooldownUntil != null && cooldownUntil > System.currentTimeMillis()) {
            CompoundTag persistentData = player.getPersistentData();
            persistentData.putLong(COOLDOWN_NBT_KEY, cooldownUntil.longValue());
            if (cooldownDuration != null) {
                persistentData.putLong(COOLDOWN_DURATION_NBT_KEY, cooldownDuration.longValue());
            }
            InstantWorldMirror.LOGGER.debug("Saved cooldown until {} (duration: {} ms) for {}", new Object[]{cooldownUntil, cooldownDuration, player.getName().getString()});
        }
        COOLDOWNS.remove(playerId);
        COOLDOWN_DURATIONS.remove(playerId);
    }

    public static void restoreCooldown(ServerPlayer player) {
        CompoundTag persistentData = player.getPersistentData();
        UUID playerId = player.getUUID();
        if (persistentData.contains(COOLDOWN_NBT_KEY)) {
            long now;
            long cooldownUntil = persistentData.getLong(COOLDOWN_NBT_KEY);
            if (cooldownUntil > (now = System.currentTimeMillis())) {
                COOLDOWNS.put(playerId, cooldownUntil);
                if (persistentData.contains(COOLDOWN_DURATION_NBT_KEY)) {
                    long cooldownDuration = persistentData.getLong(COOLDOWN_DURATION_NBT_KEY);
                    COOLDOWN_DURATIONS.put(playerId, cooldownDuration);
                }
                DimensionMirrorItem.syncCooldownToClient(player);
                InstantWorldMirror.LOGGER.debug("Restored cooldown for {} ({} ms remaining)", (Object)player.getName().getString(), (Object)(cooldownUntil - now));
            } else {
                InstantWorldMirror.LOGGER.debug("Cooldown expired while {} was offline", (Object)player.getName().getString());
            }
            persistentData.remove(COOLDOWN_NBT_KEY);
            persistentData.remove(COOLDOWN_DURATION_NBT_KEY);
        }
    }

    public InteractionResult useOn(UseOnContext context) {
        Level level = context.getLevel();
        BlockPos pos = context.getClickedPos();
        Player player = context.getPlayer();
        ItemStack stack = context.getItemInHand();
        BlockState state = level.getBlockState(pos);
        if (player == null) {
            return InteractionResult.PASS;
        }
        if (level.isClientSide) {
            return InteractionResult.PASS;
        }
        ServerPlayer serverPlayer = (ServerPlayer)player;
        if (!MirrorWorldManager.canAccessMirrorWorld(serverPlayer)) {
            player.displayClientMessage((Component)Component.translatable((String)"message.instantworldmirror.access_denied"), true);
            return InteractionResult.FAIL;
        }
        if (player.isCreative()) {
            DimensionMirrorItem.clearCooldown(player.getUUID());
            DimensionMirrorItem.syncCooldownToClient(serverPlayer);
            InstantWorldMirror.LOGGER.debug("Creative mode: cleared cooldown for {}", (Object)player.getName().getString());
        } else {
            long remainingMillis = DimensionMirrorItem.getRemainingCooldownMillis(player.getUUID());
            if (remainingMillis > 0L) {
                int seconds = (int)(remainingMillis / 1000L);
                player.displayClientMessage((Component)Component.translatable((String)"message.instantworldmirror.cooldown", (Object[])new Object[]{seconds}), true);
                return InteractionResult.FAIL;
            }
        }
        if (!state.isSolidRender((BlockGetter)level, pos)) {
            player.displayClientMessage((Component)Component.translatable((String)"message.instantworldmirror.invalid_block"), true);
            return InteractionResult.FAIL;
        }
        BlockPos portalPos = pos.above();
        BlockPos portalPosAbove = portalPos.above();
        BlockState portalState = level.getBlockState(portalPos);
        BlockState portalStateAbove = level.getBlockState(portalPosAbove);
        if (portalState.isSolid() || portalStateAbove.isSolid()) {
            player.displayClientMessage((Component)Component.translatable((String)"message.instantworldmirror.no_space_for_portal"), true);
            return InteractionResult.FAIL;
        }
        boolean isInMirrorWorld = ModDimensions.isMirrorWorld((ResourceKey<Level>)level.dimension());
        ServerLevel serverLevel = (ServerLevel)level;
        InteractionResult result = isInMirrorWorld ? this.createReturnPortal(serverLevel, serverPlayer, pos) : this.createEntryPortal(serverLevel, serverPlayer, pos);
        if (result == InteractionResult.SUCCESS && !player.isCreative()) {
            this.applyCooldown(serverPlayer, stack);
        }
        return result;
    }

    private void applyCooldown(ServerPlayer player, ItemStack stack) {
        int baseCooldownSeconds = MirrorConfig.getMirrorCooldownTicks() / 20;
        int efficiencyLevel = this.getEfficiencyLevel(player.level(), stack);
        double reduction = Math.min(0.9, (double)efficiencyLevel * 0.2);
        int finalCooldownSeconds = (int)((double)baseCooldownSeconds * (1.0 - reduction));
        finalCooldownSeconds = Math.max(30, finalCooldownSeconds);
        DimensionMirrorItem.setCooldown(player.getUUID(), finalCooldownSeconds);
        DimensionMirrorItem.syncCooldownToClient(player);
        InstantWorldMirror.LOGGER.debug("Applied cooldown {} seconds to {} (efficiency level: {})", new Object[]{finalCooldownSeconds, player.getName().getString(), efficiencyLevel});
    }

    public static void syncCooldownToClient(ServerPlayer player) {
        UUID playerId = player.getUUID();
        Long cooldownEnd = COOLDOWNS.get(playerId);
        Long totalDuration = COOLDOWN_DURATIONS.get(playerId);
        long timestamp = cooldownEnd != null ? cooldownEnd : 0L;
        long duration = totalDuration != null ? totalDuration : 0L;
        PacketDistributor.sendToPlayer((ServerPlayer)player, (CustomPacketPayload)new SyncCooldownPacket(timestamp, duration), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    private int getEfficiencyLevel(Level level, ItemStack stack) {
        RegistryAccess registryAccess = level.registryAccess();
        HolderLookup.RegistryLookup enchantmentRegistry = registryAccess.lookupOrThrow(Registries.ENCHANTMENT);
        Holder.Reference efficiencyHolder = enchantmentRegistry.getOrThrow(Enchantments.EFFICIENCY);
        return stack.getEnchantmentLevel((Holder)efficiencyHolder);
    }

    private InteractionResult createEntryPortal(ServerLevel level, ServerPlayer player, BlockPos pos) {
        if (MirrorWorldManager.hasActiveSession(player.getUUID())) {
            player.displayClientMessage((Component)Component.translatable((String)"message.instantworldmirror.already_has_session"), true);
            return InteractionResult.FAIL;
        }
        Optional<MirrorSession> sessionOpt = MirrorWorldManager.createSession(player, pos);
        if (sessionOpt.isEmpty()) {
            return InteractionResult.FAIL;
        }
        MirrorSession session = sessionOpt.get();
        level.playSound(null, pos, SoundEvents.PORTAL_TRIGGER, SoundSource.PLAYERS, 0.5f, 1.2f);
        this.spawnPortalParticles(level, pos);
        BlockPos spawnPos = pos.above();
        MirrorPortalEntity portal = new MirrorPortalEntity((Level)level, (double)spawnPos.getX() + 0.5, (double)spawnPos.getY() + 0.5, (double)spawnPos.getZ() + 0.5, player.getUUID(), session, pos);
        level.addFreshEntity((Entity)portal);
        player.displayClientMessage((Component)Component.translatable((String)"message.instantworldmirror.portal_created"), true);
        InstantWorldMirror.LOGGER.info("Player {} created entry portal with session {}", (Object)player.getName().getString(), (Object)session.getSessionId());
        return InteractionResult.SUCCESS;
    }

    private InteractionResult createReturnPortal(ServerLevel level, ServerPlayer player, BlockPos pos) {
        level.playSound(null, pos, SoundEvents.PORTAL_TRIGGER, SoundSource.PLAYERS, 0.5f, 1.2f);
        this.spawnPortalParticles(level, pos);
        MirrorPortalEntity.spawnReturnPortal(level, pos, player.getUUID(), false, null);
        player.displayClientMessage((Component)Component.translatable((String)"message.instantworldmirror.return_portal_created"), true);
        return InteractionResult.SUCCESS;
    }

    private void spawnPortalParticles(ServerLevel level, BlockPos pos) {
        double x = (double)pos.getX() + 0.5;
        double y = (double)pos.getY() + 1.0;
        double z = (double)pos.getZ() + 0.5;
        for (int i = 0; i < 20; ++i) {
            double offsetX = (level.random.nextDouble() - 0.5) * 2.0;
            double offsetY = level.random.nextDouble() * 2.0;
            double offsetZ = (level.random.nextDouble() - 0.5) * 2.0;
            level.sendParticles((ParticleOptions)ParticleTypes.PORTAL, x + offsetX, y + offsetY, z + offsetZ, 1, 0.0, 0.0, 0.0, 0.0);
        }
    }

    public boolean isFoil(ItemStack stack) {
        return stack.isEnchanted();
    }

    public boolean isEnchantable(ItemStack stack) {
        return true;
    }

    public int getEnchantmentValue() {
        return 22;
    }

    public boolean supportsEnchantment(ItemStack stack, Holder<Enchantment> enchantment) {
        return enchantment.is(Enchantments.EFFICIENCY);
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand hand) {
        ItemStack stack = player.getItemInHand(hand);
        if (ModDimensions.isMirrorWorld((ResourceKey<Level>)level.dimension())) {
            player.startUsingItem(hand);
            return InteractionResultHolder.consume((Object)stack);
        }
        return InteractionResultHolder.pass((Object)stack);
    }

    public int getUseDuration(ItemStack stack, LivingEntity entity) {
        Player player;
        if (entity instanceof Player && ModDimensions.isMirrorWorld((ResourceKey<Level>)(player = (Player)entity).level().dimension())) {
            return 20;
        }
        return 0;
    }

    public UseAnim getUseAnimation(ItemStack stack) {
        return UseAnim.BOW;
    }

    public ItemStack finishUsingItem(ItemStack stack, Level level, LivingEntity entity) {
        if (entity instanceof Player) {
            Player player = (Player)entity;
            if (ModDimensions.isMirrorWorld((ResourceKey<Level>)level.dimension()) && level.isClientSide) {
                PacketDistributor.sendToServer((CustomPacketPayload)new TeleportToSpawnPacket(), (CustomPacketPayload[])new CustomPacketPayload[0]);
            }
        }
        return stack;
    }
}

