/*
 * Decompiled with CFR 0.152.
 */
package com.crabmods.instantworldmirror.mixin;

import com.crabmods.instantworldmirror.world.ModDimensions;
import javax.annotation.Nullable;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={BlockEntity.class})
public abstract class BlockEntityMixin {
    @Shadow
    @Nullable
    public abstract Level getLevel();

    @Inject(method={"isValidBlockState"}, at={@At(value="HEAD")}, cancellable=true)
    private void onIsValidBlockState(BlockState state, CallbackInfoReturnable<Boolean> cir) {
        Level level = this.getLevel();
        if (level != null && ModDimensions.isAnyMirrorWorld((ResourceKey<Level>)level.dimension())) {
            cir.setReturnValue((Object)true);
        }
    }
}

