/*
 * Decompiled with CFR 0.152.
 */
package com.crabmods.instantworldmirror.network;

import com.crabmods.instantworldmirror.InstantWorldMirror;
import com.crabmods.instantworldmirror.client.MirrorDimensionEffectsManager;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public record ClearMirrorEffectsPacket(int mirrorDimIndex) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<ClearMirrorEffectsPacket> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"instantworldmirror", (String)"clear_mirror_effects"));
    public static final StreamCodec<FriendlyByteBuf, ClearMirrorEffectsPacket> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.VAR_INT, ClearMirrorEffectsPacket::mirrorDimIndex, ClearMirrorEffectsPacket::new);

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }

    public static void handle(ClearMirrorEffectsPacket packet, IPayloadContext context) {
        context.enqueueWork(() -> {
            MirrorDimensionEffectsManager.clearSourceEffects(packet.mirrorDimIndex);
            InstantWorldMirror.LOGGER.debug("Cleared mirror effects for dim {}", (Object)packet.mirrorDimIndex);
        });
    }
}

