/*
 * Decompiled with CFR 0.152.
 */
package com.crabmods.instantworldmirror.network;

import com.crabmods.instantworldmirror.InstantWorldMirror;
import com.crabmods.instantworldmirror.client.ClientCooldownTracker;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public record SyncCooldownPacket(long cooldownEndTimestamp, long totalCooldownMillis) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<SyncCooldownPacket> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"instantworldmirror", (String)"sync_cooldown"));
    public static final StreamCodec<FriendlyByteBuf, SyncCooldownPacket> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.VAR_LONG, SyncCooldownPacket::cooldownEndTimestamp, (StreamCodec)ByteBufCodecs.VAR_LONG, SyncCooldownPacket::totalCooldownMillis, SyncCooldownPacket::new);

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }

    public static void handle(SyncCooldownPacket packet, IPayloadContext context) {
        context.enqueueWork(() -> {
            ClientCooldownTracker.setCooldown(packet.cooldownEndTimestamp, packet.totalCooldownMillis);
            InstantWorldMirror.LOGGER.debug("Received cooldown sync: end timestamp = {}, total = {} ms", (Object)packet.cooldownEndTimestamp, (Object)packet.totalCooldownMillis);
        });
    }
}

