/*
 * Decompiled with CFR 0.152.
 */
package com.crabmods.instantworldmirror.network;

import com.crabmods.instantworldmirror.InstantWorldMirror;
import com.crabmods.instantworldmirror.client.MirrorDimensionEffectsManager;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public record SyncMirrorEffectsPacket(int mirrorDimIndex, String sourceEffects) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<SyncMirrorEffectsPacket> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"instantworldmirror", (String)"sync_mirror_effects"));
    public static final StreamCodec<FriendlyByteBuf, SyncMirrorEffectsPacket> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.VAR_INT, SyncMirrorEffectsPacket::mirrorDimIndex, (StreamCodec)ByteBufCodecs.STRING_UTF8, SyncMirrorEffectsPacket::sourceEffects, SyncMirrorEffectsPacket::new);

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }

    public static void handle(SyncMirrorEffectsPacket packet, IPayloadContext context) {
        context.enqueueWork(() -> {
            ResourceLocation effectsLoc = ResourceLocation.parse((String)packet.sourceEffects);
            MirrorDimensionEffectsManager.setSourceEffects(packet.mirrorDimIndex, effectsLoc);
            InstantWorldMirror.LOGGER.debug("Received mirror effects sync: dim {} -> {}", (Object)packet.mirrorDimIndex, (Object)packet.sourceEffects);
        });
    }
}

